/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view;

import hudson.Extension;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TopLevelItem;
import hudson.model.TransientViewActionFactory;
import hudson.model.View;
import hudson.plugins.depgraph_view.AbstractDependencyGraphAction;
import hudson.plugins.depgraph_view.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class DependencyGraphViewActionFactory
extends TransientViewActionFactory {
    public List<Action> createFor(View v) {
        return Collections.singletonList(new DependencyGraphViewAction(v));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DependencyGraphViewAction
    extends AbstractDependencyGraphAction
    implements Action {
        private View view;

        public DependencyGraphViewAction(View view) {
            this.view = view;
        }

        @Override
        protected Collection<? extends AbstractProject<?, ?>> getProjectsForDepgraph() {
            Collection items = this.view.getItems();
            ArrayList<AbstractProject> projects = new ArrayList<AbstractProject>();
            for (TopLevelItem item : items) {
                if (!(item instanceof AbstractProject)) continue;
                projects.add((AbstractProject)item);
            }
            return projects;
        }

        @Override
        public String getTitle() {
            return Messages.AbstractDependencyGraphAction_DependencyGraphOf(this.view.getDisplayName());
        }

        @Override
        public AbstractModelObject getParentObject() {
            return this.view;
        }
    }
}

