/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bamboo;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooNotifier
extends Notifier {
    public final String jobName;
    public final String serverAddress;
    public final String username;
    public final String password;
    public final boolean triggerUnstable;

    @DataBoundConstructor
    public BambooNotifier(String jobName, String serverAddress, String username, String password, boolean triggerUnstable) {
        this.serverAddress = serverAddress.endsWith("/") ? serverAddress : serverAddress + "/";
        this.jobName = jobName;
        this.username = username;
        this.password = password;
        this.triggerUnstable = triggerUnstable;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.SUCCESS) {
            this.triggerBamboo(listener);
        } else if (this.triggerUnstable && build.getResult() == Result.UNSTABLE) {
            listener.getLogger().println("Triggering unstable build");
            this.triggerBamboo(listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerBamboo(BuildListener listener) {
        String url = this.serverAddress + "rest/api/latest/queue/" + this.jobName + "?os_authType=basic";
        listener.getLogger().printf("Triggering Bamboo job %s%n", url);
        PostMethod postMethod = new PostMethod(url);
        HttpClient client = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        try {
            int status = client.executeMethod((HttpMethod)postMethod);
            listener.getLogger().printf("Response code: %d%n", status);
        }
        catch (HttpException e) {
            e.printStackTrace(listener.error("Unable to notify Bamboo URL %s", new Object[]{url}));
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Unable to connect to Bamboo URL %s", new Object[]{url}));
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Bamboo Notifier";
        }
    }
}

