/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blame_upstream_commiters;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlameUpstreamCommitersPublisher
extends Notifier {
    protected static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public boolean sendToIndividuals = false;

    @DataBoundConstructor
    public BlameUpstreamCommitersPublisher() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Set upstreamProjects;
        if (build.getResult() != Result.SUCCESS && !(upstreamProjects = this.getUpstreamProjects(build)).isEmpty()) {
            Collection namesCollection = Collections2.transform((Collection)upstreamProjects, (Function)new /* Unavailable Anonymous Inner Class!! */);
            listener.getLogger().println("Upstream projects changes detected. Mailing upstream committers in the following projects:");
            listener.getLogger().println(StringUtils.join((Collection)namesCollection, (String)","));
            return new /* Unavailable Anonymous Inner Class!! */.execute(build, listener);
        }
        return true;
    }

    private Set<AbstractProject> getUpstreamProjects(AbstractBuild<?, ?> build) {
        return build.getUpstreamBuilds().keySet();
    }
}

