/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.cmake.CmakeBuilder;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmakeBuilder
extends Builder {
    private static final String CMAKE = "cmake";
    private static final String MAKE = "make";
    private static final String MAKE_INSTALL = "make install";
    private String sourceDir;
    private String buildDir;
    private String installDir;
    private String buildType;
    private String cmakeArgs;
    private boolean cleanBuild;
    private CmakeBuilderImpl builderImpl;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CmakeBuilder(String sourceDir, String buildDir, String installDir, String buildType, String cmakeArgs) {
        this.sourceDir = sourceDir;
        this.buildDir = buildDir;
        this.installDir = installDir;
        this.buildType = buildType;
        this.cmakeArgs = cmakeArgs;
        this.cleanBuild = false;
        this.builderImpl = new CmakeBuilderImpl();
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getCmakeArgs() {
        return this.cmakeArgs;
    }

    public boolean getCleanBuild() {
        return this.cleanBuild;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) {
        listener.getLogger().println("MODULE: " + build.getProject().getModuleRoot());
        if (this.builderImpl == null) {
            this.builderImpl = new CmakeBuilderImpl();
        }
        String theSourceDir = "";
        String theInstallDir = "";
        try {
            this.builderImpl.preparePath(build.getEnvVars(), this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
            theSourceDir = this.builderImpl.preparePath(build.getEnvVars(), this.sourceDir, CmakeBuilderImpl.PreparePathOptions.CHECK_PATH_EXISTS);
            theInstallDir = this.builderImpl.preparePath(build.getEnvVars(), this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        catch (IOException ioe) {
            listener.getLogger().println(ioe.getMessage());
            return false;
        }
        String cmakeBin = CMAKE;
        if (DESCRIPTOR.cmakePath() != null && DESCRIPTOR.cmakePath().length() > 0) {
            cmakeBin = DESCRIPTOR.cmakePath();
        }
        String cmakeCall = this.builderImpl.buildCMakeCall(cmakeBin, theSourceDir, theInstallDir, this.buildType, this.cmakeArgs);
        FilePath workDir = new FilePath(build.getProject().getWorkspace(), this.buildDir);
        listener.getLogger().println("CMake call : " + cmakeCall);
        try {
            Proc proc = launcher.launch(cmakeCall, build.getEnvVars(), (OutputStream)listener.getLogger(), workDir);
            int result = proc.join();
            if (result != 0) {
                return false;
            }
            proc = launcher.launch(MAKE, build.getEnvVars(), (OutputStream)listener.getLogger(), workDir);
            result = proc.join();
            if (result != 0) {
                return false;
            }
            proc = launcher.launch(MAKE_INSTALL, build.getEnvVars(), (OutputStream)listener.getLogger(), workDir);
            result = proc.join();
            return result == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

