/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.cmake.CmakeBuilder;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class CmakeBuilder
extends Builder {
    private static final String CMAKE = "cmake";
    private String sourceDir;
    private String buildDir;
    private String installDir;
    private String buildType;
    private String generator;
    private String makeCommand;
    private String installCommand;
    private String cmakeArgs;
    private boolean cleanBuild;
    private CmakeBuilderImpl builderImpl;

    @DataBoundConstructor
    public CmakeBuilder(String sourceDir, String buildDir, String installDir, String buildType, String generator, String makeCommand, String installCommand, String cmakeArgs) {
        this.sourceDir = sourceDir;
        this.buildDir = buildDir;
        this.installDir = installDir;
        this.buildType = buildType;
        this.generator = generator;
        this.makeCommand = makeCommand;
        this.installCommand = installCommand;
        this.cmakeArgs = cmakeArgs;
        this.cleanBuild = false;
        this.builderImpl = new CmakeBuilderImpl();
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public String getCmakeArgs() {
        return this.cmakeArgs;
    }

    public boolean getCleanBuild() {
        return this.cleanBuild;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String theInstallDir;
        String theSourceDir;
        listener.getLogger().println("MODULE: " + build.getProject().getModuleRoot());
        if (this.builderImpl == null) {
            this.builderImpl = new CmakeBuilderImpl();
        }
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        try {
            this.builderImpl.preparePath((Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
            theSourceDir = this.builderImpl.preparePath((Map)envs, this.sourceDir, CmakeBuilderImpl.PreparePathOptions.CHECK_PATH_EXISTS);
            theInstallDir = this.builderImpl.preparePath((Map)envs, this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        catch (IOException ioe) {
            listener.getLogger().println(ioe.getMessage());
            return false;
        }
        String cmakeBin = CMAKE;
        String cmakePath = this.getDescriptor().cmakePath();
        if (cmakePath != null && cmakePath.length() > 0) {
            cmakeBin = cmakePath;
        }
        String cmakeCall = this.builderImpl.buildCMakeCall(cmakeBin, this.generator, theSourceDir, theInstallDir, this.buildType, this.cmakeArgs);
        FilePath workDir = new FilePath(build.getProject().getWorkspace(), this.buildDir);
        listener.getLogger().println("CMake call : " + cmakeCall);
        try {
            Proc proc = launcher.launch(cmakeCall, (Map)envs, (OutputStream)listener.getLogger(), workDir);
            int result = proc.join();
            if (result != 0) {
                return false;
            }
            proc = launcher.launch(this.getMakeCommand(), (Map)envs, (OutputStream)listener.getLogger(), workDir);
            result = proc.join();
            if (result != 0) {
                return false;
            }
            proc = launcher.launch(this.getInstallCommand(), (Map)envs, (OutputStream)listener.getLogger(), workDir);
            result = proc.join();
            return result == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

