/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmakeBuilderImpl {
    private static final String DCMAKE_BUILD_TYPE = "-DCMAKE_BUILD_TYPE=";
    private static final String DCMAKE_INSTALL_PREFIX = "-DCMAKE_INSTALL_PREFIX=";
    private static final String BLANK = " ";

    String preparePath(Map<String, String> envVars, String path, PreparePathOptions ppOption) throws IOException {
        path = path.trim();
        Set<String> keys = envVars.keySet();
        for (String key : keys) {
            path = path.replaceAll("\\$" + key, envVars.get(key));
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            path = envVars.get("WORKSPACE") + "/" + path;
        }
        file = new File(path);
        ppOption.process(file);
        return file.getPath();
    }

    String buildCMakeCall(String cmakeBin, String generator, String sourceDir, String installDir, String buildType, String cmakeArgs) {
        return cmakeBin + BLANK + sourceDir + BLANK + "-G \"" + generator + "\"" + BLANK + DCMAKE_INSTALL_PREFIX + installDir + BLANK + DCMAKE_BUILD_TYPE + buildType + BLANK + cmakeArgs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreparePathOptions {
        CHECK_PATH_EXISTS{

            public void process(File file) throws IOException {
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
            }
        }
        ,
        CREATE_IF_NOT_EXISTING{

            public void process(File file) throws IOException {
                if (!file.exists() && !file.mkdir()) {
                    throw new IOException("Directory could not be created: " + file.getAbsolutePath());
                }
            }
        }
        ,
        CREATE_NEW_IF_EXISTS{

            public void process(File file) throws IOException {
                if (file.exists() && file.isDirectory() && !this.deleteDirectory(file)) {
                    throw new IOException("Unable to delete directory " + file.getAbsolutePath());
                }
                CREATE_IF_NOT_EXISTING.process(file);
            }

            private boolean deleteDirectory(File path) {
                if (path.exists()) {
                    File[] files = path.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            this.deleteDirectory(files[i]);
                            continue;
                        }
                        files[i].delete();
                    }
                }
                return path.delete();
            }
        };


        public abstract void process(File var1) throws IOException;
    }
}

