/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.cmake.CmakeBuilder;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class CmakeBuilder
extends Builder {
    private static final String CMAKE = "cmake";
    private String sourceDir;
    private String buildDir;
    private String installDir;
    private String buildType;
    private String generator;
    private String makeCommand;
    private String installCommand;
    private String preloadScript;
    private String cmakeArgs;
    private boolean cleanBuild;
    private CmakeBuilderImpl builderImpl;

    @DataBoundConstructor
    public CmakeBuilder(String sourceDir, String buildDir, String installDir, String buildType, boolean cleanBuild, String generator, String makeCommand, String installCommand, String preloadScript, String cmakeArgs) {
        this.sourceDir = sourceDir;
        this.buildDir = buildDir;
        this.installDir = installDir;
        this.buildType = buildType;
        this.cleanBuild = cleanBuild;
        this.generator = generator;
        this.makeCommand = makeCommand;
        this.installCommand = installCommand;
        this.cmakeArgs = cmakeArgs;
        this.preloadScript = preloadScript;
        this.builderImpl = new CmakeBuilderImpl();
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public boolean getCleanBuild() {
        return this.cleanBuild;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public String getPreloadScript() {
        return this.preloadScript;
    }

    public String getCmakeArgs() {
        return this.cmakeArgs;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String theInstallDir;
        String theSourceDir;
        listener.getLogger().println("MODULE: " + build.getModuleRoot());
        if (this.builderImpl == null) {
            this.builderImpl = new CmakeBuilderImpl();
        }
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        FilePath workDir = new FilePath(build.getProject().getWorkspace(), this.buildDir);
        try {
            if (this.cleanBuild) {
                listener.getLogger().println("Cleaning Build Dir... " + workDir.toString());
                this.builderImpl.preparePath((Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
            } else {
                this.builderImpl.preparePath((Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_IF_NOT_EXISTING);
            }
            theSourceDir = this.builderImpl.preparePath((Map)envs, this.sourceDir, CmakeBuilderImpl.PreparePathOptions.CHECK_PATH_EXISTS);
            theInstallDir = this.builderImpl.preparePath((Map)envs, this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        catch (IOException ioe) {
            listener.getLogger().println(ioe.getMessage());
            return false;
        }
        String cmakeBin = CMAKE;
        String cmakePath = this.getDescriptor().cmakePath();
        if (cmakePath != null && cmakePath.length() > 0) {
            cmakeBin = cmakePath;
        }
        String cmakeCall = this.builderImpl.buildCMakeCall(cmakeBin, this.generator, this.preloadScript, theSourceDir, theInstallDir, this.buildType, this.cmakeArgs);
        listener.getLogger().println("Build dir  : " + workDir.toString());
        listener.getLogger().println("CMake call : " + cmakeCall);
        try {
            int result = launcher.launch().cmds(Util.tokenize((String)cmakeCall)).envs((Map)envs).stdout((TaskListener)listener).pwd(workDir).join();
            if (result != 0) {
                return false;
            }
            if (!this.getMakeCommand().trim().isEmpty() && (result = launcher.launch().cmds(Util.tokenize((String)this.getMakeCommand())).envs((Map)envs).stdout((TaskListener)listener).pwd(workDir).join()) != 0) {
                return false;
            }
            if (!this.getInstallCommand().trim().isEmpty()) {
                result = launcher.launch().cmds(Util.tokenize((String)this.getInstallCommand())).envs((Map)envs).stdout((TaskListener)listener).pwd(workDir).join();
            }
            return result == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

