/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmakeBuilderImpl {
    private static final String DCMAKE_BUILD_TYPE = "-DCMAKE_BUILD_TYPE=";
    private static final String DCMAKE_INSTALL_PREFIX = "-DCMAKE_INSTALL_PREFIX=";
    private static final String BLANK = " ";

    String preparePath(FilePath workSpace, Map<String, String> envVars, String path, PreparePathOptions ppOption) throws IOException {
        path = path.trim();
        Set<String> keys = envVars.keySet();
        for (String key : keys) {
            path = path.replaceAll("\\$" + key, envVars.get(key));
        }
        FilePath file = workSpace.child(path);
        ppOption.process(file);
        return file.getRemote();
    }

    String buildCMakeCall(String cmakeBin, String generator, String preloadScript, String sourceDir, String installDir, String buildType, String cmakeArgs) {
        return cmakeBin + BLANK + this.createPreloadScriptArg(preloadScript) + BLANK + "-G \"" + generator + "\"" + BLANK + DCMAKE_INSTALL_PREFIX + installDir + BLANK + DCMAKE_BUILD_TYPE + buildType + BLANK + cmakeArgs + BLANK + "\"" + sourceDir + "\"" + BLANK;
    }

    private String createPreloadScriptArg(String preloadScript) {
        if (preloadScript == null || preloadScript.trim().isEmpty()) {
            return "";
        }
        return " -C \"" + preloadScript.trim() + "\"";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreparePathOptions {
        CHECK_PATH_EXISTS{

            public void process(FilePath file) throws IOException {
                try {
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getRemote());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        ,
        CREATE_IF_NOT_EXISTING{

            public void process(FilePath file) throws IOException {
                try {
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        ,
        CREATE_NEW_IF_EXISTS{

            public void process(FilePath file) throws IOException {
                try {
                    if (file.exists() && file.isDirectory()) {
                        file.deleteRecursive();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CREATE_IF_NOT_EXISTING.process(file);
            }
        };


        public abstract void process(FilePath var1) throws IOException;
    }
}

