/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.cmake.CmakeBuilder;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class CmakeBuilder
extends Builder {
    private static final String CMAKE = "cmake";
    private String sourceDir;
    private String buildDir;
    private String installDir;
    private String buildType;
    private String otherBuildType;
    private String generator;
    private String makeCommand;
    private String installCommand;
    private String preloadScript;
    private String cmakeArgs;
    private boolean cleanBuild;
    private CmakeBuilderImpl builderImpl;

    @DataBoundConstructor
    public CmakeBuilder(String sourceDir, String buildDir, String installDir, String buildType, String otherBuildType, boolean cleanBuild, String generator, String makeCommand, String installCommand, String preloadScript, String cmakeArgs) {
        this.sourceDir = sourceDir;
        this.buildDir = buildDir;
        this.installDir = installDir;
        this.buildType = buildType;
        this.otherBuildType = otherBuildType;
        this.cleanBuild = cleanBuild;
        this.generator = generator;
        this.makeCommand = makeCommand;
        this.installCommand = installCommand;
        this.cmakeArgs = cmakeArgs;
        this.preloadScript = preloadScript;
        this.builderImpl = new CmakeBuilderImpl();
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getOtherBuildType() {
        return this.otherBuildType;
    }

    public boolean getCleanBuild() {
        return this.cleanBuild;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public String getPreloadScript() {
        return this.preloadScript;
    }

    public String getCmakeArgs() {
        return this.cmakeArgs;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String theInstallDir;
        String theSourceDir;
        listener.getLogger().println("MODULE: " + build.getModuleRoot());
        if (this.builderImpl == null) {
            this.builderImpl = new CmakeBuilderImpl();
        }
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        FilePath workSpace = build.getProject().getWorkspace();
        String theBuildDir = this.buildDir;
        try {
            if (this.cleanBuild) {
                listener.getLogger().println("Cleaning Build Dir... " + this.buildDir);
                theBuildDir = this.builderImpl.preparePath(workSpace, (Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
            } else {
                theBuildDir = this.builderImpl.preparePath(workSpace, (Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_IF_NOT_EXISTING);
            }
            theSourceDir = this.builderImpl.preparePath(workSpace, (Map)envs, this.sourceDir, CmakeBuilderImpl.PreparePathOptions.CHECK_PATH_EXISTS);
            theInstallDir = this.builderImpl.preparePath(workSpace, (Map)envs, this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        catch (IOException ioe) {
            listener.getLogger().println(ioe.getMessage());
            return false;
        }
        String theBuildType = this.buildType;
        if (this.otherBuildType != null && this.otherBuildType.length() > 0) {
            theBuildType = this.otherBuildType;
        }
        listener.getLogger().println("Build   dir  : " + theBuildDir.toString());
        listener.getLogger().println("Source  dir  : " + theSourceDir.toString());
        listener.getLogger().println("Install dir  : " + theInstallDir.toString());
        String cmakeBin = this.checkCmake(build.getBuiltOn(), listener);
        String cmakeCall = this.builderImpl.buildCMakeCall(cmakeBin, this.generator, this.preloadScript, theSourceDir, theInstallDir, theBuildType, this.cmakeArgs);
        listener.getLogger().println("CMake call : " + cmakeCall);
        try {
            boolean doInstall;
            int result = launcher.launch(cmakeCall, (Map)envs, (OutputStream)listener.getLogger(), new FilePath(workSpace, theBuildDir)).join();
            if (result != 0) {
                return false;
            }
            if (!this.getMakeCommand().trim().isEmpty() && (result = launcher.launch(this.getMakeCommand(), (Map)envs, (OutputStream)listener.getLogger(), new FilePath(workSpace, theBuildDir)).join()) != 0) {
                return false;
            }
            boolean bl = doInstall = !theInstallDir.isEmpty() && !this.getInstallCommand().trim().isEmpty();
            if (doInstall) {
                result = launcher.launch(this.getInstallCommand(), (Map)envs, (OutputStream)listener.getLogger(), new FilePath(workSpace, theBuildDir)).join();
            }
            return result == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    private String checkCmake(Node node, BuildListener listener) throws IOException, InterruptedException {
        String cmakeBin = CMAKE;
        String cmakePath = this.getDescriptor().cmakePath();
        if (cmakePath != null && cmakePath.length() > 0) {
            cmakeBin = cmakePath;
        }
        Proc proc = node.createLauncher((TaskListener)listener).launch(cmakeBin + " -version", new HashMap(), (OutputStream)listener.getLogger(), node.getRootPath());
        proc.join();
        return cmakeBin;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

