/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CmakeBuilder
extends Builder {
    private static final String CMAKE = "cmake";
    private String sourceDir;
    private String buildDir;
    private String installDir;
    private String buildType;
    private String otherBuildType;
    private String generator;
    private String makeCommand;
    private String installCommand;
    private String preloadScript;
    private String cmakeArgs;
    private boolean cleanBuild;
    private CmakeBuilderImpl builderImpl;

    @DataBoundConstructor
    public CmakeBuilder(String sourceDir, String buildDir, String installDir, String buildType, String otherBuildType, boolean cleanBuild, String generator, String makeCommand, String installCommand, String preloadScript, String cmakeArgs) {
        this.sourceDir = sourceDir;
        this.buildDir = buildDir;
        this.installDir = installDir;
        this.buildType = buildType;
        this.otherBuildType = otherBuildType;
        this.cleanBuild = cleanBuild;
        this.generator = generator;
        this.makeCommand = makeCommand;
        this.installCommand = installCommand;
        this.cmakeArgs = cmakeArgs;
        this.preloadScript = preloadScript;
        this.builderImpl = new CmakeBuilderImpl();
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getOtherBuildType() {
        return this.otherBuildType;
    }

    public boolean getCleanBuild() {
        return this.cleanBuild;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public String getPreloadScript() {
        return this.preloadScript;
    }

    public String getCmakeArgs() {
        return this.cmakeArgs;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String theInstallDir;
        String theSourceDir;
        listener.getLogger().println("MODULE: " + build.getModuleRoot());
        if (this.builderImpl == null) {
            this.builderImpl = new CmakeBuilderImpl();
        }
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        FilePath workSpace = build.getProject().getWorkspace();
        String theBuildDir = this.buildDir;
        try {
            if (this.cleanBuild) {
                listener.getLogger().println("Cleaning Build Dir... " + this.buildDir);
                theBuildDir = this.builderImpl.preparePath(workSpace, (Map<String, String>)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
            } else {
                theBuildDir = this.builderImpl.preparePath(workSpace, (Map<String, String>)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_IF_NOT_EXISTING);
            }
            theSourceDir = this.builderImpl.preparePath(workSpace, (Map<String, String>)envs, this.sourceDir, CmakeBuilderImpl.PreparePathOptions.CHECK_PATH_EXISTS);
            theInstallDir = this.builderImpl.preparePath(workSpace, (Map<String, String>)envs, this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        catch (IOException ioe) {
            listener.getLogger().println(ioe.getMessage());
            return false;
        }
        String theBuildType = this.buildType;
        if (this.otherBuildType.length() > 0) {
            theBuildType = this.otherBuildType;
        }
        listener.getLogger().println("Build   dir  : " + theBuildDir.toString());
        listener.getLogger().println("Source  dir  : " + theSourceDir.toString());
        listener.getLogger().println("Install dir  : " + theInstallDir.toString());
        String cmakeBin = this.checkCmake(build.getBuiltOn(), listener);
        String cmakeCall = this.builderImpl.buildCMakeCall(cmakeBin, this.generator, this.preloadScript, theSourceDir, theInstallDir, theBuildType, this.cmakeArgs);
        listener.getLogger().println("CMake call : " + cmakeCall);
        try {
            boolean doInstall;
            int result = launcher.launch(cmakeCall, (Map)envs, (OutputStream)listener.getLogger(), new FilePath(workSpace, theBuildDir)).join();
            if (result != 0) {
                return false;
            }
            if (!this.getMakeCommand().trim().isEmpty() && (result = launcher.launch(this.getMakeCommand(), (Map)envs, (OutputStream)listener.getLogger(), new FilePath(workSpace, theBuildDir)).join()) != 0) {
                return false;
            }
            boolean bl = doInstall = !theInstallDir.isEmpty() && !this.getInstallCommand().trim().isEmpty();
            if (doInstall) {
                result = launcher.launch(this.getInstallCommand(), (Map)envs, (OutputStream)listener.getLogger(), new FilePath(workSpace, theBuildDir)).join();
            }
            return result == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    private String checkCmake(Node node, BuildListener listener) throws IOException, InterruptedException {
        String cmakeBin = CMAKE;
        String cmakePath = this.getDescriptor().cmakePath();
        if (cmakePath != null && cmakePath.length() > 0) {
            cmakeBin = cmakePath;
        }
        Proc proc = node.createLauncher((TaskListener)listener).launch(cmakeBin + " -version", new HashMap(), (OutputStream)listener.getLogger(), node.getRootPath());
        proc.join();
        return cmakeBin;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String cmakePath;
        private transient List<String> allowedBuildTypes;
        private transient String errorMessage;

        public DescriptorImpl() {
            super(CmakeBuilder.class);
            this.load();
            this.allowedBuildTypes = new ArrayList<String>();
            this.allowedBuildTypes.add("Debug");
            this.allowedBuildTypes.add("Release");
            this.allowedBuildTypes.add("RelWithDebInfo");
            this.allowedBuildTypes.add("MinSizeRel");
            this.errorMessage = "Must be one of Debug, Release, RelWithDebInfo, MinSizeRel";
        }

        public FormValidation doCheckSourceDir(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            FilePath ws = project.getSomeWorkspace();
            if (ws == null) {
                return FormValidation.ok();
            }
            return ws.validateRelativePath(value, true, false);
        }

        public FormValidation doCheckBuildDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a build directory");
            }
            if (value.length() < 1) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            File file = new File(value);
            if (file.isFile()) {
                return FormValidation.error((String)"build dir is a file");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBuildType(@QueryParameter String value) throws IOException, ServletException {
            for (String allowed : this.allowedBuildTypes) {
                if (!value.equals(allowed)) continue;
                return FormValidation.ok();
            }
            if (value.length() > 0) {
                return FormValidation.error((String)this.errorMessage);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMakeCommand(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set make command");
            }
            return FormValidation.validateExecutable((String)value);
        }

        public String getDisplayName() {
            return "CMake Build";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.cmakePath = o.getString("cmakePath");
            this.save();
            return super.configure(req, o);
        }

        public String cmakePath() {
            return this.cmakePath;
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(CmakeBuilder.class, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }
    }
}

