/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.BulkOperator;
import com.serena.dmclient.api.DimensionsConnection;
import com.serena.dmclient.api.DimensionsConnectionDetails;
import com.serena.dmclient.api.DimensionsConnectionManager;
import com.serena.dmclient.api.DimensionsDatabaseAdmin;
import com.serena.dmclient.api.DimensionsNetworkException;
import com.serena.dmclient.api.DimensionsObjectFactory;
import com.serena.dmclient.api.DimensionsRelatedObject;
import com.serena.dmclient.api.DimensionsResult;
import com.serena.dmclient.api.DimensionsRuntimeException;
import com.serena.dmclient.api.Filter;
import com.serena.dmclient.api.ItemRevision;
import com.serena.dmclient.api.Project;
import com.serena.dmclient.objects.DimensionsObject;
import hudson.FilePath;
import hudson.plugins.dimensionsscm.DateUtils;
import hudson.plugins.dimensionsscm.DimensionsChangeLogWriter;
import hudson.plugins.dimensionsscm.DimensionsChangeSet;
import hudson.plugins.dimensionsscm.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DimensionsAPI {
    private static final String MISSING_SOURCE_PATH = "The nested element needs a valid 'srcpath' attribute";
    private static final String MISSING_PROJECT = "The nested element needs a valid project to work on";
    private static final String BAD_BASE_DATABASE_SPEC = "The <dimensions> task needs a valid 'database' attribute, in the format 'dbname@dbconn'";
    private static final String NO_COMMAND_LINE = "The <run> nested element need a valid 'cmd' attribute";
    private static final String SRCITEM_SRCPATH_CONFLICT = "The <getcopy> nested element needs exactly one of the 'srcpath' or 'srcitem' attributes";
    private String dmServer;
    private String dmDb;
    private String dbName;
    private String dbConn;
    private String dmUser;
    private String dmPasswd;
    private String dmProject;
    private String dmDirectory;
    private String dmRequest;
    private String projectPath;
    private String dateType = "edit";
    private boolean allRevisions = false;
    private DimensionsConnection connection = null;

    public final String getSCMUserID() {
        return this.dmUser;
    }

    public final String getSCMDatabase() {
        return this.dmDb;
    }

    public final String getSCMBaseDb() {
        return this.dbName;
    }

    public final String getSCMDsn() {
        return this.dbConn;
    }

    public final String getSCMServer() {
        return this.dmServer;
    }

    public final String getSCMProject() {
        return this.dmProject;
    }

    public final String getSCMPath() {
        return this.projectPath;
    }

    public final DimensionsConnection getCon() {
        return this.connection;
    }

    public final boolean login(String userID, String password, String database, String server) throws IllegalArgumentException, ParseException {
        if (this.connection == null) {
            this.connection = DimensionsConnectionManager.getThreadConnection();
        }
        if (this.connection == null) {
            this.dmServer = server;
            this.dmDb = database;
            this.dmUser = userID;
            this.dmPasswd = password;
            Logger.Debug("Logging into Dimensions: " + this.dmUser + " " + this.dmServer + " " + this.dmDb);
            if (this.dmServer == null || this.dmServer.length() == 0 || this.dmDb == null || this.dmDb.length() == 0 || this.dmUser == null || this.dmUser.length() == 0 || this.dmPasswd == null || this.dmPasswd.length() == 0) {
                throw new IllegalArgumentException("Invalid or not parameters have been specified");
            }
            String[] dbCompts = DimensionsAPI.parseDatabaseString(this.dmDb);
            this.dbName = dbCompts[0];
            this.dbConn = dbCompts[1];
            DimensionsConnectionDetails details = new DimensionsConnectionDetails();
            details.setUsername(this.dmUser);
            details.setPassword(this.dmPasswd);
            details.setDbName(this.dbName);
            details.setDbConn(this.dbConn);
            details.setServer(this.dmServer);
            this.connection = DimensionsConnectionManager.getConnection((DimensionsConnectionDetails)details);
            if (this.connection != null) {
                DimensionsConnectionManager.registerThreadConnection((DimensionsConnection)this.connection);
            }
        }
        return this.connection != null;
    }

    public final void logout() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (DimensionsNetworkException dne) {
            }
            catch (DimensionsRuntimeException dimensionsRuntimeException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    private static String[] parseDatabaseString(String database) throws ParseException {
        String[] dbCompts;
        int endName = database.indexOf(47);
        int startConn = database.indexOf(64);
        if (startConn < 1 || startConn == database.length() - 1) {
            throw new ParseException(BAD_BASE_DATABASE_SPEC, startConn);
        }
        String dbName = null;
        String dbConn = null;
        String dbPassword = null;
        if (endName < 0 || startConn <= endName) {
            dbName = database.substring(0, startConn);
            dbConn = database.substring(startConn + 1);
            dbCompts = new String[]{dbName, dbConn};
        } else {
            if (endName == 0 || startConn == endName + 1) {
                throw new ParseException(BAD_BASE_DATABASE_SPEC, endName);
            }
            dbName = database.substring(0, endName);
            dbPassword = database.substring(endName + 1, startConn);
            dbConn = database.substring(startConn + 1);
            dbCompts = new String[]{dbName, dbConn, dbPassword};
        }
        return dbCompts;
    }

    public boolean hasRepositoryBeenUpdated(String projectName, FilePath workspace, Calendar fromDate, Calendar toDate, TimeZone tz) throws IOException, InterruptedException {
        boolean bChanged = false;
        if (fromDate == null) {
            return true;
        }
        if (this.connection == null) {
            throw new IOException("Not connected to an SCM repository");
        }
        try {
            List items = this.calcRepositoryDiffs(projectName, workspace, fromDate, toDate, tz);
            if (items != null) {
                bChanged = items.size() > 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to run hasRepositoryBeenUpdated - " + e.getMessage());
        }
        return bChanged;
    }

    public boolean checkout(String projectName, FilePath projectDir, FilePath workspaceName, Calendar fromDate, Calendar toDate, File changelogFile, TimeZone tz, StringBuffer cmdOutput, String url, boolean doFullUpdate, boolean doRevert) throws IOException, InterruptedException {
        boolean bRet;
        block27: {
            bRet = false;
            int version = 2009;
            if (this.connection == null) {
                throw new IOException("Not connected to an SCM repository");
            }
            try {
                List items;
                List inf = this.getCon().getObjectFactory().getServerVersion(2);
                if (inf == null) {
                    Logger.Debug("Detection of server information failed");
                }
                if (inf != null) {
                    Logger.Debug("Server information detected -" + inf.size());
                    for (int i = 0; i < inf.size(); ++i) {
                        String prop = (String)inf.get(i);
                        Logger.Debug(i + " - " + prop);
                    }
                    String server = (String)inf.get(2);
                    if (server == null) {
                        server = (String)inf.get(0);
                    }
                    if (server != null) {
                        Logger.Debug("Detected server version: " + server);
                        String[] tokens = server.split(" ");
                        server = tokens[0];
                        version = server.startsWith("10.") ? 10 : (server.startsWith("2009") ? 2009 : (server.startsWith("201") ? 2010 : 2009));
                        Logger.Debug("Version to process set to " + version);
                    } else {
                        Logger.Debug("No server information found");
                    }
                }
                String coCmd = "UPDATE /BRIEF ";
                if (version == 10) {
                    coCmd = "DOWNLOAD ";
                }
                if ((items = this.calcRepositoryDiffs(projectName, projectDir, fromDate, toDate, tz)) != null || doFullUpdate) {
                    DimensionsResult res;
                    File logFile = new File("a");
                    FileWriter logFileWriter = null;
                    PrintWriter fmtWriter = null;
                    File tmpFile = null;
                    if (items != null && !doFullUpdate) {
                        try {
                            tmpFile = File.createTempFile("dmCm" + toDate.getTimeInMillis(), null, null);
                            logFileWriter = new FileWriter(tmpFile);
                            fmtWriter = new PrintWriter((Writer)logFileWriter, true);
                            for (int i = 0; i < items.size(); ++i) {
                                ItemRevision item = (ItemRevision)items.get(i);
                                fmtWriter.println((String)item.getAttribute(-1102));
                            }
                            fmtWriter.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new IOException("Unable to write command log - " + e.getMessage());
                        }
                        finally {
                            fmtWriter.close();
                        }
                    }
                    String cmd = coCmd;
                    String projDir = projectDir != null ? projectDir.getRemote() : null;
                    Logger.Debug("Do full update : " + doFullUpdate);
                    Logger.Debug("CM Url : " + (url != null ? url : "(null)"));
                    if (!doFullUpdate && tmpFile != null) {
                        cmd = cmd + "/USER_ITEMLIST=\"" + tmpFile.getPath() + "\"";
                    } else if (projDir != null && !projDir.equals("\\") && !projDir.equals("/")) {
                        cmd = cmd + "/DIR=\"" + projDir + "\"";
                    }
                    cmd = cmd + "/WORKSET=\"" + projectName + "\" /USER_DIR=\"" + workspaceName.getRemote() + "\"";
                    if (doRevert) {
                        cmd = cmd + " /OVERWRITE";
                    }
                    if ((res = DimensionsAPI.run(this.connection, cmd)) != null) {
                        cmdOutput = cmdOutput.append(res.getMessage());
                        String outputStr = new String(cmdOutput.toString());
                        Logger.Debug(outputStr);
                        if (items != null) {
                            if (tmpFile != null) {
                                tmpFile.delete();
                            }
                            List changes = this.createChangeList(items, tz, url);
                            Logger.Debug("Writing changeset to " + changelogFile.getPath());
                            DimensionsChangeLogWriter write = new DimensionsChangeLogWriter();
                            write.writeLog(changes, changelogFile);
                        }
                        bRet = true;
                        int confl = outputStr.indexOf("C\t");
                        if (confl > 0) {
                            bRet = false;
                        }
                    }
                    break block27;
                }
                bRet = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Unable to run checkout callout - " + e.getMessage());
            }
        }
        return bRet;
    }

    private List calcRepositoryDiffs(String projectName, FilePath workspace, Calendar fromDate, Calendar toDate, TimeZone tz) throws IOException, InterruptedException {
        if (this.connection == null) {
            throw new IOException("Not connected to an SCM repository");
        }
        if (fromDate == null) {
            return null;
        }
        try {
            int[] attrs = DimensionsAPI.getItemFileAttributes(true);
            String dateAfter = fromDate != null ? DimensionsAPI.formatDatabaseDate(fromDate.getTime(), tz) : "01-JAN-1970 00:00:00";
            String dateBefore = toDate != null ? DimensionsAPI.formatDatabaseDate(toDate.getTime(), tz) : DimensionsAPI.formatDatabaseDate(Calendar.getInstance().getTime(), tz);
            Filter filter = new Filter();
            filter.criteria().add(new Filter.Criterion(-1301, (Object)dateAfter, 80));
            filter.criteria().add(new Filter.Criterion(-1301, (Object)dateBefore, 96));
            filter.criteria().add(new Filter.Criterion(-1201, (Object)dateAfter, 80));
            filter.criteria().add(new Filter.Criterion(-1201, (Object)dateBefore, 96));
            filter.criteria().add(new Filter.Criterion(-1805, (Object)"Y", 64));
            Logger.Debug("Looking between " + dateAfter + " -> " + dateBefore);
            String projName = projectName.toUpperCase();
            Project projectObj = this.getCon().getObjectFactory().getProject(projName);
            List items = DimensionsAPI.queryItems(this.getCon(), projectObj, workspace.getRemote(), filter, attrs, true, !this.allRevisions);
            return items;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to run hasRepositoryBeenUpdated - " + e.getMessage());
        }
    }

    private List createChangeList(List items, TimeZone tz, String url) throws DimensionsRuntimeException {
        items = DimensionsAPI.getSortedItemList(items);
        ArrayList<DimensionsChangeSet> changeSet = new ArrayList<DimensionsChangeSet>(items.size());
        String key = null;
        DimensionsChangeSet cs = null;
        for (int i = 0; i < items.size(); ++i) {
            ItemRevision item = (ItemRevision)items.get(i);
            int x = 0;
            Integer fileVersion = (Integer)item.getAttribute(-1809);
            if (fileVersion != null) {
                x = fileVersion;
            }
            Logger.Debug("Creating a change set (" + x + ")");
            String operation = x < 2 ? "add" : "edit";
            String spec = (String)item.getAttribute(-1102);
            String revision = (String)item.getAttribute(-1803);
            String fileName = (String)item.getAttribute(-1806) + ";" + revision;
            String author = (String)item.getAttribute(-1302);
            String comment = (String)item.getAttribute(-1807);
            String date = (String)item.getAttribute(DimensionsAPI.getDateTypeAttribute(operation));
            if (date == null) {
                date = (String)item.getAttribute(DimensionsAPI.getDateTypeAttribute("edit"));
            }
            String urlString = DimensionsAPI.constructURL(spec, url, this.getSCMDsn(), this.getSCMBaseDb());
            Logger.Debug("Change set details -" + comment + " " + revision + " " + fileName + " " + author + " " + spec + " " + date + " " + operation + " " + urlString);
            Calendar opDate = Calendar.getInstance();
            opDate.setTime(DateUtils.parse(date, tz));
            if (key == null) {
                cs = new DimensionsChangeSet(fileName, author, operation, revision, comment, urlString, opDate);
                key = comment + author;
                changeSet.add(cs);
                continue;
            }
            String key1 = comment + author;
            if (key.equals(key1)) {
                cs.add(fileName, operation, urlString);
                continue;
            }
            cs = new DimensionsChangeSet(fileName, author, operation, revision, comment, urlString, opDate);
            key = comment + author;
            changeSet.add(cs);
        }
        return changeSet;
    }

    private static List getSortedItemList(List items) throws DimensionsRuntimeException {
        Collections.sort(items, new Comparator(){

            public int compare(Object oa1, Object oa2) {
                int result = 0;
                try {
                    ItemRevision o1 = (ItemRevision)oa1;
                    ItemRevision o2 = (ItemRevision)oa2;
                    String a1 = (String)o1.getAttribute(-1807);
                    String a2 = (String)o2.getAttribute(-1807);
                    a1 = a1 + (String)o1.getAttribute(-1302);
                    a2 = a2 + (String)o2.getAttribute(-1302);
                    result = a1.compareTo(a2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new DimensionsRuntimeException("Unable to sort item list - " + e.getMessage());
                }
                return result;
            }
        });
        return items;
    }

    private static void setCurrentProject(DimensionsConnection connection, String projectName) {
        connection.getObjectFactory().setCurrentProject(projectName, false, "", "", null, true);
    }

    private static Project getCurrentProject(DimensionsConnection connection) {
        return connection.getObjectFactory().getCurrentUser().getCurrentProject();
    }

    static int[] getItemFileAttributes(boolean isDirectory) {
        if (isDirectory) {
            int[] attrs = new int[]{-1102, -1606, -1101, -1808, -1607, -1803, -1806, -1801, -1302, -1809, -1807, -1301, -1201};
            return attrs;
        }
        int[] attrs = new int[]{-1606, -1101, -1808, -1607, -1803, -1801, -1302, -1809, -1301, -1201};
        return attrs;
    }

    private static String preProcessSrcPath(String srcPath) {
        String path = srcPath.equals("/") ? "" : srcPath;
        if (!path.endsWith("/") & !path.equals("")) {
            path = path + "/";
        }
        if (path.equals("\\/") || path.equals("/")) {
            path = "";
        }
        return path;
    }

    private static String constructURL(String spec, String url, String dsn, String db) {
        String urlString = "";
        if (spec != null && spec.length() > 0 && url != null && url.length() > 0) {
            String host = url;
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            if (host.startsWith("http:")) {
                host = host.substring(7, host.length());
            }
            String page = "/dimensions/";
            String urlQuery = "jsp=api&command=openi&object_id=";
            urlQuery = urlQuery + spec;
            urlQuery = urlQuery + "&DB_CONN=";
            urlQuery = urlQuery + dsn;
            urlQuery = urlQuery + "&DB_NAME=";
            urlQuery = urlQuery + db;
            try {
                Logger.Debug("Host URL - " + host + " " + page + " " + urlQuery);
                String urlStr = DimensionsAPI.encodeUrl(host, page, urlQuery);
                Logger.Debug("Change URL - " + urlStr);
                urlString = urlStr;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urlString;
    }

    private static String encodeUrl(String host, String page, String query) throws MalformedURLException, URISyntaxException {
        String urlStr = "";
        if (page != null && page.length() > 0 && host != null && host.length() > 0 && query != null && query.length() > 0) {
            URI uri = new URI("http", host, page, query, null);
            urlStr = uri.toASCIIString();
        }
        return urlStr;
    }

    static List queryItems(DimensionsConnection connection, Project srcProject, String srcPath, Filter filter, int[] attrs, boolean isRecursive, boolean isLatest) {
        if (srcPath == null) {
            throw new IllegalArgumentException(MISSING_SOURCE_PATH);
        }
        if (srcProject == null) {
            throw new IllegalArgumentException(MISSING_PROJECT);
        }
        String path = DimensionsAPI.preProcessSrcPath(srcPath);
        if (!isRecursive || !path.equals("")) {
            filter.criteria().add(new Filter.Criterion(-1802, (Object)(isRecursive ? path + '%' : path), 0));
        }
        if (isLatest) {
            filter.criteria().add(new Filter.Criterion(-1804, (Object)Boolean.TRUE, 0));
        }
        try {
            Logger.Debug("Looking for changed files in '" + path + "' in project: " + srcProject.getName());
            List rels = srcProject.getChildItems(filter);
            Logger.Debug("Found " + rels.size());
            if (rels.size() == 0) {
                return null;
            }
            ArrayList<DimensionsObject> items = new ArrayList<DimensionsObject>(rels.size());
            for (int i = 0; i < rels.size(); ++i) {
                DimensionsRelatedObject rel = (DimensionsRelatedObject)rels.get(i);
                items.add(rel.getObject());
            }
            BulkOperator bo = connection.getObjectFactory().getBulkOperator(items);
            bo.queryAttribute(attrs);
            return items;
        }
        catch (Exception e) {
            Logger.Debug("Exception detected from the Java API: " + e.getMessage());
            return null;
        }
    }

    static DimensionsResult run(DimensionsConnection connection, String cmd) throws DimensionsDatabaseAdmin.CommandFailedException {
        if (cmd == null || cmd.equals("")) {
            throw new IllegalArgumentException(NO_COMMAND_LINE);
        }
        Logger.Debug("Running the command '" + cmd + "'...");
        DimensionsObjectFactory dof = connection.getObjectFactory();
        DimensionsResult res = dof.runCommand(cmd);
        return res;
    }

    static int getDateTypeAttribute(String dateType) {
        int ret = -1201;
        if (dateType != null) {
            if (dateType.equalsIgnoreCase("edit")) {
                ret = -1301;
            } else if (dateType.equalsIgnoreCase("actioned")) {
                ret = -1401;
            } else if (dateType.equalsIgnoreCase("revised")) {
                ret = -1303;
            } else if (dateType.equalsIgnoreCase("add")) {
                ret = -1201;
            }
        }
        return ret;
    }

    static String formatDatabaseDate(Date date, TimeZone timeZone) {
        return timeZone == null ? DateUtils.format(date) : DateUtils.format(date, timeZone);
    }

    static Date parseDatabaseDate(String date, TimeZone timeZone) {
        return timeZone == null ? DateUtils.parse(date) : DateUtils.parse(date, timeZone);
    }
}

