/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static final String DATE_PATTERN = "dd-MMM-yyyy";
    private static final String DATETIME_PATTERN = "dd-MMM-yyyy HH:mm:ss";
    private static final String RFCDATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static TimeZone tzl = TimeZone.getDefault();
    private static final String[] PATTERNS = new String[]{"dd-MMM-yyyy HH:mm:ss", "dd-MMM-yyyy", "yyyy-MM-dd'T'HH:mm:ss'Z'"};

    public static Date parse(String dateStr) {
        return DateUtils.parse(dateStr, tzl);
    }

    public static Date parse(String dateStr, TimeZone tz) {
        Date date = null;
        dateStr = dateStr.trim();
        for (int i = 0; i < PATTERNS.length; ++i) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(PATTERNS[i], Locale.US);
                df.setTimeZone(tz);
                date = df.parse(dateStr);
                if (date == null) continue;
                break;
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        return date;
    }

    public static boolean validate(String dateStr) {
        boolean ret = false;
        dateStr = dateStr.trim();
        for (int i = 0; i < PATTERNS.length; ++i) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(PATTERNS[i], Locale.US);
                Date date = df.parse(dateStr);
                if (date == null || !df.format(date).equalsIgnoreCase(dateStr)) continue;
                ret = true;
                break;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static int compare(Date d1, Date d2, long toleranceMillis) {
        long diff = d1.getTime() - d2.getTime();
        int ret = Math.abs(diff) <= Math.abs(toleranceMillis) ? 0 : (diff < 0L ? -1 : (diff > 0L ? 1 : 0));
        return ret;
    }

    public static String format(Date date) {
        return DateUtils.format(date, tzl);
    }

    public static String format(Date date, TimeZone tz) {
        SimpleDateFormat df = new SimpleDateFormat(DATETIME_PATTERN, Locale.US);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static String getNowStrDate() {
        SimpleDateFormat df = new SimpleDateFormat(RFCDATETIME_PATTERN);
        Calendar opDate = Calendar.getInstance();
        df.setTimeZone(tzl);
        return df.format(opDate.getTime());
    }

    public static String getNowStrDate(TimeZone tz) {
        SimpleDateFormat df = new SimpleDateFormat(RFCDATETIME_PATTERN);
        Calendar opDate = Calendar.getInstance();
        df.setTimeZone(tz);
        return df.format(opDate.getTime());
    }

    public static String getStrDate(Calendar opDate) {
        SimpleDateFormat df = new SimpleDateFormat(RFCDATETIME_PATTERN);
        df.setTimeZone(tzl);
        return df.format(opDate.getTime());
    }

    public static String getStrDate(Calendar opDate, TimeZone tz) {
        SimpleDateFormat df = new SimpleDateFormat(RFCDATETIME_PATTERN);
        df.setTimeZone(tz);
        return df.format(opDate.getTime());
    }
}

