/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.model.AbstractBuild;
import hudson.plugins.dimensionsscm.DimensionsChangeSet;
import hudson.plugins.dimensionsscm.DimensionsChangeSetList;
import hudson.plugins.dimensionsscm.Logger;
import hudson.scm.ChangeLogParser;
import hudson.util.Digester2;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class DimensionsChangeLogParser
extends ChangeLogParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimensionsChangeSetList parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
        Logger.Debug("Looking for '" + changelogFile.getPath() + "'");
        if (!changelogFile.exists()) {
            Logger.Debug("Change log file does not exist");
            throw new IOException("Specified change log file does not exist - " + changelogFile.getPath());
        }
        FileReader reader = new FileReader(changelogFile);
        try {
            DimensionsChangeSetList dimensionsChangeSetList = this.parse(build, reader);
            return dimensionsChangeSetList;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public DimensionsChangeSetList parse(AbstractBuild build, FileReader reader) throws IOException, SAXException {
        ArrayList<DimensionsChangeSet> changesetList = new ArrayList<DimensionsChangeSet>();
        Digester2 digester = new Digester2();
        digester.push(changesetList);
        digester.addObjectCreate("*/changeset", DimensionsChangeSet.class);
        digester.addSetProperties("*/changeset");
        digester.addBeanPropertySetter("*/changeset/date", "dateString");
        digester.addBeanPropertySetter("*/changeset/user");
        digester.addBeanPropertySetter("*/changeset/comment");
        digester.addSetNext("*/changeset", "add");
        digester.addObjectCreate("*/changeset/items/item", DimensionsChangeSet.DmFiles.class);
        digester.addSetProperties("*/changeset/items/item");
        digester.addBeanPropertySetter("*/changeset/items/item", "file");
        digester.addSetNext("*/changeset/items/item", "add");
        digester.parse((Reader)reader);
        return new DimensionsChangeSetList(build, changesetList);
    }
}

