/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.Util;
import hudson.plugins.dimensionsscm.DimensionsChangeSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsChangeLogWriter {
    public boolean writeLog(List<DimensionsChangeSet> changeSets, File changelogFile) throws IOException {
        boolean bRet = false;
        OutputStreamWriter logFile = null;
        try {
            logFile = new FileWriter(changelogFile);
            this.write(changeSets, logFile);
            logFile.flush();
            bRet = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to write change log - " + e.getMessage());
        }
        finally {
            logFile.close();
        }
        return bRet;
    }

    private void write(List<DimensionsChangeSet> changeSets, Writer logFile) {
        PrintWriter writer = new PrintWriter(logFile);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<changelog>");
        for (DimensionsChangeSet changeSet : changeSets) {
            writer.println(String.format("\t<changeset version=\"%s\">", DimensionsChangeLogWriter.escapeXML(changeSet.getVersion())));
            writer.println(String.format("\t\t<date>%s</date>", Util.XS_DATETIME_FORMATTER.format(changeSet.getDate())));
            writer.println(String.format("\t\t<user>%s</user>", DimensionsChangeLogWriter.escapeXML(changeSet.getDeveloper())));
            writer.println(String.format("\t\t<comment>%s</comment>", DimensionsChangeLogWriter.escapeXML(changeSet.getSCMComment())));
            writer.println("\t\t<items>");
            for (DimensionsChangeSet.DmFiles item : changeSet.getFiles()) {
                writer.println(String.format("\t\t\t<item operation=\"%s\" url=\"%s\">%s</item>", item.getOperation(), DimensionsChangeLogWriter.escapeHTML(item.getUrl()), DimensionsChangeLogWriter.escapeXML(item.getFile())));
            }
            writer.println("\t\t</items>");
            writer.println("\t</changeset>");
        }
        writer.println("</changelog>");
    }

    private static String escapeXML(String inTxt) {
        if (inTxt == null || inTxt.length() == 0) {
            return inTxt;
        }
        StringBuilder outTxt = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(inTxt);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                outTxt.append("&lt;");
            } else if (character == '>') {
                outTxt.append("&gt;");
            } else if (character == '\"') {
                outTxt.append("&quot;");
            } else if (character == '\'') {
                outTxt.append("&#039;");
            } else if (character == '&') {
                outTxt.append("&amp;");
            } else {
                outTxt.append(character);
            }
            character = iterator.next();
        }
        return outTxt.toString();
    }

    private static String escapeHTML(String inTxt) {
        if (inTxt == null || inTxt.length() == 0) {
            return inTxt;
        }
        StringBuilder outTxt = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(inTxt);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                outTxt.append("&lt;");
            } else if (character == '>') {
                outTxt.append("&gt;");
            } else if (character == '\"') {
                outTxt.append("&quot;");
            } else if (character == '\'') {
                outTxt.append("&#039;");
            } else if (character == '&') {
                outTxt.append("&amp;");
            } else if (character == ' ') {
                outTxt.append("&nbsp;");
            } else {
                outTxt.append(character);
            }
            character = iterator.next();
        }
        return outTxt.toString();
    }
}

