/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.DateUtils;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsChangeLogParser;
import hudson.plugins.dimensionsscm.DimensionsSCMRepositoryBrowser;
import hudson.plugins.dimensionsscm.Logger;
import hudson.plugins.dimensionsscm.PluginImpl;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import hudson.util.Scrambler;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsSCM
extends SCM
implements Serializable {
    private String project;
    private String directory;
    private String workarea;
    private String jobUserName;
    private String jobPasswd;
    private String jobServer;
    private String jobDatabase;
    private String jobTimeZone;
    private String jobWebUrl;
    private boolean canJobUpdate;
    private boolean canJobDelete;
    private boolean canJobForce;
    private boolean canJobRevert;
    DimensionsAPI dmSCM;
    DimensionsSCMRepositoryBrowser browser;

    public String getProject() {
        return this.project;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getWorkarea() {
        return this.workarea;
    }

    public String getJobUserName() {
        return this.jobUserName;
    }

    public String getJobPasswd() {
        return Scrambler.descramble((String)this.jobPasswd);
    }

    public String getJobServer() {
        return this.jobServer;
    }

    public String getJobDatabase() {
        return this.jobDatabase;
    }

    public String getJobTimeZone() {
        return this.jobTimeZone;
    }

    public String getJobWebUrl() {
        return this.jobWebUrl;
    }

    public boolean isCanJobUpdate() {
        return this.canJobUpdate;
    }

    public boolean isCanJobDelete() {
        return this.canJobDelete;
    }

    public boolean isCanJobForce() {
        return this.canJobForce;
    }

    public boolean isCanJobRevert() {
        return this.canJobRevert;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean supportsPolling() {
        return true;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
    }

    @DataBoundConstructor
    public DimensionsSCM(String project, String directory, String workarea, boolean canJobDelete, boolean canJobForce, boolean canJobRevert, String jobUserName, String jobPasswd, String jobServer, String jobDatabase, boolean canJobUpdate, String jobTimeZone, String jobWebUrl) {
        this.project = Util.fixEmptyAndTrim((String)project) == null ? "${JOB_NAME}" : project;
        this.directory = Util.fixEmptyAndTrim((String)directory) == null ? "/" : directory;
        this.workarea = Util.fixEmptyAndTrim((String)workarea) == null ? null : workarea;
        this.jobServer = Util.fixEmptyAndTrim((String)jobServer) == null ? this.getDescriptor().getServer() : jobServer;
        this.jobUserName = Util.fixEmptyAndTrim((String)jobUserName) == null ? this.getDescriptor().getUserName() : jobUserName;
        this.jobDatabase = Util.fixEmptyAndTrim((String)jobDatabase) == null ? this.getDescriptor().getDatabase() : jobDatabase;
        String passwd = Util.fixEmptyAndTrim((String)jobPasswd) == null ? this.getDescriptor().getPasswd() : jobPasswd;
        this.jobPasswd = Scrambler.scramble((String)passwd);
        this.canJobUpdate = canJobUpdate;
        this.canJobDelete = canJobDelete;
        this.canJobForce = canJobForce;
        this.canJobRevert = canJobRevert;
        this.jobTimeZone = Util.fixEmptyAndTrim((String)jobTimeZone) == null ? this.getDescriptor().getTimeZone() : jobTimeZone;
        this.jobWebUrl = Util.fixEmptyAndTrim((String)jobWebUrl) == null ? this.getDescriptor().getWebUrl() : jobWebUrl;
        String dmS = this.jobServer + "-" + this.jobUserName + ":" + this.jobDatabase;
        Logger.Debug("Starting job for project '" + this.project + "' ('" + this.directory + "')" + ", connecting to " + dmS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        if (!this.isCanJobUpdate()) {
            Logger.Debug("Skipping checkout - " + this.getClass().getName());
            return true;
        }
        Logger.Debug("Invoking checkout - " + this.getClass().getName());
        boolean bRet = false;
        try {
            TimeZone tz;
            Calendar lastBuildCal = build.getPreviousNotFailedBuild() != null ? build.getPreviousNotFailedBuild().getTimestamp() : null;
            Calendar nowDateCal = Calendar.getInstance();
            TimeZone timeZone = tz = this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0 ? TimeZone.getTimeZone(this.getJobTimeZone()) : TimeZone.getDefault();
            if (this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0) {
                Logger.Debug("Job timezone setting is " + this.getJobTimeZone());
            }
            Logger.Debug("Checkout updates between " + (lastBuildCal != null ? DateUtils.getStrDate(lastBuildCal, tz) : "0") + " -> " + DateUtils.getStrDate(nowDateCal, tz) + " (" + tz.getID() + ")");
            if (this.dmSCM == null) {
                Logger.Debug("Creating new API interface object");
                this.dmSCM = new DimensionsAPI();
            }
            if (this.dmSCM.login(this.jobUserName, this.getJobPasswd(), this.jobDatabase, this.jobServer)) {
                File fileName = new File(this.getDirectory());
                FilePath dname = new FilePath(fileName);
                FilePath wa = null;
                if (this.workarea != null) {
                    File waN = new File(this.workarea);
                    wa = new FilePath(waN);
                } else {
                    wa = workspace;
                }
                if (wa.exists() && this.canJobDelete) {
                    Logger.Debug("Deleting '" + wa.toURI() + "'...");
                    wa.deleteRecursive();
                }
                StringBuffer cmdOutput = new StringBuffer();
                bRet = this.dmSCM.checkout(this.getProject(), dname, wa, lastBuildCal, nowDateCal, changelogFile, tz, cmdOutput, this.jobWebUrl, true, this.canJobRevert);
                Logger.Debug("SCM checkout returned " + bRet);
                if (cmdOutput.length() > 0 && listener.getLogger() != null) {
                    Logger.Debug("Found command output to log to the build logger");
                    listener.getLogger().println("(Note: Dimensions command output was - ");
                    listener.getLogger().println(cmdOutput + ")");
                    listener.getLogger().flush();
                }
                if (!bRet && this.canJobForce) {
                    bRet = true;
                }
                if (!bRet) {
                    listener.getLogger().println("==========================================================");
                    listener.getLogger().println("The Dimensions checkout command returned a failure status.");
                    listener.getLogger().println("Please review the command output and correct any issues");
                    listener.getLogger().println("that may have been detected.");
                    listener.getLogger().println("==========================================================");
                }
            }
        }
        catch (Exception e) {
            listener.fatalError("Unable to run checkout callout - " + e.getMessage());
            bRet = false;
        }
        finally {
            this.dmSCM.logout();
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        boolean bChanged = false;
        Logger.Debug("Invoking pollChanges - " + this.getClass().getName());
        Logger.Debug("Checking job - " + project.getName());
        if (project.getLastBuild() == null) {
            return true;
        }
        try {
            TimeZone tz;
            Calendar lastBuildCal = null;
            lastBuildCal = project.getLastSuccessfulBuild() != null && project.getLastSuccessfulBuild().getTimestamp() != null ? project.getLastSuccessfulBuild().getTimestamp() : project.getLastBuild().getTimestamp();
            Calendar nowDateCal = Calendar.getInstance();
            TimeZone timeZone = tz = this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0 ? TimeZone.getTimeZone(this.getJobTimeZone()) : TimeZone.getDefault();
            if (this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0) {
                Logger.Debug("Job timezone setting is " + this.getJobTimeZone());
            }
            Logger.Debug("Checking for any updates between " + (lastBuildCal != null ? DateUtils.getStrDate(lastBuildCal, tz) : "0") + " -> " + DateUtils.getStrDate(nowDateCal, tz) + " (" + tz.getID() + ")");
            if (this.dmSCM == null) {
                Logger.Debug("Creating new API interface object");
                this.dmSCM = new DimensionsAPI();
            }
            if (this.dmSCM.login(this.jobUserName, this.getJobPasswd(), this.jobDatabase, this.jobServer)) {
                File fileName = new File(this.getDirectory());
                FilePath dname = new FilePath(fileName);
                bChanged = this.dmSCM.hasRepositoryBeenUpdated(this.getProject(), dname, lastBuildCal, nowDateCal, tz);
            }
        }
        catch (Exception e) {
            listener.fatalError("Unable to run pollChanges callout - " + e.getMessage());
            bChanged = false;
        }
        finally {
            this.dmSCM.logout();
        }
        return bChanged;
    }

    public ChangeLogParser createChangeLogParser() {
        Logger.Debug("Invoking createChangeLogParser - " + this.getClass().getName());
        return new DimensionsChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.DM_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<DimensionsSCM> {
        DimensionsAPI connectionCheck = null;
        private String server;
        private String userName;
        private String passwd;
        private String database;
        private String timeZone;
        private String webUrl;
        private boolean canUpdate;

        public DescriptorImpl() {
            super(DimensionsSCM.class, DimensionsSCMRepositoryBrowser.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Dimensions";
        }

        public boolean configure(StaplerRequest req, JSONObject jobj) throws Descriptor.FormException {
            this.userName = req.getParameter("dimensionsscm.userName");
            this.passwd = req.getParameter("dimensionsscm.passwd");
            this.server = req.getParameter("dimensionsscm.server");
            this.database = req.getParameter("dimensionsscm.database");
            this.timeZone = req.getParameter("dimensionsscm.timeZone");
            this.webUrl = req.getParameter("dimensionsscm.webUrl");
            if (this.userName != null) {
                this.userName = Util.fixNull((String)req.getParameter("dimensionsscm.userName").trim());
            }
            if (this.passwd != null) {
                this.passwd = Util.fixNull((String)req.getParameter("dimensionsscm.passwd").trim());
            }
            if (this.server != null) {
                this.server = Util.fixNull((String)req.getParameter("dimensionsscm.server").trim());
            }
            if (this.database != null) {
                this.database = Util.fixNull((String)req.getParameter("dimensionsscm.database").trim());
            }
            if (this.timeZone != null) {
                this.timeZone = Util.fixNull((String)req.getParameter("dimensionsscm.timeZone").trim());
            }
            if (this.webUrl != null) {
                this.webUrl = Util.fixNull((String)req.getParameter("dimensionsscm.webUrl").trim());
            }
            req.bindJSON((Object)PluginImpl.DM_DESCRIPTOR, jobj);
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            DimensionsSCM scm = (DimensionsSCM)super.newInstance(req, formData);
            scm.browser = (DimensionsSCMRepositoryBrowser)RepositoryBrowsers.createInstance(DimensionsSCMRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            if (scm.dmSCM == null) {
                scm.dmSCM = new DimensionsAPI();
            }
            return scm;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getServer() {
            return this.server;
        }

        public String getPasswd() {
            return Scrambler.descramble((String)this.passwd);
        }

        public boolean isCanUpdate() {
            return this.canUpdate;
        }

        public void setCanUpdate(boolean x) {
            this.canUpdate = x;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public void setPasswd(String password) {
            this.passwd = Scrambler.scramble((String)password);
        }

        public void setTimeZone(String x) {
            this.timeZone = x;
        }

        public void setWebUrl(String x) {
            this.webUrl = x;
        }

        private void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    String nullText = null;
                    if (value == null) {
                        if (nullText == null) {
                            this.ok();
                        } else {
                            this.error(nullText);
                        }
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void domanadatoryFieldCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    String errorTxt = "This value is manadatory.";
                    if (value == null) {
                        this.error(errorTxt);
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void domanadatoryJobFieldCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    String errorTxt = "This value is manadatory.";
                    this.ok();
                }
            }.process();
        }

        public void docheckTz(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="dimensionsscm.timeZone") String timezone, final @QueryParameter(value="dimensionsscm.jobTimeZone") String jobtimezone) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    try {
                        String xtz = jobtimezone != null ? jobtimezone : timezone;
                        Logger.Debug("Invoking docheckTz - " + xtz);
                        TimeZone ctz = TimeZone.getTimeZone(xtz);
                        String lmt = ctz.getID();
                        if (!(!lmt.equalsIgnoreCase("GMT") || xtz.equalsIgnoreCase("GMT") || xtz.equalsIgnoreCase("Greenwich Mean Time") || xtz.equalsIgnoreCase("UTC") || xtz.equalsIgnoreCase("Coordinated Universal Time"))) {
                            this.error("Timezone specified is not valid.");
                        } else {
                            this.ok("Timezone test succeeded!");
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.error("timezone check error:" + e.getMessage());
                        return;
                    }
                }
            }.process();
        }

        public void docheckServer(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="dimensionsscm.userName") String user, final @QueryParameter(value="dimensionsscm.passwd") String passwd, final @QueryParameter(value="dimensionsscm.server") String server, final @QueryParameter(value="dimensionsscm.database") String database, final @QueryParameter(value="dimensionsscm.jobUserName") String jobuser, final @QueryParameter(value="dimensionsscm.jobPasswd") String jobPasswd, final @QueryParameter(value="dimensionsscm.jobServer") String jobServer, final @QueryParameter(value="dimensionsscm.jobDatabase") String jobDatabase) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    if (DescriptorImpl.this.connectionCheck == null) {
                        DescriptorImpl.this.connectionCheck = new DimensionsAPI();
                    }
                    try {
                        String xserver = jobServer != null ? jobServer : server;
                        String xuser = jobuser != null ? jobuser : user;
                        String xpasswd = jobPasswd != null ? jobPasswd : passwd;
                        String xdatabase = jobDatabase != null ? jobDatabase : database;
                        String dmS = xserver + "-" + xuser + ":" + xdatabase;
                        Logger.Debug("Invoking serverCheck - " + dmS);
                        if (!DescriptorImpl.this.connectionCheck.login(xuser, xpasswd, xdatabase, xserver)) {
                            this.error("Connection test failed");
                        } else {
                            this.ok("Connection test succeeded!");
                            DescriptorImpl.this.connectionCheck.logout();
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.error("Server connection error:" + e.getMessage());
                        return;
                    }
                }
            }.process();
        }
    }
}

