/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.Serializable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsBuildNotifier
extends Notifier
implements Serializable {
    private static DimensionsSCM scm = null;

    @DataBoundConstructor
    public DimensionsBuildNotifier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Logger.Debug("Invoking perform callout " + this.getClass().getName());
        try {
            if (build.getResult() == Result.SUCCESS) {
                if (scm == null) {
                    scm = (DimensionsSCM)build.getProject().getScm();
                }
                Logger.Debug("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer());
                if (scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer())) {
                    DimensionsResult res = scm.getAPI().createBaseline(scm.getProject(), build);
                    if (res == null) {
                        listener.getLogger().println("[DIMENSIONS] The build failed to be tagged in Dimensions");
                        listener.getLogger().flush();
                    } else {
                        listener.getLogger().println("[DIMENSIONS] Build was successfully tagged in Dimensions as a baseline");
                        listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS]") + ")");
                        listener.getLogger().flush();
                    }
                }
            }
        }
        catch (Exception e) {
            listener.fatalError("Unable to tag build in Dimensions - " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (scm != null) {
                scm.getAPI().logout();
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(DimensionsBuildNotifier.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Tag successful builds in Dimensions as a project baseline";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "Dimensions");
            this.save();
            return true;
        }

        public String getHelpFile() {
            return "/plugin/dimensionsscm/helpbnotifier.html";
        }
    }
}

