/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.dimensionsscm.DimensionsBuildWrapper;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsBuildWrapper
extends BuildWrapper {
    private static DimensionsSCM scm = null;
    public static final DescriptorImpl DMWBLD_DESCRIPTOR = new DescriptorImpl();

    public Descriptor<BuildWrapper> getDescriptor() {
        return DMWBLD_DESCRIPTOR;
    }

    @DataBoundConstructor
    public DimensionsBuildWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (build.getProject().getScm() instanceof DimensionsSCM) {
            Logger.Debug((String)("Invoking build setup callout " + this.getClass().getName()));
            if (scm == null) {
                scm = (DimensionsSCM)build.getProject().getScm();
            }
            Logger.Debug((String)("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer()));
            try {
                if (!scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer())) return new EnvironmentImpl(this, build);
                DimensionsResult res = scm.getAPI().lockProject(scm.getProject());
                if (res == null) {
                    listener.getLogger().println("[DIMENSIONS] Locking the project in Dimensions failed");
                    listener.getLogger().flush();
                    return new EnvironmentImpl(this, build);
                }
                listener.getLogger().println("[DIMENSIONS] Dimensions project was successfully locked");
                listener.getLogger().flush();
                return new EnvironmentImpl(this, build);
            }
            catch (Exception e) {
                listener.fatalError("Unable to lock Dimensions project - " + e.getMessage());
                return new EnvironmentImpl(this, build);
            }
            finally {
                scm.getAPI().logout();
            }
        } else {
            listener.fatalError("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
            throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
        }
    }

    static /* synthetic */ DimensionsSCM access$000() {
        return scm;
    }
}

