/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactUploader
extends Notifier
implements Serializable {
    private static DimensionsSCM scm = null;
    private String[] patterns = new String[0];

    @DataBoundConstructor
    public ArtifactUploader(String[] patterns) {
        if (patterns != null) {
            Logger.Debug("patterns are populated");
            Vector<String> x = new Vector<String>();
            for (int t = 0; t < patterns.length; ++t) {
                if (!StringUtils.isNotEmpty((String)patterns[t])) continue;
                x.add(patterns[t]);
            }
            this.patterns = x.toArray(new String[1]);
        } else {
            this.patterns[0] = ".*";
        }
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        block19: {
            Logger.Debug("Invoking perform callout " + this.getClass().getName());
            try {
                if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                    listener.fatalError("[DIMENSIONS] This plugin only works with the Dimensions SCM engine.");
                    throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
                }
                if (build.getResult() != Result.SUCCESS) break block19;
                listener.getLogger().println("[DIMENSIONS] Scanning workspace for files to be saved into Dimensions...");
                listener.getLogger().flush();
                ArtifactFilter af = new ArtifactFilter(this.patterns);
                FilePath wd = build.getProject().getWorkspace();
                Logger.Debug("Scanning directory for files that match patterns '" + wd.getRemote() + "'");
                File dir = new File(wd.getRemote());
                FileScanner fs = new FileScanner(dir, af, -1);
                File[] validFiles = fs.toArray();
                if (fs.getFiles().size() > 0) {
                    if (scm == null) {
                        scm = (DimensionsSCM)build.getProject().getScm();
                    }
                    listener.getLogger().println("[DIMENSIONS] Loading files into Dimensions project \"" + scm.getProject() + "\"...");
                    listener.getLogger().flush();
                    Calendar nowDateCal = Calendar.getInstance();
                    File logFile = new File("a");
                    FileWriter logFileWriter = null;
                    PrintWriter fmtWriter = null;
                    File tmpFile = null;
                    try {
                        tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                        logFileWriter = new FileWriter(tmpFile);
                        fmtWriter = new PrintWriter((Writer)logFileWriter, true);
                        for (File f : validFiles) {
                            Logger.Debug("Found file '" + f.getAbsolutePath() + "'");
                            fmtWriter.println(f.getAbsolutePath());
                        }
                        fmtWriter.flush();
                    }
                    catch (Exception e) {
                        throw new IOException("Unable to write command log - " + e.getMessage());
                    }
                    finally {
                        fmtWriter.close();
                    }
                    Logger.Debug("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer());
                    if (scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer())) {
                        DimensionsResult res = scm.getAPI().UploadFiles(wd, scm.getProject(), tmpFile, build);
                        if (res == null) {
                            listener.getLogger().println("[DIMENSIONS] New artifacts failed to get loaded into Dimensions");
                            listener.getLogger().flush();
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Build artifacts were successfully loaded into Dimensions");
                            listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                            listener.getLogger().flush();
                        }
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    break block19;
                }
                listener.getLogger().println("[DIMENSIONS] No build artifacts were detected");
                listener.getLogger().flush();
            }
            catch (Exception e) {
                listener.fatalError("Unable to load build artifacts into Dimensions - " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (scm != null) {
                    scm.getAPI().logout();
                }
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(ArtifactUploader.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Load any build artifacts into the Dimensions repository";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "ArtifactUploader");
            return super.configure(req, formData);
        }

        public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] patterns = req.getParameterValues("artifactuploader.patterns");
            ArtifactUploader artifactor = new ArtifactUploader(patterns);
            return artifactor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FileScanner {
        private File[] arr = null;
        private Collection<File> xfiles = null;
        private File baseDir = null;

        public FileScanner(File dirName, FilenameFilter filter, int depth) {
            this.baseDir = dirName;
            Logger.Debug("Scanning base directory for files that match patterns '" + this.baseDir.getAbsolutePath() + "'");
            this.xfiles = this.scanFiles(dirName, filter, depth);
        }

        public Collection<File> getFiles() {
            return this.xfiles;
        }

        public File[] toArray() {
            this.arr = new File[this.xfiles.size()];
            return this.xfiles.toArray(this.arr);
        }

        private Collection<File> scanFiles(File dirName, FilenameFilter filter, int depth) {
            if (dirName.isDirectory()) {
                Logger.Debug("Scanning '" + dirName.getAbsolutePath() + "' " + depth);
            }
            Vector<File> files = new Vector<File>();
            File[] entFiles = dirName.listFiles();
            if (dirName.isDirectory() && dirName.getName().equals(".metadata")) {
                Logger.Debug("Ignoring '" + dirName.getAbsolutePath() + "' " + depth);
            } else if (entFiles != null) {
                for (File afile : entFiles) {
                    String dname = afile.getAbsolutePath();
                    dname = dname.substring(this.baseDir.getAbsolutePath().length() + 1, afile.getAbsolutePath().length());
                    if (filter == null || filter.accept(dirName, dname)) {
                        files.add(afile);
                    }
                    if (depth > -1 && (depth <= 0 || !afile.isDirectory())) continue;
                    files.addAll(this.scanFiles(afile, filter, --depth));
                    ++depth;
                }
            }
            return files;
        }
    }

    public class ArtifactFilter
    implements FilenameFilter {
        private TreeSet<String> artifactFilter = new TreeSet();

        public ArtifactFilter(String[] extensions) {
            Iterator<String> artifactList = Arrays.asList(extensions).iterator();
            while (artifactList.hasNext()) {
                this.artifactFilter.add(artifactList.next().trim());
            }
            this.artifactFilter.remove("");
        }

        public boolean accept(File dir, String name) {
            for (String filter : this.artifactFilter) {
                if (!Pattern.matches(filter, name)) continue;
                Logger.Debug("Matched '" + filter + "' against '" + name + "'");
                return true;
            }
            return false;
        }
    }
}

