/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.DateUtils;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsBuildNotifier;
import hudson.plugins.dimensionsscm.DimensionsBuildWrapper;
import hudson.plugins.dimensionsscm.DimensionsChangeLogParser;
import hudson.plugins.dimensionsscm.DimensionsChecker;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.DimensionsSCMRepositoryBrowser;
import hudson.plugins.dimensionsscm.Logger;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.util.Scrambler;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsSCM
extends SCM
implements Serializable {
    private String project;
    private String directory;
    private String workarea;
    private String jobUserName;
    private String jobPasswd;
    private String jobServer;
    private String jobDatabase;
    private String[] folders = new String[0];
    private String jobTimeZone;
    private String jobWebUrl;
    private boolean canJobUpdate;
    private boolean canJobDelete;
    private boolean canJobForce;
    private boolean canJobRevert;
    DimensionsAPI dmSCM;
    DimensionsSCMRepositoryBrowser browser;
    public static final DescriptorImpl DM_DESCRIPTOR = new DescriptorImpl();

    public DimensionsSCM getSCM() {
        return this;
    }

    public DimensionsAPI getAPI() {
        return this.dmSCM;
    }

    public String getProject() {
        return this.project;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String[] getFolders() {
        return this.folders;
    }

    public String getWorkarea() {
        return this.workarea;
    }

    public String getJobUserName() {
        return this.jobUserName;
    }

    public String getJobPasswd() {
        return Scrambler.descramble((String)this.jobPasswd);
    }

    public String getJobServer() {
        return this.jobServer;
    }

    public String getJobDatabase() {
        return this.jobDatabase;
    }

    public String getJobTimeZone() {
        return this.jobTimeZone;
    }

    public String getJobWebUrl() {
        return this.jobWebUrl;
    }

    public boolean isCanJobUpdate() {
        return this.canJobUpdate;
    }

    public boolean isCanJobDelete() {
        return this.canJobDelete;
    }

    public boolean isCanJobForce() {
        return this.canJobForce;
    }

    public boolean isCanJobRevert() {
        return this.canJobRevert;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean supportsPolling() {
        return true;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
    }

    public DimensionsSCM(String project, String directory, String workarea, boolean canJobDelete, boolean canJobForce, boolean canJobRevert, String jobUserName, String jobPasswd, String jobServer, String jobDatabase, boolean canJobUpdate, String jobTimeZone, String jobWebUrl) {
        this(project, null, workarea, canJobDelete, canJobForce, canJobRevert, jobUserName, jobPasswd, jobServer, jobDatabase, canJobUpdate, jobTimeZone, jobWebUrl, directory);
    }

    @DataBoundConstructor
    public DimensionsSCM(String project, String[] folders, String workarea, boolean canJobDelete, boolean canJobForce, boolean canJobRevert, String jobUserName, String jobPasswd, String jobServer, String jobDatabase, boolean canJobUpdate, String jobTimeZone, String jobWebUrl, String directory) {
        if (folders != null) {
            Logger.Debug((String)"Folders are populated");
            Vector<String> x = new Vector<String>();
            for (int t = 0; t < folders.length; ++t) {
                if (!StringUtils.isNotEmpty((String)folders[t])) continue;
                x.add(folders[t]);
            }
            this.folders = x.toArray(new String[1]);
        } else if (directory != null) {
            this.folders[0] = directory;
        }
        if (this.folders.length < 2 && (this.folders[0] == null || this.folders[0].length() < 1)) {
            this.folders[0] = "/";
        }
        this.project = Util.fixEmptyAndTrim((String)project) == null ? "${JOB_NAME}" : project;
        this.workarea = Util.fixEmptyAndTrim((String)workarea) == null ? null : workarea;
        this.directory = Util.fixEmptyAndTrim((String)directory) == null ? null : directory;
        this.jobServer = Util.fixEmptyAndTrim((String)jobServer) == null ? this.getDescriptor().getServer() : jobServer;
        this.jobUserName = Util.fixEmptyAndTrim((String)jobUserName) == null ? this.getDescriptor().getUserName() : jobUserName;
        this.jobDatabase = Util.fixEmptyAndTrim((String)jobDatabase) == null ? this.getDescriptor().getDatabase() : jobDatabase;
        String passwd = Util.fixEmptyAndTrim((String)jobPasswd) == null ? this.getDescriptor().getPasswd() : jobPasswd;
        this.jobPasswd = Scrambler.scramble((String)passwd);
        this.canJobUpdate = canJobUpdate;
        this.canJobDelete = canJobDelete;
        this.canJobForce = canJobForce;
        this.canJobRevert = canJobRevert;
        this.jobTimeZone = Util.fixEmptyAndTrim((String)jobTimeZone) == null ? this.getDescriptor().getTimeZone() : jobTimeZone;
        this.jobWebUrl = Util.fixEmptyAndTrim((String)jobWebUrl) == null ? this.getDescriptor().getWebUrl() : jobWebUrl;
        String dmS = this.jobServer + "-" + this.jobUserName + ":" + this.jobDatabase;
        Logger.Debug((String)("Starting job for project '" + this.project + "' ('" + this.folders.length + "')" + ", connecting to " + dmS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean bRet;
        block34: {
            if (!this.isCanJobUpdate()) {
                Logger.Debug((String)("Skipping checkout - " + this.getClass().getName()));
                return true;
            }
            Logger.Debug((String)("Invoking checkout - " + this.getClass().getName()));
            boolean bFreshBuild = build.getPreviousBuild() == null;
            bRet = true;
            try {
                TimeZone tz;
                DimensionsBuildWrapper.DescriptorImpl bwplugin = (DimensionsBuildWrapper.DescriptorImpl)Hudson.getInstance().getDescriptor(DimensionsBuildWrapper.class);
                DimensionsBuildNotifier.DescriptorImpl bnplugin = (DimensionsBuildNotifier.DescriptorImpl)Hudson.getInstance().getDescriptor(DimensionsBuildNotifier.class);
                if (!DimensionsChecker.isValidPluginCombination((AbstractBuild)build)) {
                    listener.fatalError("\n[DIMENSIONS] The plugin combinations you have selected are not valid.");
                    listener.fatalError("\n[DIMENSIONS] Please review online help to determine valid plugin uses.");
                    boolean bl = false;
                    return bl;
                }
                Logger.Debug((String)"Plugins are ok");
                Calendar lastBuildCal = build.getPreviousNotFailedBuild() != null ? build.getPreviousNotFailedBuild().getTimestamp() : null;
                Calendar nowDateCal = Calendar.getInstance();
                TimeZone timeZone = tz = this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0 ? TimeZone.getTimeZone(this.getJobTimeZone()) : TimeZone.getDefault();
                if (this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0) {
                    Logger.Debug((String)("Job timezone setting is " + this.getJobTimeZone()));
                }
                Logger.Debug((String)("Checkout updates between " + (lastBuildCal != null ? DateUtils.getStrDate((Calendar)lastBuildCal, (TimeZone)tz) : "0") + " -> " + DateUtils.getStrDate((Calendar)nowDateCal, (TimeZone)tz) + " (" + tz.getID() + ")"));
                if (this.dmSCM == null) {
                    Logger.Debug((String)"Creating new API interface object");
                    this.dmSCM = new DimensionsAPI();
                }
                if (!this.dmSCM.login(this.jobUserName, this.getJobPasswd(), this.jobDatabase, this.jobServer)) break block34;
                Logger.Debug((String)"Login worked.");
                StringBuffer cmdOutput = new StringBuffer();
                FilePath wa = null;
                if (this.workarea != null) {
                    File waN = new File(this.workarea);
                    wa = new FilePath(waN);
                } else {
                    wa = workspace;
                }
                if (bFreshBuild && listener.getLogger() != null) {
                    listener.getLogger().println("[DIMENSIONS] Checking out a fresh workspace because this project has not been built before...");
                    listener.getLogger().flush();
                }
                if (wa.exists() && (this.canJobDelete || bFreshBuild)) {
                    Logger.Debug((String)("Deleting '" + wa.toURI() + "'..."));
                    listener.getLogger().println("[DIMENSIONS] Removing '" + wa.toURI() + "'...");
                    listener.getLogger().flush();
                    wa.deleteRecursive();
                }
                VariableResolver myResolver = build.getBuildVariableResolver();
                String baseline = (String)myResolver.resolve("DM_BASELINE");
                String requests = (String)myResolver.resolve("DM_REQUEST");
                if (baseline != null) {
                    baseline = baseline.trim();
                    baseline = baseline.toUpperCase();
                }
                if (requests != null) {
                    requests = requests.replaceAll(" ", "");
                    requests = requests.toUpperCase();
                }
                Logger.Debug((String)("Extra parameters - " + baseline + " " + requests));
                String[] folders = this.getFolders();
                String cmdLog = null;
                if (baseline != null && baseline.length() == 0) {
                    baseline = null;
                }
                if (requests != null && requests.length() == 0) {
                    requests = null;
                }
                if (listener.getLogger() != null) {
                    if (requests != null) {
                        listener.getLogger().println("[DIMENSIONS] Checking out request(s) \"" + requests + "\" - ignoring project folders...");
                    } else if (baseline != null) {
                        listener.getLogger().println("[DIMENSIONS] Checking out baseline \"" + baseline + "\"...");
                    } else {
                        listener.getLogger().println("[DIMENSIONS] Checking out project \"" + this.getProject() + "\"...");
                    }
                    listener.getLogger().flush();
                }
                for (int ii = 0; ii < folders.length && bRet; ++ii) {
                    String folderN = folders[ii];
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    Logger.Debug((String)("Checking out '" + folderN + "'..."));
                    bRet = this.dmSCM.checkout(this.getProject(), dname, wa, lastBuildCal, nowDateCal, changelogFile, tz, cmdOutput, this.jobWebUrl, baseline, requests, true, this.canJobRevert);
                    Logger.Debug((String)("SCM checkout returned " + bRet));
                    if (!bRet && this.canJobForce) {
                        bRet = true;
                    }
                    if (cmdLog == null) {
                        cmdLog = "\n";
                    }
                    cmdLog = cmdLog + cmdOutput;
                    cmdOutput.setLength(0);
                    cmdLog = cmdLog + "\n";
                }
                OutputStreamWriter logFile = null;
                try {
                    logFile = new FileWriter(changelogFile, true);
                    PrintWriter fmtWriter = new PrintWriter(logFile);
                    fmtWriter.println("</changelog>");
                    logFile.flush();
                    bRet = true;
                }
                catch (Exception e) {
                    throw new IOException("Unable to write change log - " + e.getMessage());
                }
                finally {
                    logFile.close();
                }
                if (cmdLog.length() > 0 && listener.getLogger() != null) {
                    Logger.Debug((String)"Found command output to log to the build logger");
                    listener.getLogger().println("[DIMENSIONS] (Note: Dimensions command output was - ");
                    cmdLog = cmdLog.replaceAll("\n\n", "\n");
                    listener.getLogger().println(cmdLog.replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                    listener.getLogger().flush();
                }
                if (!bRet) {
                    listener.getLogger().println("[DIMENSIONS] ==========================================================");
                    listener.getLogger().println("[DIMENSIONS] The Dimensions checkout command returned a failure status.");
                    listener.getLogger().println("[DIMENSIONS] Please review the command output and correct any issues");
                    listener.getLogger().println("[DIMENSIONS] that may have been detected.");
                    listener.getLogger().println("[DIMENSIONS] ==========================================================");
                    listener.getLogger().flush();
                }
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "An unknown error occurred. Please try the operation again.";
                }
                listener.fatalError("Unable to run checkout callout - " + errMsg);
                bRet = false;
            }
            finally {
                this.dmSCM.logout();
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        boolean bChanged;
        block12: {
            bChanged = false;
            Logger.Debug((String)("Invoking pollChanges - " + this.getClass().getName()));
            Logger.Debug((String)("Checking job - " + project.getName()));
            if (this.getProject() == null || this.getProject().length() == 0) {
                return false;
            }
            if (project.getLastBuild() == null) {
                return true;
            }
            try {
                TimeZone tz;
                Calendar lastBuildCal = null;
                lastBuildCal = project.getLastSuccessfulBuild() != null && project.getLastSuccessfulBuild().getTimestamp() != null ? project.getLastSuccessfulBuild().getTimestamp() : project.getLastBuild().getTimestamp();
                Calendar nowDateCal = Calendar.getInstance();
                TimeZone timeZone = tz = this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0 ? TimeZone.getTimeZone(this.getJobTimeZone()) : TimeZone.getDefault();
                if (this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0) {
                    Logger.Debug((String)("Job timezone setting is " + this.getJobTimeZone()));
                }
                Logger.Debug((String)("Checking for any updates between " + (lastBuildCal != null ? DateUtils.getStrDate((Calendar)lastBuildCal, (TimeZone)tz) : "0") + " -> " + DateUtils.getStrDate((Calendar)nowDateCal, (TimeZone)tz) + " (" + tz.getID() + ")"));
                if (this.dmSCM == null) {
                    Logger.Debug((String)"Creating new API interface object");
                    this.dmSCM = new DimensionsAPI();
                }
                if (!this.dmSCM.login(this.jobUserName, this.getJobPasswd(), this.jobDatabase, this.jobServer)) break block12;
                String[] folders = this.getFolders();
                for (int ii = 0; ii < folders.length; ++ii) {
                    if (bChanged) {
                        break;
                    }
                    String folderN = folders[ii];
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    Logger.Debug((String)("Polling '" + folderN + "'..."));
                    bChanged = this.dmSCM.hasRepositoryBeenUpdated(this.getProject(), dname, lastBuildCal, nowDateCal, tz);
                }
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "An unknown error occurred. Please try the operation again.";
                }
                listener.fatalError("Unable to run pollChanges callout - " + errMsg);
                bChanged = false;
            }
            finally {
                this.dmSCM.logout();
            }
        }
        return bChanged;
    }

    public ChangeLogParser createChangeLogParser() {
        Logger.Debug((String)("Invoking createChangeLogParser - " + this.getClass().getName()));
        return new DimensionsChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DM_DESCRIPTOR;
    }
}

