/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.ArtifactUploader;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.Notifier;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactUploader
extends Notifier
implements Serializable {
    private static DimensionsSCM scm = null;
    private String[] patterns = new String[0];

    @DataBoundConstructor
    public ArtifactUploader(String[] patterns) {
        if (patterns != null) {
            Logger.Debug((String)"patterns are populated");
            Vector<String> x = new Vector<String>();
            for (int t = 0; t < patterns.length; ++t) {
                if (!StringUtils.isNotEmpty((String)patterns[t])) continue;
                x.add(patterns[t]);
            }
            this.patterns = x.toArray(new String[1]);
        } else {
            this.patterns[0] = ".*";
        }
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        block20: {
            Logger.Debug((String)("Invoking perform callout " + this.getClass().getName()));
            try {
                if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                    listener.fatalError("[DIMENSIONS] This plugin only works with the Dimensions SCM engine.");
                    throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
                }
                if (build.getResult() != Result.SUCCESS) break block20;
                listener.getLogger().println("[DIMENSIONS] Scanning workspace for files to be saved into Dimensions...");
                listener.getLogger().flush();
                ArtifactFilter af = new ArtifactFilter(this, this.patterns);
                FilePath wd = build.getProject().getWorkspace();
                Logger.Debug((String)("Scanning directory for files that match patterns '" + wd.getRemote() + "'"));
                File dir = new File(wd.getRemote());
                FileScanner fs = new FileScanner(this, dir, (FilenameFilter)af, -1);
                File[] validFiles = fs.toArray();
                if (fs.getFiles().size() > 0) {
                    if (scm == null) {
                        scm = (DimensionsSCM)build.getProject().getScm();
                    }
                    listener.getLogger().println("[DIMENSIONS] Loading files into Dimensions project \"" + scm.getProject() + "\"...");
                    listener.getLogger().flush();
                    Calendar nowDateCal = Calendar.getInstance();
                    File logFile = new File("a");
                    FileWriter logFileWriter = null;
                    PrintWriter fmtWriter = null;
                    File tmpFile = null;
                    try {
                        tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                        logFileWriter = new FileWriter(tmpFile);
                        fmtWriter = new PrintWriter((Writer)logFileWriter, true);
                        for (File f : validFiles) {
                            Logger.Debug((String)("Found file '" + f.getAbsolutePath() + "'"));
                            fmtWriter.println(f.getAbsolutePath());
                        }
                        fmtWriter.flush();
                    }
                    catch (Exception e) {
                        throw new IOException("Unable to write command log - " + e.getMessage());
                    }
                    finally {
                        fmtWriter.close();
                    }
                    Logger.Debug((String)("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer()));
                    if (scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer())) {
                        DimensionsResult res;
                        VariableResolver myResolver = build.getBuildVariableResolver();
                        String requests = (String)myResolver.resolve("DM_TARGET_REQUEST");
                        if (requests != null) {
                            requests = requests.replaceAll(" ", "");
                            requests = requests.toUpperCase();
                        }
                        if ((res = scm.getAPI().UploadFiles(wd, scm.getProject(), tmpFile, build, requests)) == null) {
                            listener.getLogger().println("[DIMENSIONS] New artifacts failed to get loaded into Dimensions");
                            listener.getLogger().flush();
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Build artifacts were successfully loaded into Dimensions");
                            listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                            listener.getLogger().flush();
                        }
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    break block20;
                }
                listener.getLogger().println("[DIMENSIONS] No build artifacts were detected");
                listener.getLogger().flush();
            }
            catch (Exception e) {
                listener.fatalError("Unable to load build artifacts into Dimensions - " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (scm != null) {
                    scm.getAPI().logout();
                }
            }
        }
        return true;
    }
}

