/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.model.User;
import hudson.plugins.dimensionsscm.DateUtils;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class DimensionsChangeSet
extends ChangeLogSet.Entry {
    private String developer;
    private String message;
    private String identifier;
    private Calendar date;
    private String version;
    private Collection<DmFiles> items = new HashSet<DmFiles>();
    private Collection<DmRequests> requests = new HashSet<DmRequests>();

    public DimensionsChangeSet() {
        this("", "", "", "", "", "", null);
    }

    public DimensionsChangeSet(String file, String developer, String op, String revision, String comment, String url, Calendar date) {
        this.identifier = file;
        this.developer = developer;
        this.message = comment;
        this.date = date;
        this.version = revision;
        this.items = new HashSet<DmFiles>();
        this.items.add(new DmFiles(file, op, url));
        this.requests = new HashSet<DmRequests>();
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public Date getDate() {
        return this.date.getTime();
    }

    public String getDeveloper() {
        return this.developer;
    }

    public String getSCMComment() {
        return this.message;
    }

    public void setDateString(String DateString) throws ParseException {
        this.date = Calendar.getInstance();
        TimeZone tz = TimeZone.getTimeZone("UTC");
        this.date.setTime(DateUtils.parse(DateString, tz));
    }

    public Collection<DmFiles> getFiles() {
        return this.items;
    }

    public Collection<DmRequests> getRequests() {
        return this.requests;
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.items.size());
        for (DmFiles item : this.items) {
            paths.add(item.getFile());
        }
        return paths;
    }

    public User getAuthor() {
        if (this.developer == null) {
            throw new RuntimeException("No author in this changeset!");
        }
        return User.get((String)this.developer, (boolean)true);
    }

    public String getMsg() {
        return this.message;
    }

    public String getId() {
        return this.identifier;
    }

    public void setVersion(String x) {
        this.version = x;
    }

    public String getVersion() {
        return this.version;
    }

    public void setUser(String x) {
        this.developer = x;
    }

    public String getUser() {
        return this.developer;
    }

    public void setComment(String x) {
        this.message = x;
    }

    public String getComment() {
        return this.getSCMComment();
    }

    public void add(DmFiles file) {
        this.items.add(file);
        file.setParent(this);
    }

    public void add(String file, String operation, String url) {
        DmFiles x = new DmFiles(file, operation, url);
        this.items.add(x);
        x.setParent(this);
    }

    public void addRequest(DmRequests newreq) {
        for (DmRequests req : this.requests) {
            if (!req.getIdentifier().equals(newreq.getIdentifier())) continue;
            return;
        }
        this.requests.add(newreq);
        newreq.setParent(this);
    }

    public void addRequest(String objectId, String url) {
        for (DmRequests req : this.requests) {
            if (!req.getIdentifier().equals(objectId)) continue;
            return;
        }
        DmRequests x = new DmRequests(objectId, url);
        this.requests.add(x);
        x.setParent(this);
    }

    public void addRequest(String objectId, String url, String title) {
        for (DmRequests req : this.requests) {
            if (!req.getIdentifier().equals(objectId)) continue;
            return;
        }
        DmRequests x = new DmRequests(objectId, url, title);
        this.requests.add(x);
        x.setParent(this);
    }

    @ExportedBean(defaultVisibility=999)
    public static class DmRequests {
        private String identifier;
        private String url;
        private String title;
        private DimensionsChangeSet parent;

        public DmRequests() {
            this("", "", "");
        }

        public DmRequests(String objectID, String url) {
            this.identifier = objectID;
            this.url = url;
            this.title = "";
        }

        public DmRequests(String objectID, String url, String title) {
            this.identifier = objectID;
            this.url = url;
            this.title = title;
        }

        @Exported
        public String getUrl() {
            if (this.url == null || this.url.length() == 0) {
                return null;
            }
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Exported
        public String getIdentifier() {
            if (this.identifier == null || this.identifier.length() == 0) {
                return null;
            }
            return this.identifier;
        }

        public void setIdentifier(String id) {
            this.identifier = id;
        }

        @Exported
        public String getTitle() {
            if (this.title == null || this.title.length() == 0) {
                return null;
            }
            return this.title;
        }

        public void setTitle(String id) {
            this.title = id;
        }

        public void setParent(DimensionsChangeSet parent) {
            this.parent = parent;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class DmFiles {
        private String fileName;
        private String operation;
        private String url;
        private DimensionsChangeSet parent;

        public DmFiles() {
            this("", "", "");
        }

        public DmFiles(String fileName, String operation, String url) {
            this.fileName = fileName;
            this.url = url;
            this.operation = operation;
        }

        @Exported
        public String getUrl() {
            if (this.url.length() == 0) {
                return null;
            }
            return this.url;
        }

        @Exported
        public String getOperation() {
            return this.operation;
        }

        @Exported
        public String getFile() {
            if (this.fileName.length() == 0) {
                return null;
            }
            return this.fileName;
        }

        public DimensionsChangeSet getParent() {
            return this.parent;
        }

        @Exported
        public EditType getEditType() {
            if (this.operation.equalsIgnoreCase("delete")) {
                return EditType.DELETE;
            }
            if (this.operation.equalsIgnoreCase("add")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setFile(String fileName) {
            this.fileName = fileName;
        }

        public void setParent(DimensionsChangeSet parent) {
            this.parent = parent;
        }
    }
}

