/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.model.AbstractBuild;
import hudson.model.Project;
import hudson.plugins.dimensionsscm.ArtifactUploader;
import hudson.plugins.dimensionsscm.DimensionsBuildNotifier;
import hudson.plugins.dimensionsscm.DimensionsBuildWrapper;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;

public class DimensionsChecker {
    public static boolean isValidPluginCombination(AbstractBuild build) {
        if (build.getProject() instanceof Project) {
            Project buildProject = (Project)build.getProject();
            if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                Logger.Debug("Not using a DimensionsSCM engine - bye");
                return false;
            }
            DimensionsBuildWrapper bwplugin = (DimensionsBuildWrapper)((Object)buildProject.getBuildWrappers().get((Object)DimensionsBuildWrapper.DMWBLD_DESCRIPTOR));
            DimensionsBuildNotifier bnplugin = (DimensionsBuildNotifier)build.getProject().getPublishersList().get(DimensionsBuildNotifier.class);
            ArtifactUploader anplugin = (ArtifactUploader)build.getProject().getPublishersList().get(ArtifactUploader.class);
            if (bwplugin != null) {
                Logger.Debug("DimensionsBuildWrapper is activated");
            }
            if (bnplugin != null) {
                Logger.Debug("DimensionsBuildNotifier is activated");
            }
            if (anplugin != null) {
                Logger.Debug("ArtifactUploader is activated");
            }
            if (bnplugin != null && bwplugin == null) {
                return false;
            }
        }
        return true;
    }
}

