/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsBuildWrapper
extends BuildWrapper {
    private static DimensionsSCM scm = null;
    public static final DescriptorImpl DMWBLD_DESCRIPTOR = new DescriptorImpl();

    public Descriptor<BuildWrapper> getDescriptor() {
        return DMWBLD_DESCRIPTOR;
    }

    @DataBoundConstructor
    public DimensionsBuildWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (build.getProject().getScm() instanceof DimensionsSCM) {
            Logger.Debug("Invoking build setup callout " + ((Object)((Object)this)).getClass().getName());
            if (scm == null) {
                scm = (DimensionsSCM)build.getProject().getScm();
            }
            Logger.Debug("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer());
            try {
                if (!scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer())) return new EnvironmentImpl(build);
                DimensionsResult res = scm.getAPI().lockProject(scm.getProject());
                if (res == null) {
                    listener.getLogger().println("[DIMENSIONS] Locking the project in Dimensions failed");
                    build.setResult(Result.FAILURE);
                    listener.getLogger().flush();
                    return new EnvironmentImpl(build);
                }
                listener.getLogger().println("[DIMENSIONS] Dimensions project was successfully locked");
                listener.getLogger().flush();
                return new EnvironmentImpl(build);
            }
            catch (Exception e) {
                listener.fatalError("Unable to lock Dimensions project - " + e.getMessage());
                return new EnvironmentImpl(build);
            }
            finally {
                scm.getAPI().logout();
            }
        } else {
            listener.fatalError("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
            build.setResult(Result.FAILURE);
            throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EnvironmentImpl
    extends BuildWrapper.Environment {
        AbstractBuild<?, ?> elbuild;

        EnvironmentImpl(AbstractBuild<?, ?> build) {
            super((BuildWrapper)DimensionsBuildWrapper.this);
            this.elbuild = build;
        }

        public void buildEnvVars(Map<String, String> env) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException {
            if (scm != null) {
                Logger.Debug("Invoking build tearDown callout " + ((Object)((Object)this)).getClass().getName());
                Logger.Debug("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer());
                try {
                    if (scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer())) {
                        Logger.Debug("Unlocking the project");
                        DimensionsResult res = scm.getAPI().unlockProject(scm.getProject());
                        if (res == null) {
                            listener.getLogger().println("[DIMENSIONS] Unlocking the project in Dimensions failed");
                            build.setResult(Result.FAILURE);
                            listener.getLogger().flush();
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Dimensions project was successfully unlocked");
                            listener.getLogger().flush();
                        }
                    }
                }
                catch (Exception e) {
                    listener.fatalError("Unable to unlock Dimensions project - " + e.getMessage());
                    build.setResult(Result.FAILURE);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    scm.getAPI().logout();
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(DimensionsBuildWrapper.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Lock Dimensions project while the build is in progress";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "DimensionsBuildWrapper");
            this.save();
            return true;
        }

        public String getHelpFile() {
            return "/plugin/dimensionsscm/helpbwrapper.html";
        }
    }
}

