/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.CheckOutAPITask;
import hudson.plugins.dimensionsscm.CheckOutCmdTask;
import hudson.plugins.dimensionsscm.DateUtils;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsBuildNotifier;
import hudson.plugins.dimensionsscm.DimensionsBuildWrapper;
import hudson.plugins.dimensionsscm.DimensionsChangeLogParser;
import hudson.plugins.dimensionsscm.DimensionsChecker;
import hudson.plugins.dimensionsscm.DimensionsSCMRepositoryBrowser;
import hudson.plugins.dimensionsscm.GetHostDetailsTask;
import hudson.plugins.dimensionsscm.Logger;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import hudson.util.Scrambler;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsSCM
extends SCM
implements Serializable {
    private String project;
    private String directory;
    private String workarea;
    private String jobUserName;
    private String jobPasswd;
    private String jobServer;
    private String jobDatabase;
    private String[] folders = new String[0];
    private String jobTimeZone;
    private String jobWebUrl;
    private boolean canJobUpdate;
    private boolean canJobDelete;
    private boolean canJobForce;
    private boolean canJobRevert;
    DimensionsAPI dmSCM;
    DimensionsSCMRepositoryBrowser browser;
    public static final DescriptorImpl DM_DESCRIPTOR = new DescriptorImpl();

    public DimensionsSCM getSCM() {
        return this;
    }

    public DimensionsAPI getAPI() {
        return this.dmSCM;
    }

    public String getProject() {
        return this.project;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String[] getFolders() {
        return this.folders;
    }

    public String getWorkarea() {
        return this.workarea;
    }

    public String getJobUserName() {
        return this.jobUserName;
    }

    public String getJobPasswd() {
        return Scrambler.descramble((String)this.jobPasswd);
    }

    public String getJobServer() {
        return this.jobServer;
    }

    public String getJobDatabase() {
        return this.jobDatabase;
    }

    public String getJobTimeZone() {
        return this.jobTimeZone;
    }

    public String getJobWebUrl() {
        return this.jobWebUrl;
    }

    public boolean isCanJobUpdate() {
        return this.canJobUpdate;
    }

    public boolean isCanJobDelete() {
        return this.canJobDelete;
    }

    public boolean isCanJobForce() {
        return this.canJobForce;
    }

    public boolean isCanJobRevert() {
        return this.canJobRevert;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean supportsPolling() {
        return true;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
    }

    public DimensionsSCM(String project, String directory, String workarea, boolean canJobDelete, boolean canJobForce, boolean canJobRevert, String jobUserName, String jobPasswd, String jobServer, String jobDatabase, boolean canJobUpdate, String jobTimeZone, String jobWebUrl) {
        this(project, null, workarea, canJobDelete, canJobForce, canJobRevert, jobUserName, jobPasswd, jobServer, jobDatabase, canJobUpdate, jobTimeZone, jobWebUrl, directory);
    }

    @DataBoundConstructor
    public DimensionsSCM(String project, String[] folders, String workarea, boolean canJobDelete, boolean canJobForce, boolean canJobRevert, String jobUserName, String jobPasswd, String jobServer, String jobDatabase, boolean canJobUpdate, String jobTimeZone, String jobWebUrl, String directory) {
        if (folders != null) {
            Logger.Debug("Folders are populated");
            Vector<String> x = new Vector<String>();
            for (int t = 0; t < folders.length; ++t) {
                if (!StringUtils.isNotEmpty((String)folders[t])) continue;
                x.add(folders[t]);
            }
            this.folders = x.toArray(new String[1]);
        } else if (directory != null) {
            this.folders[0] = directory;
        }
        if (this.folders.length < 2 && (this.folders[0] == null || this.folders[0].length() < 1)) {
            this.folders[0] = "/";
        }
        this.project = Util.fixEmptyAndTrim((String)project) == null ? "${JOB_NAME}" : project;
        this.workarea = Util.fixEmptyAndTrim((String)workarea) == null ? null : workarea;
        this.directory = Util.fixEmptyAndTrim((String)directory) == null ? null : directory;
        this.jobServer = Util.fixEmptyAndTrim((String)jobServer) == null ? this.getDescriptor().getServer() : jobServer;
        this.jobUserName = Util.fixEmptyAndTrim((String)jobUserName) == null ? this.getDescriptor().getUserName() : jobUserName;
        this.jobDatabase = Util.fixEmptyAndTrim((String)jobDatabase) == null ? this.getDescriptor().getDatabase() : jobDatabase;
        String passwd = Util.fixEmptyAndTrim((String)jobPasswd) == null ? this.getDescriptor().getPasswd() : jobPasswd;
        this.jobPasswd = Scrambler.scramble((String)passwd);
        this.canJobUpdate = canJobUpdate;
        this.canJobDelete = canJobDelete;
        this.canJobForce = canJobForce;
        this.canJobRevert = canJobRevert;
        this.jobTimeZone = Util.fixEmptyAndTrim((String)jobTimeZone) == null ? this.getDescriptor().getTimeZone() : jobTimeZone;
        this.jobWebUrl = Util.fixEmptyAndTrim((String)jobWebUrl) == null ? this.getDescriptor().getWebUrl() : jobWebUrl;
        String dmS = this.jobServer + "-" + this.jobUserName + ":" + this.jobDatabase;
        Logger.Debug("Starting job for project '" + this.project + "' ('" + this.folders.length + "')" + ", connecting to " + dmS);
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean bRet = false;
        if (!this.isCanJobUpdate()) {
            Logger.Debug("Skipping checkout - " + this.getClass().getName());
        }
        Logger.Debug("Invoking checkout - " + this.getClass().getName());
        try {
            DimensionsBuildWrapper.DescriptorImpl bwplugin = (DimensionsBuildWrapper.DescriptorImpl)Hudson.getInstance().getDescriptor(DimensionsBuildWrapper.class);
            DimensionsBuildNotifier.DescriptorImpl bnplugin = (DimensionsBuildNotifier.DescriptorImpl)Hudson.getInstance().getDescriptor(DimensionsBuildNotifier.class);
            if (!DimensionsChecker.isValidPluginCombination(build)) {
                listener.fatalError("\n[DIMENSIONS] The plugin combinations you have selected are not valid.");
                listener.fatalError("\n[DIMENSIONS] Please review online help to determine valid plugin uses.");
                return false;
            }
            Logger.Debug("Plugins are ok");
            if (this.isCanJobUpdate()) {
                InetAddress netAddr = InetAddress.getLocalHost();
                byte[] ipAddr = netAddr.getAddress();
                String hostname = netAddr.getHostName();
                boolean master = false;
                GetHostDetailsTask buildHost = new GetHostDetailsTask(hostname);
                master = (Boolean)workspace.act((FilePath.FileCallable)buildHost);
                if (master) {
                    listener.getLogger().println("[DIMENSIONS] Running checkout on master...");
                    listener.getLogger().flush();
                    CheckOutAPITask task = new CheckOutAPITask(build, this, workspace, (TaskListener)listener);
                    bRet = (Boolean)workspace.act((FilePath.FileCallable)task);
                } else {
                    int version = 2009;
                    long key = this.dmSCM.login(this.getJobUserName(), this.getJobPasswd(), this.getJobDatabase(), this.getJobServer());
                    if (key > 0L) {
                        Logger.Debug("Login worked.");
                        version = this.dmSCM.getDmVersion();
                        if (version == 0) {
                            version = 2009;
                        }
                        this.dmSCM.logout(key);
                    }
                    VariableResolver myResolver = build.getBuildVariableResolver();
                    String baseline = (String)myResolver.resolve("DM_BASELINE");
                    String requests = (String)myResolver.resolve("DM_REQUEST");
                    listener.getLogger().println("[DIMENSIONS] Running checkout on slave...");
                    listener.getLogger().flush();
                    CheckOutCmdTask task = new CheckOutCmdTask(this.getJobUserName(), this.getJobPasswd(), this.getJobDatabase(), this.getJobServer(), this.getProject(), baseline, requests, this.isCanJobDelete(), this.isCanJobRevert(), this.isCanJobForce(), build.getPreviousBuild() == null, this.getFolders(), version, workspace, (TaskListener)listener);
                    bRet = (Boolean)workspace.act((FilePath.FileCallable)task);
                }
            } else {
                bRet = true;
            }
            if (bRet) {
                bRet = this.generateChangeSet(build, listener, changelogFile);
            }
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            listener.fatalError("Unable to run checkout callout - " + errMsg);
            bRet = false;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateChangeSet(AbstractBuild build, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean bRet;
        block17: {
            long key = -1L;
            bRet = false;
            DimensionsAPI dmSCM = new DimensionsAPI();
            try {
                TimeZone tz;
                Calendar lastBuildCal = build.getPreviousNotFailedBuild() != null ? build.getPreviousNotFailedBuild().getTimestamp() : null;
                Calendar nowDateCal = Calendar.getInstance();
                TimeZone timeZone = tz = this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0 ? TimeZone.getTimeZone(this.getJobTimeZone()) : TimeZone.getDefault();
                if (this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0) {
                    Logger.Debug("Job timezone setting is " + this.getJobTimeZone());
                }
                Logger.Debug("Log updates between " + (lastBuildCal != null ? DateUtils.getStrDate(lastBuildCal, tz) : "0") + " -> " + DateUtils.getStrDate(nowDateCal, tz) + " (" + tz.getID() + ")");
                dmSCM.setLogger(listener.getLogger());
                key = dmSCM.login(this.getJobUserName(), this.getJobPasswd(), this.getJobDatabase(), this.getJobServer());
                if (key <= 0L) break block17;
                Logger.Debug("Login worked.");
                VariableResolver myResolver = build.getBuildVariableResolver();
                String baseline = (String)myResolver.resolve("DM_BASELINE");
                String requests = (String)myResolver.resolve("DM_REQUEST");
                if (baseline != null) {
                    baseline = baseline.trim();
                    baseline = baseline.toUpperCase();
                }
                if (requests != null) {
                    requests = requests.replaceAll(" ", "");
                    requests = requests.toUpperCase();
                }
                Logger.Debug("Extra parameters - " + baseline + " " + requests);
                String[] folders = this.getFolders();
                if (baseline != null && baseline.length() == 0) {
                    baseline = null;
                }
                if (requests != null && requests.length() == 0) {
                    requests = null;
                }
                bRet = true;
                for (int ii = 0; ii < folders.length && bRet; ++ii) {
                    String folderN = folders[ii];
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    Logger.Debug("Looking for changes in '" + folderN + "'...");
                    bRet = dmSCM.createChangeSetLogs(key, this.getProject(), dname, lastBuildCal, nowDateCal, changelogFile, tz, this.jobWebUrl, baseline, requests);
                }
                OutputStreamWriter logFile = null;
                try {
                    logFile = new FileWriter(changelogFile, true);
                    PrintWriter fmtWriter = new PrintWriter(logFile);
                    fmtWriter.println("</changelog>");
                    logFile.flush();
                    bRet = true;
                }
                catch (Exception e) {
                    throw new IOException("Unable to write change log - " + e.getMessage());
                }
                finally {
                    logFile.close();
                }
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "An unknown error occurred. Please try the operation again.";
                }
                listener.fatalError("Unable to run change set callout - " + errMsg);
                bRet = false;
            }
            finally {
                dmSCM.logout(key);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        boolean bChanged;
        block12: {
            bChanged = false;
            Logger.Debug("Invoking pollChanges - " + this.getClass().getName());
            Logger.Debug("Checking job - " + project.getName());
            long key = -1L;
            if (this.getProject() == null || this.getProject().length() == 0) {
                return false;
            }
            if (project.getLastBuild() == null) {
                return true;
            }
            try {
                TimeZone tz;
                Calendar lastBuildCal = null;
                lastBuildCal = project.getLastSuccessfulBuild() != null && project.getLastSuccessfulBuild().getTimestamp() != null ? project.getLastSuccessfulBuild().getTimestamp() : project.getLastBuild().getTimestamp();
                Calendar nowDateCal = Calendar.getInstance();
                TimeZone timeZone = tz = this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0 ? TimeZone.getTimeZone(this.getJobTimeZone()) : TimeZone.getDefault();
                if (this.getJobTimeZone() != null && this.getJobTimeZone().length() > 0) {
                    Logger.Debug("Job timezone setting is " + this.getJobTimeZone());
                }
                Logger.Debug("Checking for any updates between " + (lastBuildCal != null ? DateUtils.getStrDate(lastBuildCal, tz) : "0") + " -> " + DateUtils.getStrDate(nowDateCal, tz) + " (" + tz.getID() + ")");
                if (this.dmSCM == null) {
                    Logger.Debug("Creating new API interface object");
                    this.dmSCM = new DimensionsAPI();
                }
                this.dmSCM.setLogger(listener.getLogger());
                key = this.dmSCM.login(this.jobUserName, this.getJobPasswd(), this.jobDatabase, this.jobServer);
                if (key <= 0L) break block12;
                String[] folders = this.getFolders();
                for (int ii = 0; ii < folders.length; ++ii) {
                    if (bChanged) {
                        break;
                    }
                    String folderN = folders[ii];
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    Logger.Debug("Polling using key " + key);
                    Logger.Debug("Polling '" + folderN + "'...");
                    bChanged = this.dmSCM.hasRepositoryBeenUpdated(key, this.getProject(), dname, lastBuildCal, nowDateCal, tz);
                }
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "An unknown error occurred. Please try the operation again.";
                }
                listener.fatalError("Unable to run pollChanges callout - " + errMsg);
                bChanged = false;
            }
            finally {
                this.dmSCM.logout(key);
            }
        }
        return bChanged;
    }

    public ChangeLogParser createChangeLogParser() {
        Logger.Debug("Invoking createChangeLogParser - " + this.getClass().getName());
        return new DimensionsChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DM_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<DimensionsSCM>
    implements ModelObject {
        DimensionsAPI connectionCheck = null;
        private String server;
        private String userName;
        private String passwd;
        private String database;
        private String timeZone;
        private String webUrl;
        private boolean canUpdate;

        public DescriptorImpl() {
            super(DimensionsSCM.class, DimensionsSCMRepositoryBrowser.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Dimensions";
        }

        public boolean configure(StaplerRequest req, JSONObject jobj) throws Descriptor.FormException {
            this.userName = req.getParameter("dimensionsscm.userName");
            this.passwd = req.getParameter("dimensionsscm.passwd");
            this.server = req.getParameter("dimensionsscm.server");
            this.database = req.getParameter("dimensionsscm.database");
            this.timeZone = req.getParameter("dimensionsscm.timeZone");
            this.webUrl = req.getParameter("dimensionsscm.webUrl");
            if (this.userName != null) {
                this.userName = Util.fixNull((String)req.getParameter("dimensionsscm.userName").trim());
            }
            if (this.passwd != null) {
                this.passwd = Util.fixNull((String)req.getParameter("dimensionsscm.passwd").trim());
            }
            if (this.server != null) {
                this.server = Util.fixNull((String)req.getParameter("dimensionsscm.server").trim());
            }
            if (this.database != null) {
                this.database = Util.fixNull((String)req.getParameter("dimensionsscm.database").trim());
            }
            if (this.timeZone != null) {
                this.timeZone = Util.fixNull((String)req.getParameter("dimensionsscm.timeZone").trim());
            }
            if (this.webUrl != null) {
                this.webUrl = Util.fixNull((String)req.getParameter("dimensionsscm.webUrl").trim());
            }
            req.bindJSON((Object)DM_DESCRIPTOR, jobj);
            this.save();
            return super.configure(req, jobj);
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] folders = req.getParameterValues("dimensionsscm.folders");
            String project = req.getParameter("dimensionsscm.project");
            String directory = req.getParameter("dimensionsscm.directory");
            String workarea = req.getParameter("dimensionsscm.workarea");
            Boolean canJobDelete = "on".equalsIgnoreCase(req.getParameter("dimensionsscm.canJobDelete"));
            Boolean canJobForce = "on".equalsIgnoreCase(req.getParameter("dimensionsscm.canJobForce"));
            Boolean canJobRevert = "on".equalsIgnoreCase(req.getParameter("dimensionsscm.canJobRevert"));
            Boolean canJobUpdate = "on".equalsIgnoreCase(req.getParameter("dimensionsscm.canJobUpdate"));
            String jobUserName = req.getParameter("dimensionsscm.jobUserName");
            String jobPasswd = req.getParameter("dimensionsscm.jobPasswd");
            String jobServer = req.getParameter("dimensionsscm.jobServer");
            String jobDatabase = req.getParameter("dimensionsscm.jobDatabase");
            String jobTimeZone = req.getParameter("dimensionsscm.jobTimeZone");
            String jobWebUrl = req.getParameter("dimensionsscm.jobWebUrl");
            DimensionsSCM scm = new DimensionsSCM(project, folders, workarea, canJobDelete, canJobForce, canJobRevert, jobUserName, jobPasswd, jobServer, jobDatabase, canJobUpdate, jobTimeZone, jobWebUrl, directory);
            scm.browser = (DimensionsSCMRepositoryBrowser)RepositoryBrowsers.createInstance(DimensionsSCMRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            if (scm.dmSCM == null) {
                scm.dmSCM = new DimensionsAPI();
            }
            return scm;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getServer() {
            return this.server;
        }

        public String getPasswd() {
            return Scrambler.descramble((String)this.passwd);
        }

        public boolean isCanUpdate() {
            return this.canUpdate;
        }

        public void setCanUpdate(boolean x) {
            this.canUpdate = x;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public void setPasswd(String password) {
            this.passwd = Scrambler.scramble((String)password);
        }

        public void setTimeZone(String x) {
            this.timeZone = x;
        }

        public void setWebUrl(String x) {
            this.webUrl = x;
        }

        private void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    String nullText = null;
                    if (value == null) {
                        if (nullText == null) {
                            this.ok();
                        } else {
                            this.error(nullText);
                        }
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void domanadatoryFieldCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    String errorTxt = "This value is manadatory.";
                    if (value == null) {
                        this.error(errorTxt);
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void domanadatoryJobFieldCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    String errorTxt = "This value is manadatory.";
                    this.ok();
                }
            }.process();
        }

        public void docheckTz(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="dimensionsscm.timeZone") String timezone, final @QueryParameter(value="dimensionsscm.jobTimeZone") String jobtimezone) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    try {
                        String xtz = jobtimezone != null ? jobtimezone : timezone;
                        Logger.Debug("Invoking docheckTz - " + xtz);
                        TimeZone ctz = TimeZone.getTimeZone(xtz);
                        String lmt = ctz.getID();
                        if (!(!lmt.equalsIgnoreCase("GMT") || xtz.equalsIgnoreCase("GMT") || xtz.equalsIgnoreCase("Greenwich Mean Time") || xtz.equalsIgnoreCase("UTC") || xtz.equalsIgnoreCase("Coordinated Universal Time"))) {
                            this.error("Timezone specified is not valid.");
                        } else {
                            this.ok("Timezone test succeeded!");
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.error("timezone check error:" + e.getMessage());
                        return;
                    }
                }
            }.process();
        }

        public void docheckServer(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="dimensionsscm.userName") String user, final @QueryParameter(value="dimensionsscm.passwd") String passwd, final @QueryParameter(value="dimensionsscm.server") String server, final @QueryParameter(value="dimensionsscm.database") String database, final @QueryParameter(value="dimensionsscm.jobUserName") String jobuser, final @QueryParameter(value="dimensionsscm.jobPasswd") String jobPasswd, final @QueryParameter(value="dimensionsscm.jobServer") String jobServer, final @QueryParameter(value="dimensionsscm.jobDatabase") String jobDatabase) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    if (DescriptorImpl.this.connectionCheck == null) {
                        DescriptorImpl.this.connectionCheck = new DimensionsAPI();
                    }
                    try {
                        String xserver = jobServer != null ? jobServer : server;
                        String xuser = jobuser != null ? jobuser : user;
                        String xpasswd = jobPasswd != null ? jobPasswd : passwd;
                        String xdatabase = jobDatabase != null ? jobDatabase : database;
                        long key = -1L;
                        String dmS = xserver + "-" + xuser + ":" + xdatabase;
                        Logger.Debug("Invoking serverCheck - " + dmS);
                        key = DescriptorImpl.this.connectionCheck.login(xuser, xpasswd, xdatabase, xserver);
                        if (key < 1L) {
                            this.error("Connection test failed");
                        } else {
                            this.ok("Connection test succeeded!");
                            DescriptorImpl.this.connectionCheck.logout(key);
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.error("Server connection error:" + e.getMessage());
                        return;
                    }
                }
            }.process();
        }
    }
}

