/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.ArtifactUploader;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactUploader
extends Notifier
implements Serializable {
    private static DimensionsSCM scm = null;
    private String[] patterns = new String[0];
    private boolean forceCheckIn = false;
    private boolean forceTip = false;
    private String owningPart = null;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundConstructor
    public ArtifactUploader(String[] patterns, boolean fTip, boolean fMerge, String part) {
        if (patterns != null) {
            Logger.Debug((String)"patterns are populated");
            Vector<String> x = new Vector<String>();
            for (int t = 0; t < patterns.length; ++t) {
                if (!StringUtils.isNotEmpty((String)patterns[t])) continue;
                x.add(patterns[t]);
            }
            this.patterns = x.toArray(new String[1]);
        } else {
            this.patterns[0] = ".*";
        }
        this.forceCheckIn = fTip;
        this.forceTip = fMerge;
        this.owningPart = part;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String getOwningPart() {
        return this.owningPart;
    }

    public boolean isForceCheckIn() {
        return this.forceCheckIn;
    }

    public boolean isForceTip() {
        return this.forceTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        block23: {
            long key = -1L;
            Logger.Debug((String)("Invoking perform callout " + this.getClass().getName()));
            try {
                if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                    listener.fatalError("[DIMENSIONS] This plugin only works with the Dimensions SCM engine.");
                    build.setResult(Result.FAILURE);
                    throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
                }
                if (build.getResult() != Result.SUCCESS) break block23;
                listener.getLogger().println("[DIMENSIONS] Scanning workspace for files to be saved into Dimensions...");
                listener.getLogger().flush();
                ArtifactFilter af = new ArtifactFilter(this, this.patterns);
                FilePath wd = build.getWorkspace();
                Logger.Debug((String)("Scanning directory for files that match patterns '" + wd.getRemote() + "'"));
                File dir = new File(wd.getRemote());
                FileScanner fs = new FileScanner(this, dir, (FilenameFilter)af, -1);
                File[] validFiles = fs.toArray();
                if (fs.getFiles().size() > 0) {
                    if (scm == null) {
                        scm = (DimensionsSCM)build.getProject().getScm();
                    }
                    listener.getLogger().println("[DIMENSIONS] Loading files into Dimensions project \"" + scm.getProject() + "\"...");
                    listener.getLogger().flush();
                    Calendar nowDateCal = Calendar.getInstance();
                    File logFile = new File("a");
                    FileWriter logFileWriter = null;
                    PrintWriter fmtWriter = null;
                    File tmpFile = null;
                    try {
                        tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                        logFileWriter = new FileWriter(tmpFile);
                        fmtWriter = new PrintWriter((Writer)logFileWriter, true);
                        for (File f : validFiles) {
                            Logger.Debug((String)("Found file '" + f.getAbsolutePath() + "'"));
                            fmtWriter.println(f.getAbsolutePath());
                        }
                        fmtWriter.flush();
                    }
                    catch (Exception e) {
                        build.setResult(Result.FAILURE);
                        throw new IOException("Unable to write command log - " + e.getMessage());
                    }
                    finally {
                        fmtWriter.close();
                    }
                    Logger.Debug((String)("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer()));
                    key = scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer());
                    if (key > 0L) {
                        DimensionsResult res;
                        VariableResolver myResolver = build.getBuildVariableResolver();
                        String requests = (String)myResolver.resolve("DM_TARGET_REQUEST");
                        if (requests != null) {
                            requests = requests.replaceAll(" ", "");
                            requests = requests.toUpperCase();
                        }
                        if ((res = scm.getAPI().UploadFiles(key, wd, scm.getProject(), tmpFile, build, requests, this.forceCheckIn, this.forceTip, this.owningPart)) == null) {
                            listener.getLogger().println("[DIMENSIONS] New artifacts failed to get loaded into Dimensions");
                            listener.getLogger().flush();
                            build.setResult(Result.FAILURE);
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Build artifacts were successfully loaded into Dimensions");
                            listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                            listener.getLogger().flush();
                        }
                    } else {
                        if (tmpFile != null) {
                            tmpFile.delete();
                        }
                        listener.fatalError("[DIMENSIONS] Login to Dimensions failed.");
                        build.setResult(Result.FAILURE);
                        boolean bl = false;
                        return bl;
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    break block23;
                }
                listener.getLogger().println("[DIMENSIONS] No build artifacts were detected");
                listener.getLogger().flush();
            }
            catch (Exception e) {
                listener.fatalError("Unable to load build artifacts into Dimensions - " + e.getMessage());
                build.setResult(Result.FAILURE);
                boolean bl = false;
                return bl;
            }
            finally {
                if (scm != null) {
                    scm.getAPI().logout(key);
                }
            }
        }
        return true;
    }
}

