/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.Logger;
import hudson.remoting.VirtualChannel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CheckOutCmdTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1L;
    private boolean bFreshBuild = false;
    private boolean isDelete = false;
    private boolean isRevert = false;
    private boolean isForce = false;
    private FilePath workspace = null;
    private TaskListener listener = null;
    private String userName = "";
    private String passwd = "";
    private String database = "";
    private String server = "";
    private int version = 2009;
    private String workarea = "";
    private String projectId = "";
    private String baseline = null;
    private String requests = null;
    private String permissions = null;
    private String[] folders;
    private String exec = "dmcli";

    private final byte[] loadFile(File fileName) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
        byte[] bytes = new byte[(int)fileName.length()];
        bis.read(bytes);
        bis.close();
        return bytes;
    }

    private static File getExecutable(String exeName) {
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("path");
        }
        if (path == null) {
            return null;
        }
        String[] pathDirs = path.split(File.pathSeparator);
        File exe = null;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, exeName);
            if (!file.isFile()) continue;
            exe = file;
            break;
        }
        return exe;
    }

    private File createParamFile() throws IOException {
        Calendar nowDateCal = Calendar.getInstance();
        File logFile = new File("a");
        FileWriter logFileWriter = null;
        PrintWriter fmtWriter = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
            logFileWriter = new FileWriter(tmpFile);
            fmtWriter = new PrintWriter((Writer)logFileWriter, true);
            fmtWriter.println("-host " + this.server);
            fmtWriter.println("-user " + this.userName);
            fmtWriter.println("-pass " + this.passwd);
            fmtWriter.println("-dbname " + this.database);
            fmtWriter.flush();
        }
        catch (Exception e) {
            throw new IOException("Unable to write command log - " + e.getMessage());
        }
        finally {
            fmtWriter.close();
        }
        return tmpFile;
    }

    private File createCmdFile(String projDir, File area) throws IOException {
        Calendar nowDateCal = Calendar.getInstance();
        File logFile = new File("a");
        FileWriter logFileWriter = null;
        PrintWriter fmtWriter = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
            logFileWriter = new FileWriter(tmpFile);
            fmtWriter = new PrintWriter((Writer)logFileWriter, true);
            String coCmd = "UPDATE /BRIEF ";
            if (this.version == 10) {
                coCmd = "DOWNLOAD ";
            }
            String cmd = coCmd;
            if (projDir != null && !projDir.equals("\\") && !projDir.equals("/") && this.requests == null) {
                cmd = cmd + "/DIR=\"" + projDir + "\"";
            }
            if (this.requests != null) {
                cmd = this.requests.indexOf(",") == 0 ? cmd + "/CHANGE_DOC_IDS=(\"" + this.requests + "\") " : cmd + "/CHANGE_DOC_IDS=(" + this.requests + ") ";
                cmd = cmd + "/WORKSET=\"" + this.projectId + "\" ";
            } else {
                cmd = this.baseline != null ? cmd + "/BASELINE=\"" + this.baseline + "\"" : cmd + "/WORKSET=\"" + this.projectId + "\" ";
            }
            cmd = cmd + "/USER_DIR=\"" + area.getAbsolutePath() + "\" ";
            if (this.isRevert) {
                cmd = cmd + " /OVERWRITE";
            }
            if (this.permissions != null && this.permissions.length() > 0 && !this.permissions.equals("DEFAULT")) {
                cmd = cmd + "/PERMS=" + this.permissions;
            }
            fmtWriter.println(cmd);
            fmtWriter.flush();
        }
        catch (Exception e) {
            throw new IOException("Unable to write command log - " + e.getMessage());
        }
        finally {
            fmtWriter.close();
        }
        return tmpFile;
    }

    public CheckOutCmdTask(String userName, String passwd, String database, String server, String projectId, String baselineId, String requestId, boolean isDelete, boolean isRevert, boolean isForce, boolean freshBuild, String[] folders, int version, String permissions, FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.userName = userName;
        this.passwd = passwd;
        this.database = database;
        this.server = server;
        this.version = version;
        this.isDelete = isDelete;
        this.projectId = projectId;
        this.isRevert = isRevert;
        this.isForce = isForce;
        this.folders = folders;
        this.requests = requestId;
        this.baseline = baselineId;
        this.permissions = permissions;
        this.bFreshBuild = freshBuild;
    }

    public Boolean invoke(File area, VirtualChannel channel) throws IOException {
        boolean retStatus = false;
        try {
            File exe;
            this.listener.getLogger().println("[DIMENSIONS] Running build in '" + area.getAbsolutePath() + "'...");
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                this.exec = this.exec + ".exe";
            }
            if ((exe = CheckOutCmdTask.getExecutable((String)this.exec)) == null) {
                this.listener.getLogger().println("[DIMENSIONS] Error: Cannot locate '" + this.exec + "' on the slave node.");
            } else {
                this.listener.getLogger().println("[DIMENSIONS] Located '" + exe.getAbsolutePath() + "' on the slave node.");
                File param = this.createParamFile();
                if (param == null) {
                    this.listener.getLogger().println("[DIMENSIONS] Error: Cannot create parameter file for Dimensions login.");
                    return false;
                }
                retStatus = this.processCheckout(exe, param, area);
                param.delete();
            }
            return retStatus;
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run checkout callout - " + errMsg);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean processCheckout(File exe, File param, File area) throws IOException {
        FilePath wa = new FilePath(area);
        boolean bRet = true;
        Launcher.LocalLauncher proc = new Launcher.LocalLauncher(this.listener);
        try {
            if (this.bFreshBuild && this.listener.getLogger() != null) {
                this.listener.getLogger().println("[DIMENSIONS] Checking out a fresh workspace because this project has not been built before...");
                this.listener.getLogger().flush();
            }
            if (wa.exists() && (this.isDelete || this.bFreshBuild)) {
                Logger.Debug((String)("Deleting '" + wa.toURI() + "'..."));
                this.listener.getLogger().println("[DIMENSIONS] Removing '" + wa.toURI() + "'...");
                this.listener.getLogger().flush();
                wa.deleteContents();
            }
            if (this.baseline != null) {
                this.baseline = this.baseline.trim();
                this.baseline = this.baseline.toUpperCase();
            }
            if (this.requests != null) {
                this.requests = this.requests.replaceAll(" ", "");
                this.requests = this.requests.toUpperCase();
            }
            String cmdLog = null;
            if (this.baseline != null && this.baseline.length() == 0) {
                this.baseline = null;
            }
            if (this.requests != null && this.requests.length() == 0) {
                this.requests = null;
            }
            if (this.listener.getLogger() != null) {
                if (this.requests != null) {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out request(s) \"" + this.requests + "\" - ignoring project folders...");
                } else if (this.baseline != null) {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out baseline \"" + this.baseline + "\"...");
                } else {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out project \"" + this.projectId + "\"...");
                }
                this.listener.getLogger().flush();
            }
            for (int ii = 0; ii < this.folders.length && bRet; ++ii) {
                String folderN = this.folders[ii];
                File fileName = new File(folderN);
                FilePath projectDir = new FilePath(fileName);
                String projDir = projectDir != null ? projectDir.getRemote() : null;
                File cmdFile = this.createCmdFile(projDir, area);
                if (cmdFile == null) {
                    this.listener.getLogger().println("[DIMENSIONS] Error: Cannot create command file for Dimensions login.");
                    param.delete();
                    return false;
                }
                this.listener.getLogger().println("[DIMENSIONS] Checking out directory '" + (projDir != null ? projDir : "/") + "'...");
                this.listener.getLogger().flush();
                String[] cmd = new String[]{exe.getAbsolutePath(), "-param", param.getAbsolutePath(), "cmd", cmdFile.getAbsolutePath()};
                File tmpFile = null;
                File logFile = new File("a");
                Calendar nowDateCal = Calendar.getInstance();
                tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                FileOutputStream fos = new FileOutputStream(tmpFile);
                StreamBuildListener os = new StreamBuildListener((OutputStream)fos);
                try {
                    Launcher.ProcStarter ps = proc.launch();
                    ps.cmds(cmd);
                    ps.stdout((OutputStream)os.getLogger());
                    ps.stdin(null);
                    ps.pwd(wa);
                    int cmdResult = ps.join();
                    cmdFile.delete();
                    if (cmdResult != 0) {
                        this.listener.fatalError("Execution of checkout failed with exit code " + cmdResult);
                        bRet = false;
                    }
                }
                finally {
                    os.getLogger().flush();
                    fos.close();
                    os = null;
                    fos = null;
                }
                if (tmpFile != null) {
                    String outputStr = new String(this.loadFile(tmpFile));
                    tmpFile.delete();
                    tmpFile = null;
                    int confl = outputStr.indexOf("C\t");
                    if (confl > 0) {
                        bRet = false;
                    }
                    if (cmdLog == null) {
                        cmdLog = "\n";
                    }
                    cmdLog = cmdLog + outputStr;
                    cmdLog = cmdLog + "\n";
                }
                if (bRet || !this.isForce) continue;
                bRet = true;
            }
            param.delete();
            if (cmdLog.length() > 0 && this.listener.getLogger() != null) {
                this.listener.getLogger().println("[DIMENSIONS] (Note: Dimensions command output was - ");
                cmdLog = cmdLog.replaceAll("\n\n", "\n");
                this.listener.getLogger().println(cmdLog.replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                this.listener.getLogger().flush();
            }
            if (!bRet) {
                this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                this.listener.getLogger().println("[DIMENSIONS] The Dimensions checkout command returned a failure status.");
                this.listener.getLogger().println("[DIMENSIONS] Please review the command output and correct any issues");
                this.listener.getLogger().println("[DIMENSIONS] that may have been detected.");
                this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                this.listener.getLogger().flush();
            }
            return bRet;
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run checkout callout - " + errMsg);
            return false;
        }
    }
}

