/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.Util;
import hudson.plugins.dimensionsscm.DimensionsChangeSet;
import hudson.plugins.dimensionsscm.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DimensionsChangeLogWriter {
    public boolean writeLog(List<DimensionsChangeSet> changeSets, File changelogFile) throws IOException {
        boolean bRet = false;
        boolean appendFile = false;
        OutputStreamWriter logFile = null;
        if (changelogFile.exists() && changelogFile.length() > 0L) {
            appendFile = true;
        }
        try {
            logFile = new FileWriter(changelogFile, appendFile);
            this.write(changeSets, (Writer)logFile, appendFile);
            logFile.flush();
            bRet = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to write change log - " + e.getMessage());
        }
        finally {
            logFile.close();
        }
        return bRet;
    }

    private void write(List<DimensionsChangeSet> changeSets, Writer logFile, boolean appendFile) {
        Logger.Debug((String)("Writing logfile in append mode = " + appendFile));
        String logStr = "";
        PrintWriter writer = new PrintWriter(logFile);
        if (!appendFile) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<changelog>");
        }
        if (changeSets != null) {
            for (DimensionsChangeSet changeSet : changeSets) {
                logStr = logStr + String.format("\t<changeset version=\"%s\">\n", DimensionsChangeLogWriter.escapeXML((String)changeSet.getVersion()));
                logStr = logStr + String.format("\t\t<date>%s</date>\n", Util.XS_DATETIME_FORMATTER.format(changeSet.getDate()));
                logStr = logStr + String.format("\t\t<user>%s</user>\n", DimensionsChangeLogWriter.escapeXML((String)changeSet.getDeveloper()));
                logStr = logStr + String.format("\t\t<comment>%s</comment>\n", DimensionsChangeLogWriter.escapeXML((String)changeSet.getSCMComment()));
                logStr = logStr + "\t\t<items>\n";
                for (DimensionsChangeSet.DmFiles item : changeSet.getFiles()) {
                    logStr = logStr + String.format("\t\t\t<item operation=\"%s\" url=\"%s\">%s</item>\n", item.getOperation(), DimensionsChangeLogWriter.escapeHTML((String)item.getUrl()), DimensionsChangeLogWriter.escapeXML((String)item.getFile()));
                }
                logStr = logStr + "\t\t</items>\n";
                logStr = logStr + "\t\t<requests>\n";
                for (DimensionsChangeSet.DmRequests req : changeSet.getRequests()) {
                    logStr = logStr + String.format("\t\t\t<request url=\"%s\" title=\"%s\">%s</request>\n", DimensionsChangeLogWriter.escapeHTML((String)req.getUrl()), DimensionsChangeLogWriter.escapeXML((String)req.getTitle()), DimensionsChangeLogWriter.escapeXML((String)req.getIdentifier()));
                }
                logStr = logStr + "\t\t</requests>\n";
                logStr = logStr + "\t</changeset>\n";
            }
        }
        Logger.Debug((String)("Writing to logfile '" + logStr + "'"));
        if (appendFile) {
            writer.append(logStr);
        } else {
            writer.print(logStr);
        }
    }

    private static String escapeXML(String inTxt) {
        if (inTxt == null || inTxt.length() == 0) {
            return inTxt;
        }
        StringBuilder outTxt = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(inTxt);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                outTxt.append("&lt;");
            } else if (character == '>') {
                outTxt.append("&gt;");
            } else if (character == '\"') {
                outTxt.append("&quot;");
            } else if (character == '\'') {
                outTxt.append("&#039;");
            } else if (character == '&') {
                outTxt.append("&amp;");
            } else {
                outTxt.append(character);
            }
            character = iterator.next();
        }
        return outTxt.toString();
    }

    private static String escapeHTML(String inTxt) {
        if (inTxt == null || inTxt.length() == 0) {
            return inTxt;
        }
        StringBuilder outTxt = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(inTxt);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                outTxt.append("&lt;");
            } else if (character == '>') {
                outTxt.append("&gt;");
            } else if (character == '\"') {
                outTxt.append("&quot;");
            } else if (character == '\'') {
                outTxt.append("&#039;");
            } else if (character == '&') {
                outTxt.append("&amp;");
            } else if (character == ' ') {
                outTxt.append("&nbsp;");
            } else {
                outTxt.append(character);
            }
            character = iterator.next();
        }
        return outTxt.toString();
    }
}

