/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.remoting.VirtualChannel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckOutAPITask
implements FilePath.FileCallable<Boolean> {
    boolean bFreshBuild = false;
    boolean isDelete = false;
    boolean isRevert = false;
    boolean isForce = false;
    FilePath workspace = null;
    TaskListener listener = null;
    VariableResolver<String> myResolver;
    String userName = "";
    String passwd = "";
    String database = "";
    String server = "";
    String permissions = "";
    String workarea = "";
    String projectId = "";
    String[] folders;
    private static final long serialVersionUID = 1L;

    public CheckOutAPITask(AbstractBuild<?, ?> build, DimensionsSCM parent, FilePath workspace, TaskListener listener) {
        Logger.Debug("Creating task - " + this.getClass().getName());
        this.workspace = workspace;
        this.listener = listener;
        this.userName = parent.getJobUserName();
        this.passwd = parent.getJobPasswd();
        this.database = parent.getJobDatabase();
        this.server = parent.getJobServer();
        this.workarea = parent.getWorkarea();
        this.isDelete = parent.isCanJobDelete();
        this.projectId = parent.getProject();
        this.isRevert = parent.isCanJobRevert();
        this.isForce = parent.isCanJobForce();
        this.folders = parent.getFolders();
        this.permissions = parent.getPermissions();
        this.bFreshBuild = build.getPreviousBuild() == null;
        this.myResolver = build.getBuildVariableResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File area, VirtualChannel channel) throws IOException {
        this.listener.getLogger().println("[DIMENSIONS] Running build in '" + area.getAbsolutePath() + "'...");
        boolean bRet = true;
        long key = -1L;
        DimensionsAPI dmSCM = new DimensionsAPI();
        try {
            dmSCM.setLogger(this.listener.getLogger());
            key = dmSCM.login(this.userName, this.passwd, this.database, this.server);
            if (key > 0L) {
                Logger.Debug("Login worked.");
                StringBuffer cmdOutput = new StringBuffer();
                FilePath wa = null;
                if (this.workarea != null) {
                    File waN = new File(this.workarea);
                    wa = new FilePath(waN);
                } else {
                    wa = new FilePath(area);
                }
                if (this.bFreshBuild && this.listener.getLogger() != null) {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out a fresh workspace because this project has not been built before...");
                    this.listener.getLogger().flush();
                }
                if (wa.exists() && (this.isDelete || this.bFreshBuild)) {
                    Logger.Debug("Deleting '" + wa.toURI() + "'...");
                    this.listener.getLogger().println("[DIMENSIONS] Removing '" + wa.toURI() + "'...");
                    this.listener.getLogger().flush();
                    wa.deleteContents();
                }
                String baseline = (String)this.myResolver.resolve("DM_BASELINE");
                String requests = (String)this.myResolver.resolve("DM_REQUEST");
                if (baseline != null) {
                    baseline = baseline.trim();
                    baseline = baseline.toUpperCase();
                }
                if (requests != null) {
                    requests = requests.replaceAll(" ", "");
                    requests = requests.toUpperCase();
                }
                Logger.Debug("Extra parameters - " + baseline + " " + requests);
                String cmdLog = null;
                if (baseline != null && baseline.length() == 0) {
                    baseline = null;
                }
                if (requests != null && requests.length() == 0) {
                    requests = null;
                }
                if (this.listener.getLogger() != null) {
                    if (requests != null) {
                        this.listener.getLogger().println("[DIMENSIONS] Checking out request(s) \"" + requests + "\" - ignoring project folders...");
                    } else if (baseline != null) {
                        this.listener.getLogger().println("[DIMENSIONS] Checking out baseline \"" + baseline + "\"...");
                    } else {
                        this.listener.getLogger().println("[DIMENSIONS] Checking out project \"" + this.projectId + "\"...");
                    }
                    this.listener.getLogger().flush();
                }
                for (int ii = 0; ii < this.folders.length && bRet; ++ii) {
                    String folderN = this.folders[ii];
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    Logger.Debug("Checking out '" + folderN + "'...");
                    bRet = dmSCM.checkout(key, this.projectId, dname, wa, cmdOutput, baseline, requests, this.isRevert, this.permissions);
                    Logger.Debug("SCM checkout returned " + bRet);
                    if (!bRet && this.isForce) {
                        bRet = true;
                    }
                    if (cmdLog == null) {
                        cmdLog = "\n";
                    }
                    cmdLog = cmdLog + cmdOutput;
                    cmdOutput.setLength(0);
                    cmdLog = cmdLog + "\n";
                }
                if (cmdLog.length() > 0 && this.listener.getLogger() != null) {
                    Logger.Debug("Found command output to log to the build logger");
                    this.listener.getLogger().println("[DIMENSIONS] (Note: Dimensions command output was - ");
                    cmdLog = cmdLog.replaceAll("\n\n", "\n");
                    this.listener.getLogger().println(cmdLog.replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                    this.listener.getLogger().flush();
                }
                if (!bRet) {
                    this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                    this.listener.getLogger().println("[DIMENSIONS] The Dimensions checkout command returned a failure status.");
                    this.listener.getLogger().println("[DIMENSIONS] Please review the command output and correct any issues");
                    this.listener.getLogger().println("[DIMENSIONS] that may have been detected.");
                    this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                    this.listener.getLogger().flush();
                }
            }
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run checkout callout - " + errMsg);
            bRet = false;
        }
        finally {
            dmSCM.logout(key);
        }
        return bRet;
    }
}

