/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.plugins.dimensionsscm.FileScanner;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScanner
implements Serializable {
    private File[] arr = null;
    private Collection<File> xfiles = null;
    private File baseDir = null;
    private ScannerFilter filter = null;

    public FileScanner(File dirName, String[] patterns, int depth) {
        this.baseDir = dirName;
        this.filter = new ScannerFilter(this, patterns);
        this.xfiles = this.scanFiles(dirName, (FilenameFilter)this.filter, depth);
    }

    public Collection<File> getFiles() {
        return this.xfiles;
    }

    public File[] toArray() {
        this.arr = new File[this.xfiles.size()];
        return this.xfiles.toArray(this.arr);
    }

    private Collection<File> scanFiles(File dirName, FilenameFilter filter, int depth) {
        if (dirName.isDirectory()) {
            // empty if block
        }
        Vector<File> files = new Vector<File>();
        File[] entFiles = dirName.listFiles();
        if (!(dirName.isDirectory() && dirName.getName().equals(".metadata") || entFiles == null)) {
            for (File afile : entFiles) {
                String dname = afile.getAbsolutePath();
                if (afile.getName().equals(".metadata")) continue;
                dname = dname.substring(this.baseDir.getAbsolutePath().length() + 1, afile.getAbsolutePath().length());
                if (filter == null || filter.accept(dirName, dname)) {
                    files.add(afile);
                }
                if (depth > -1 && (depth <= 0 || !afile.isDirectory())) continue;
                files.addAll(this.scanFiles(afile, filter, --depth));
                ++depth;
            }
        }
        return files;
    }
}

