/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.FileScanner;
import hudson.plugins.dimensionsscm.FileUtils;
import hudson.plugins.dimensionsscm.GenericCmdTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckInCmdTask
extends GenericCmdTask
implements FilePath.FileCallable<Boolean> {
    private boolean forceCheckIn = false;
    private boolean forceTip = false;
    private boolean isStream = false;
    int buildNo = 0;
    private String jobId = "";
    private String workarea = "";
    private String projectId = "";
    private String requests = null;
    private String owningPart = null;
    private String[] patterns;

    private File createCmdFile(File area, File tempFile) throws IOException {
        Calendar nowDateCal = Calendar.getInstance();
        File logFile = new File("a");
        FileWriter logFileWriter = null;
        PrintWriter fmtWriter = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
            logFileWriter = new FileWriter(tmpFile);
            fmtWriter = new PrintWriter((Writer)logFileWriter, true);
            String ciCmd = "DELIVER /BRIEF /ADD /UPDATE /DELETE ";
            if (this.version == 10 || !this.isStream) {
                ciCmd = "UPLOAD ";
            }
            ciCmd = ciCmd + " /USER_FILELIST=\"" + tempFile.getAbsolutePath() + "\"";
            ciCmd = ciCmd + " /WORKSET=\"" + this.projectId + "\"";
            ciCmd = ciCmd + " /COMMENT=\"Build artifacts saved by Hudson for job '" + this.jobId + "' - build " + this.buildNo + "\"";
            ciCmd = ciCmd + " /USER_DIRECTORY=\"" + area.getAbsolutePath() + "\"";
            if (this.requests != null && this.requests.length() > 0) {
                ciCmd = this.requests.indexOf(",") == 0 ? ciCmd + "/CHANGE_DOC_IDS=(\"" + this.requests + "\") " : ciCmd + "/CHANGE_DOC_IDS=(" + this.requests + ") ";
            }
            if (this.owningPart != null && this.owningPart.length() > 0) {
                ciCmd = ciCmd + "/PART=\"" + this.owningPart + "\"";
            }
            if (!this.isStream) {
                if (this.forceCheckIn) {
                    ciCmd = ciCmd + "/FORCE_CHECKIN ";
                }
                if (this.forceTip) {
                    ciCmd = ciCmd + "/FORCE_TIP ";
                }
            }
            fmtWriter.println(ciCmd);
            fmtWriter.flush();
        }
        catch (Exception e) {
            throw new IOException("Unable to write command log - " + e.getMessage());
        }
        finally {
            fmtWriter.close();
        }
        return tmpFile;
    }

    public CheckInCmdTask(String userName, String passwd, String database, String server, String projectId, String requestId, boolean forceCheckIn, boolean forceTip, String[] patterns, int version, boolean isStream, int buildNo, String jobId, String owningPart, FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.isStream = isStream;
        this.userName = userName;
        this.passwd = passwd;
        this.database = database;
        this.server = server;
        this.version = version;
        this.projectId = projectId;
        this.forceCheckIn = forceCheckIn;
        this.forceTip = forceTip;
        this.patterns = patterns;
        this.requests = requestId;
        this.buildNo = buildNo;
        this.jobId = jobId;
        this.owningPart = owningPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(File exe, File param, File area) throws IOException {
        FilePath wa = new FilePath(area);
        boolean bRet = true;
        Launcher.LocalLauncher proc = new Launcher.LocalLauncher(this.listener);
        try {
            this.listener.getLogger().println("[DIMENSIONS] Scanning workspace for files to be saved into Dimensions...");
            this.listener.getLogger().flush();
            FilePath wd = new FilePath(area);
            File dir = new File(wd.getRemote());
            FileScanner fs = new FileScanner(dir, this.patterns, -1);
            File[] validFiles = fs.toArray();
            String cmdLog = null;
            if (fs.getFiles().size() > 0) {
                if (this.requests != null) {
                    this.requests = this.requests.replaceAll(" ", "");
                    this.requests = this.requests.toUpperCase();
                }
                File tempFile = null;
                PrintWriter fmtWriter = null;
                try {
                    File logFile = new File("a");
                    FileWriter logFileWriter = null;
                    Calendar nowDateCal = Calendar.getInstance();
                    tempFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                    logFileWriter = new FileWriter(tempFile);
                    fmtWriter = new PrintWriter((Writer)logFileWriter, true);
                    for (File f : validFiles) {
                        fmtWriter.println(f.getAbsolutePath());
                    }
                    fmtWriter.flush();
                }
                catch (Exception e) {
                    bRet = false;
                    throw new IOException("Unable to write command log - " + e.getMessage());
                }
                finally {
                    fmtWriter.close();
                }
                File cmdFile = this.createCmdFile(area, tempFile);
                if (cmdFile == null) {
                    this.listener.getLogger().println("[DIMENSIONS] Error: Cannot create command file for Dimensions login.");
                    param.delete();
                    tempFile.delete();
                    return false;
                }
                this.listener.getLogger().println("[DIMENSIONS] Loading files into Dimensions project \"" + this.projectId + "\"...");
                this.listener.getLogger().flush();
                String[] cmd = new String[]{exe.getAbsolutePath(), "-param", param.getAbsolutePath(), "cmd", cmdFile.getAbsolutePath()};
                File tmpFile = null;
                try {
                    File logFile = new File("a");
                    Calendar nowDateCal = Calendar.getInstance();
                    tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    StreamBuildListener os = new StreamBuildListener((OutputStream)fos);
                    try {
                        Launcher.ProcStarter ps = proc.launch();
                        ps.cmds(cmd);
                        ps.stdout((OutputStream)os.getLogger());
                        ps.stdin(null);
                        ps.pwd(wa);
                        int cmdResult = ps.join();
                        cmdFile.delete();
                        if (cmdResult != 0) {
                            this.listener.fatalError("Execution of checkout failed with exit code " + cmdResult);
                            bRet = false;
                        }
                    }
                    finally {
                        os.getLogger().flush();
                        fos.close();
                        os = null;
                        fos = null;
                    }
                }
                finally {
                    tempFile.delete();
                }
                if (tmpFile != null) {
                    String outputStr = new String(FileUtils.loadFile(tmpFile));
                    tmpFile.delete();
                    tmpFile = null;
                    if (cmdLog == null) {
                        cmdLog = "\n";
                    }
                    cmdLog = cmdLog + outputStr;
                    cmdLog = cmdLog + "\n";
                }
            } else {
                this.listener.getLogger().println("[DIMENSIONS] No build artifacts found for checking in");
            }
            this.listener.getLogger().flush();
            param.delete();
            if (cmdLog != null && cmdLog.length() > 0 && this.listener.getLogger() != null) {
                this.listener.getLogger().println("[DIMENSIONS] (Note: Dimensions command output was - ");
                cmdLog = cmdLog.replaceAll("\n\n", "\n");
                this.listener.getLogger().println(cmdLog.replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                this.listener.getLogger().flush();
            }
            if (!bRet) {
                this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                this.listener.getLogger().println("[DIMENSIONS] The Dimensions checkin command returned a failure status.");
                this.listener.getLogger().println("[DIMENSIONS] Please review the command output and correct any issues");
                this.listener.getLogger().println("[DIMENSIONS] that may have been detected.");
                this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                this.listener.getLogger().flush();
            }
            return bRet;
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run checkout callout - " + errMsg);
            bRet = false;
            return bRet;
        }
    }
}

