/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.FileUtils;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericCmdTask
implements FilePath.FileCallable<Boolean> {
    protected FilePath workspace = null;
    protected TaskListener listener = null;
    protected FileUtils fu;
    protected String userName = "";
    protected String passwd = "";
    protected String database = "";
    protected String server = "";
    protected int version = 2009;
    private String exec = "dmcli";
    protected static final long serialVersionUID = 1L;

    protected static File getExecutable(String exeName) {
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("path");
        }
        if (path == null) {
            return null;
        }
        String[] pathDirs = path.split(File.pathSeparator);
        File exe = null;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, exeName);
            if (!file.isFile()) continue;
            exe = file;
            break;
        }
        return exe;
    }

    protected File createParamFile() throws IOException {
        Calendar nowDateCal = Calendar.getInstance();
        File logFile = new File("a");
        FileWriter logFileWriter = null;
        PrintWriter fmtWriter = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
            logFileWriter = new FileWriter(tmpFile);
            fmtWriter = new PrintWriter((Writer)logFileWriter, true);
            fmtWriter.println("-host " + this.server);
            fmtWriter.println("-user " + this.userName);
            fmtWriter.println("-pass " + this.passwd);
            fmtWriter.println("-dbname " + this.database);
            fmtWriter.flush();
        }
        catch (Exception e) {
            throw new IOException("Unable to write command log - " + e.getMessage());
        }
        finally {
            fmtWriter.close();
        }
        return tmpFile;
    }

    public GenericCmdTask() {
    }

    public GenericCmdTask(String userName, String passwd, String database, String server, int version, FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.userName = userName;
        this.passwd = passwd;
        this.database = database;
        this.server = server;
        this.version = version;
    }

    public Boolean invoke(File area, VirtualChannel channel) throws IOException {
        boolean retStatus = false;
        try {
            File exe;
            this.listener.getLogger().println("[DIMENSIONS] Running build in '" + area.getAbsolutePath() + "'...");
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                this.exec = this.exec + ".exe";
            }
            if ((exe = GenericCmdTask.getExecutable(this.exec)) == null) {
                this.listener.getLogger().println("[DIMENSIONS] Error: Cannot locate '" + this.exec + "' on the slave node.");
            } else {
                this.listener.getLogger().println("[DIMENSIONS] Located '" + exe.getAbsolutePath() + "' on the slave node.");
                File param = this.createParamFile();
                if (param == null) {
                    this.listener.getLogger().println("[DIMENSIONS] Error: Cannot create parameter file for Dimensions login.");
                    return false;
                }
                retStatus = this.execute(exe, param, area);
                param.delete();
            }
            return retStatus;
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run command callout - " + errMsg);
            return false;
        }
    }

    public Boolean execute(File exe, File param, File area) throws IOException {
        return true;
    }
}

