/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.plugins.dimensionsscm.ArtifactUploader;
import hudson.plugins.dimensionsscm.DimensionsBuildNotifier;
import hudson.plugins.dimensionsscm.DimensionsBuildWrapper;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import java.io.Serializable;

public class DimensionsChecker
implements Serializable {
    public static boolean isValidPluginCombination(AbstractBuild build, BuildListener listener) {
        if (build.getProject() instanceof Project) {
            Project buildProject = (Project)build.getProject();
            if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                Logger.Debug((String)"Not using a DimensionsSCM engine - bye");
                return false;
            }
            DimensionsBuildWrapper bwplugin = (DimensionsBuildWrapper)buildProject.getBuildWrappers().get(DimensionsBuildWrapper.DMWBLD_DESCRIPTOR);
            DimensionsBuildNotifier bnplugin = (DimensionsBuildNotifier)build.getProject().getPublishersList().get(DimensionsBuildNotifier.class);
            ArtifactUploader anplugin = (ArtifactUploader)build.getProject().getPublishersList().get(ArtifactUploader.class);
            if (bwplugin != null) {
                Logger.Debug((String)"DimensionsBuildWrapper is activated");
            }
            if (bnplugin != null) {
                Logger.Debug((String)"DimensionsBuildNotifier is activated");
            }
            if (anplugin != null) {
                Logger.Debug((String)"ArtifactUploader is activated");
            }
            if (bnplugin != null && bwplugin == null) {
                listener.fatalError("\n[DIMENSIONS] Tags can only be created when the 'Lock Dimensions project while the build is in progress' option is enabled.");
                return false;
            }
        }
        return true;
    }
}

