/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.ArtifactUploader;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.FileScanner;
import hudson.plugins.dimensionsscm.GenericAPITask;
import hudson.plugins.dimensionsscm.Logger;
import hudson.remoting.VirtualChannel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckInAPITask
extends GenericAPITask
implements FilePath.FileCallable<Boolean> {
    private boolean isForceTip = false;
    private boolean isForceCheckIn = false;
    private VariableResolver<String> myResolver;
    int version = 2009;
    int buildNo = 0;
    private String jobId = "";
    private String workarea = "";
    private String projectId = "";
    private String owningPart = "";
    private String[] patterns;

    public CheckInAPITask(AbstractBuild<?, ?> build, DimensionsSCM parent, int buildNo, String jobId, int version, ArtifactUploader artifact, FilePath workspace, TaskListener listener) {
        Logger.Debug("Creating task - " + this.getClass().getName());
        this.workspace = workspace;
        this.listener = listener;
        this.userName = parent.getJobUserName();
        this.passwd = parent.getJobPasswd();
        this.database = parent.getJobDatabase();
        this.server = parent.getJobServer();
        this.version = version;
        this.workarea = parent.getWorkarea();
        this.projectId = parent.getProject();
        this.isForceCheckIn = artifact.isForceCheckIn();
        this.isForceTip = artifact.isForceTip();
        this.owningPart = artifact.getOwningPart();
        this.patterns = artifact.getPatterns();
        this.myResolver = build.getBuildVariableResolver();
        this.buildNo = buildNo;
        this.jobId = jobId;
    }

    @Override
    public Boolean execute(File area, VirtualChannel channel) throws IOException {
        boolean bRet = true;
        try {
            this.listener.getLogger().println("[DIMENSIONS] Scanning workspace for files to be saved into Dimensions...");
            this.listener.getLogger().flush();
            FilePath wd = new FilePath(area);
            Logger.Debug("Scanning directory for files that match patterns '" + wd.getRemote() + "'");
            File dir = new File(wd.getRemote());
            FileScanner fs = new FileScanner(dir, this.patterns, -1);
            File[] validFiles = fs.toArray();
            if (fs.getFiles().size() > 0) {
                DimensionsResult res;
                this.listener.getLogger().println("[DIMENSIONS] Loading files into Dimensions project \"" + this.projectId + "\"...");
                this.listener.getLogger().flush();
                Calendar nowDateCal = Calendar.getInstance();
                File logFile = new File("a");
                FileWriter logFileWriter = null;
                PrintWriter fmtWriter = null;
                File tmpFile = null;
                try {
                    tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
                    logFileWriter = new FileWriter(tmpFile);
                    fmtWriter = new PrintWriter((Writer)logFileWriter, true);
                    for (File f : validFiles) {
                        Logger.Debug("Found file '" + f.getAbsolutePath() + "'");
                        fmtWriter.println(f.getAbsolutePath());
                    }
                    fmtWriter.flush();
                }
                catch (Exception e) {
                    bRet = false;
                    throw new IOException("Unable to write command log - " + e.getMessage());
                }
                finally {
                    fmtWriter.close();
                }
                String requests = (String)this.myResolver.resolve("DM_TARGET_REQUEST");
                if (requests != null) {
                    requests = requests.replaceAll(" ", "");
                    requests = requests.toUpperCase();
                }
                if ((res = this.dmSCM.UploadFiles(this.key, wd, this.projectId, tmpFile, this.jobId, this.buildNo, requests, this.isForceCheckIn, this.isForceTip, this.owningPart)) == null) {
                    this.listener.getLogger().println("[DIMENSIONS] New artifacts failed to get loaded into Dimensions");
                    this.listener.getLogger().flush();
                    bRet = false;
                } else {
                    this.listener.getLogger().println("[DIMENSIONS] Build artifacts were successfully loaded into Dimensions");
                    this.listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                    this.listener.getLogger().flush();
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                } else {
                    this.listener.getLogger().println("[DIMENSIONS] No build artifacts were detected");
                    this.listener.getLogger().flush();
                }
            } else {
                this.listener.getLogger().println("[DIMENSIONS] No build artifacts found for checking in");
            }
            this.listener.getLogger().flush();
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run checkin callout - " + errMsg);
            bRet = false;
        }
        return bRet;
    }
}

