/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.Baseline;
import com.serena.dmclient.api.BulkOperator;
import com.serena.dmclient.api.DimensionsConnection;
import com.serena.dmclient.api.DimensionsConnectionDetails;
import com.serena.dmclient.api.DimensionsConnectionManager;
import com.serena.dmclient.api.DimensionsNetworkException;
import com.serena.dmclient.api.DimensionsObjectFactory;
import com.serena.dmclient.api.DimensionsRelatedObject;
import com.serena.dmclient.api.DimensionsResult;
import com.serena.dmclient.api.DimensionsRuntimeException;
import com.serena.dmclient.api.Filter;
import com.serena.dmclient.api.ItemRevision;
import com.serena.dmclient.api.Project;
import com.serena.dmclient.api.Request;
import com.serena.dmclient.api.SystemRelationship;
import com.serena.dmclient.objects.DimensionsObject;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.plugins.dimensionsscm.DateUtils;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsChangeLogWriter;
import hudson.plugins.dimensionsscm.DimensionsChangeSet;
import hudson.plugins.dimensionsscm.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

/*
 * Exception performing whole class analysis ignored.
 */
public class DimensionsAPI
implements Serializable {
    private static final String MISSING_SOURCE_PATH = "The nested element needs a valid 'srcpath' attribute";
    private static final String MISSING_PROJECT = "The nested element needs a valid project to work on";
    private static final String MISSING_BASELINE = "The nested element needs a valid baseline to work on";
    private static final String MISSING_REQUEST = "The nested element needs a valid request to work on";
    private static final String BAD_BASE_DATABASE_SPEC = "The <dimensions> task needs a valid 'database' attribute, in the format 'dbname@dbconn'";
    private static final String NO_COMMAND_LINE = "The <run> nested element need a valid 'cmd' attribute";
    private static final String SRCITEM_SRCPATH_CONFLICT = "The <getcopy> nested element needs exactly one of the 'srcpath' or 'srcitem' attributes";
    private String dmServer;
    private String dmDb;
    private String dbName;
    private String dbConn;
    private String dmUser;
    private String dmPasswd;
    private String dmProject;
    private String dmDirectory;
    private String dmRequest;
    private String projectPath;
    private String dateType = "edit";
    private boolean allRevisions = false;
    private int version = -1;
    private HashMap conns = new HashMap();
    private PrintStream listener;

    public final PrintStream getLogger() {
        return this.listener;
    }

    public final void setLogger(PrintStream logger) {
        this.listener = logger;
    }

    public final String getSCMUserID() {
        return this.dmUser;
    }

    public final int getDmVersion() {
        if (this.version > 0) {
            return this.version;
        }
        return 0;
    }

    public final String getSCMDatabase() {
        return this.dmDb;
    }

    public final String getSCMBaseDb() {
        return this.dbName;
    }

    public final String getSCMDsn() {
        return this.dbConn;
    }

    public final String getSCMServer() {
        return this.dmServer;
    }

    public final String getSCMProject() {
        return this.dmProject;
    }

    public final String getSCMPath() {
        return this.projectPath;
    }

    public final DimensionsConnection getCon(long key) {
        Logger.Debug((String)("Looking for key " + key));
        if (this.conns == null) {
            return null;
        }
        if (this.conns.containsKey(key)) {
            ConnectionCache cc = (ConnectionCache)this.conns.get(key);
            DimensionsConnection con = cc.getCon();
            try {
                DimensionsConnectionManager.unregisterThreadConnection();
            }
            catch (Exception e) {
                // empty catch block
            }
            DimensionsConnectionManager.registerThreadConnection((DimensionsConnection)con);
            Logger.Debug((String)"Found database");
            return con;
        }
        Logger.Debug((String)"Could not find database");
        return null;
    }

    public final boolean ping(long key) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection != null) {
            try {
                return connection.getConnectionState(false) == 1;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public final long login(String userID, String password, String database, String server) throws IllegalArgumentException, DimensionsRuntimeException {
        DimensionsConnection connection = null;
        long key = Calendar.getInstance().getTimeInMillis();
        if (this.conns == null) {
            this.conns = new HashMap();
        }
        this.dmServer = server;
        this.dmDb = database;
        this.dmUser = userID;
        this.dmPasswd = password;
        Logger.Debug((String)"Checking Dimensions login parameters...");
        if (this.dmServer == null || this.dmServer.length() == 0 || this.dmDb == null || this.dmDb.length() == 0 || this.dmUser == null || this.dmUser.length() == 0 || this.dmPasswd == null || this.dmPasswd.length() == 0) {
            throw new IllegalArgumentException("Invalid or not parameters have been specified");
        }
        try {
            String[] dbCompts = DimensionsAPI.parseDatabaseString((String)this.dmDb);
            this.dbName = dbCompts[0];
            this.dbConn = dbCompts[1];
            Logger.Debug((String)("Logging into Dimensions: " + this.dmUser + " " + this.dmServer + " " + this.dmDb));
            DimensionsConnectionDetails details = new DimensionsConnectionDetails();
            details.setUsername(this.dmUser);
            details.setPassword(this.dmPasswd);
            details.setDbName(this.dbName);
            details.setDbConn(this.dbConn);
            details.setServer(this.dmServer);
            Logger.Debug((String)"Getting Dimensions connection...");
            connection = DimensionsConnectionManager.getConnection((DimensionsConnectionDetails)details);
            if (connection != null) {
                Logger.Debug((String)("Storing details for key " + key + "..."));
                this.conns.put(key, new ConnectionCache(this, connection));
                if (this.version < 0) {
                    this.version = 2009;
                    List inf = connection.getObjectFactory().getServerVersion(2);
                    if (inf == null) {
                        Logger.Debug((String)"Detection of server information failed");
                    }
                    if (inf != null) {
                        Logger.Debug((String)("Server information detected -" + inf.size()));
                        for (int i = 0; i < inf.size(); ++i) {
                            String prop = (String)inf.get(i);
                            Logger.Debug((String)(i + " - " + prop));
                        }
                        String serverx = (String)inf.get(2);
                        if (serverx == null) {
                            serverx = (String)inf.get(0);
                        }
                        if (serverx != null) {
                            Logger.Debug((String)("Detected server version: " + serverx));
                            String[] tokens = serverx.split(" ");
                            serverx = tokens[0];
                            this.version = serverx.startsWith("10.") ? 10 : (serverx.startsWith("2009") ? 2009 : (serverx.startsWith("201") ? 2010 : 2009));
                            Logger.Debug((String)("Version to process set to " + this.version));
                        } else {
                            Logger.Debug((String)"No server information found");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException("Login to Dimensions failed - " + e.getMessage());
        }
        if (this.conns.containsKey(key)) {
            return key;
        }
        return -1L;
    }

    public final void logout(long key) {
        if (this.conns == null) {
            return;
        }
        DimensionsConnection connection = this.getCon(key);
        if (connection != null) {
            try {
                Logger.Debug((String)"Closing connection to Dimensions...");
                connection.close();
            }
            catch (DimensionsNetworkException dne) {
            }
            catch (DimensionsRuntimeException dne) {
                // empty catch block
            }
            this.conns.remove(key);
            Logger.Debug((String)("Now have " + this.conns.size() + " connections in use..."));
        }
    }

    private static String[] parseDatabaseString(String database) throws ParseException {
        String[] dbCompts;
        int endName = database.indexOf(47);
        int startConn = database.indexOf(64);
        if (startConn < 1 || startConn == database.length() - 1) {
            throw new ParseException("The <dimensions> task needs a valid 'database' attribute, in the format 'dbname@dbconn'", startConn);
        }
        String dbName = null;
        String dbConn = null;
        String dbPassword = null;
        if (endName < 0 || startConn <= endName) {
            dbName = database.substring(0, startConn);
            dbConn = database.substring(startConn + 1);
            dbCompts = new String[]{dbName, dbConn};
        } else {
            if (endName == 0 || startConn == endName + 1) {
                throw new ParseException("The <dimensions> task needs a valid 'database' attribute, in the format 'dbname@dbconn'", endName);
            }
            dbName = database.substring(0, endName);
            dbPassword = database.substring(endName + 1, startConn);
            dbConn = database.substring(startConn + 1);
            dbCompts = new String[]{dbName, dbConn, dbPassword};
        }
        return dbCompts;
    }

    public boolean hasRepositoryBeenUpdated(long key, String projectName, FilePath workspace, Calendar fromDate, Calendar toDate, TimeZone tz) throws IOException, InterruptedException {
        boolean bChanged = false;
        DimensionsConnection connection = this.getCon(key);
        if (fromDate == null) {
            return true;
        }
        if (connection == null) {
            throw new IOException("Not connected to an SCM repository");
        }
        try {
            List items = this.calcRepositoryDiffs(key, projectName, null, null, workspace, fromDate, toDate, tz);
            if (items != null) {
                bChanged = items.size() > 0;
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to run hasRepositoryBeenUpdated - " + e.getMessage());
        }
        return bChanged;
    }

    public boolean checkout(long key, String projectName, FilePath projectDir, FilePath workspaceName, StringBuffer cmdOutput, String baseline, String requests, boolean doRevert, boolean doExpand, String permissions) throws IOException, InterruptedException {
        boolean bRet = false;
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new IOException("Not connected to an SCM repository");
        }
        try {
            DimensionsResult res;
            String projDir;
            String coCmd = "UPDATE /BRIEF ";
            if (this.version == 10) {
                coCmd = "DOWNLOAD ";
                if (requests != null) {
                    coCmd = "FCDI ";
                }
            }
            String cmd = coCmd;
            String string = projDir = projectDir != null ? projectDir.getRemote() : null;
            if (requests != null && this.version == 10) {
                cmd = cmd + requests;
            }
            if (projDir != null && !projDir.equals("\\") && !projDir.equals("/") && requests == null) {
                cmd = cmd + "/DIR=\"" + projDir + "\"";
            }
            if (requests != null && this.version != 10) {
                cmd = requests.indexOf(",") == 0 ? cmd + "/CHANGE_DOC_IDS=(\"" + requests + "\") " : cmd + "/CHANGE_DOC_IDS=(" + requests + ") ";
                cmd = cmd + "/WORKSET=\"" + projectName + "\" ";
            } else {
                cmd = baseline != null ? cmd + "/BASELINE=\"" + baseline + "\"" : cmd + "/WORKSET=\"" + projectName + "\" ";
            }
            if (permissions != null && permissions.length() > 0 && !permissions.equals("DEFAULT")) {
                cmd = cmd + "/PERMS=" + permissions;
            }
            cmd = cmd + "/USER_DIR=\"" + workspaceName.getRemote() + "\" ";
            if (doRevert) {
                cmd = cmd + " /OVERWRITE";
            }
            if (doExpand) {
                cmd = cmd + " /EXPAND";
            }
            if (requests == null) {
                this.getLogger().println("[DIMENSIONS] Checking out directory '" + (projDir != null ? projDir : "/") + "'...");
                this.getLogger().flush();
            }
            if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)cmd)) != null) {
                cmdOutput = cmdOutput.append(res.getMessage());
                String outputStr = new String(cmdOutput.toString());
                Logger.Debug((String)outputStr);
                bRet = true;
                int confl = outputStr.indexOf("C\t");
                if (confl > 0) {
                    bRet = false;
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return bRet;
    }

    public boolean createChangeSetLogs(long key, String projectName, FilePath projectDir, Calendar fromDate, Calendar toDate, File changelogFile, TimeZone tz, String url, String baseline, String requests) throws IOException, InterruptedException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new IOException("Not connected to an SCM repository");
        }
        try {
            List items = this.calcRepositoryDiffs(key, projectName, baseline, requests, projectDir, fromDate, toDate, tz);
            File logFile = new File("a");
            Object logFileWriter = null;
            Object fmtWriter = null;
            File tmpFile = null;
            Logger.Debug((String)("CM Url : " + (url != null ? url : "(null)")));
            if (requests != null) {
                this.getLogger().println("[DIMENSIONS] Calculating change set for request(s) '" + requests + "'...");
            } else {
                this.getLogger().println("[DIMENSIONS] Calculating change set for directory '" + (projectDir != null ? projectDir.getRemote() : "/") + "'...");
            }
            this.getLogger().flush();
            if (items != null) {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                List changes = this.createChangeList(items, tz, url);
                Logger.Debug((String)("Writing changeset to " + changelogFile.getPath()));
                DimensionsChangeLogWriter write = new DimensionsChangeLogWriter();
                write.writeLog(changes, changelogFile);
            } else {
                DimensionsChangeLogWriter write = new DimensionsChangeLogWriter();
                write.writeLog(null, changelogFile);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    private List calcRepositoryDiffs(long key, String projectName, String baselineName, String requests, FilePath workspace, Calendar fromDate, Calendar toDate, TimeZone tz) throws IOException, InterruptedException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new IOException("Not connected to an SCM repository");
        }
        if (fromDate == null && baselineName == null && requests == null) {
            return null;
        }
        try {
            int[] attrs = DimensionsAPI.getItemFileAttributes((boolean)true);
            String dateAfter = fromDate != null ? DimensionsAPI.formatDatabaseDate((Date)fromDate.getTime(), (TimeZone)tz) : "01-JAN-1970 00:00:00";
            String dateBefore = toDate != null ? DimensionsAPI.formatDatabaseDate((Date)toDate.getTime(), (TimeZone)tz) : DimensionsAPI.formatDatabaseDate((Date)Calendar.getInstance().getTime(), (TimeZone)tz);
            Filter filter = new Filter();
            filter.criteria().add(new Filter.Criterion(-1301, (Object)dateAfter, 80));
            filter.criteria().add(new Filter.Criterion(-1301, (Object)dateBefore, 96));
            filter.criteria().add(new Filter.Criterion(-1201, (Object)dateAfter, 80));
            filter.criteria().add(new Filter.Criterion(-1201, (Object)dateBefore, 96));
            filter.criteria().add(new Filter.Criterion(-1805, (Object)"Y", 64));
            filter.orders().add(new Filter.Order(-1807, 1));
            filter.orders().add(new Filter.Order(-1802, 1));
            filter.orders().add(new Filter.Order(-1801, 1));
            Logger.Debug((String)("Looking between " + dateAfter + " -> " + dateBefore));
            String projName = baselineName != null && requests == null ? baselineName.toUpperCase() : projectName.toUpperCase();
            List items = null;
            if (requests != null) {
                try {
                    items = this.getItemsInRequests(connection, projName, requests, dateAfter, dateBefore);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            } else if (baselineName != null) {
                Filter baselineFilter = new Filter();
                baselineFilter.criteria().add(new Filter.Criterion(-1102, (Object)baselineName.toUpperCase(), 8));
                List baselineObjects = connection.getObjectFactory().getBaselines(baselineFilter);
                Logger.Debug((String)("Baseline query for \"" + baselineName + "\" returned " + baselineObjects.size() + " baselines"));
                for (int i = 0; i < baselineObjects.size(); ++i) {
                    Logger.Debug((String)("Baseline " + i + " is \"" + ((Baseline)baselineObjects.get(i)).getName() + "\""));
                }
                if (baselineObjects.size() == 0) {
                    throw new IOException("Could not find baseline \"" + baselineName + "\" in repository");
                }
                if (baselineObjects.size() > 1) {
                    throw new IOException("Found more than one baseline named \"" + baselineName + "\" in repository");
                }
                items = DimensionsAPI.queryItems((DimensionsConnection)connection, (Baseline)((Baseline)baselineObjects.get(0)), (String)workspace.getRemote(), (Filter)filter, (int[])attrs, (boolean)true, (!this.allRevisions ? 1 : 0) != 0);
            } else {
                Project projectObj = connection.getObjectFactory().getProject(projName);
                items = DimensionsAPI.queryItems((DimensionsConnection)connection, (Project)projectObj, (String)workspace.getRemote(), (Filter)filter, (int[])attrs, (boolean)true, (!this.allRevisions ? 1 : 0) != 0);
            }
            return items;
        }
        catch (Exception e) {
            throw new IOException("Unable to run calcRepositoryDiffs - " + (e != null ? e.getMessage() : "an unknown exception occurred."));
        }
    }

    public DimensionsResult lockProject(long key, String projectId) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            DimensionsResult res;
            String cmd = "LCK WORKSET ";
            if (projectId != null && (res = DimensionsAPI.run((DimensionsConnection)connection, (String)(cmd = cmd + "\"" + projectId + "\""))) != null) {
                Logger.Debug((String)("Locking project - " + res.getMessage()));
                return res;
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult unlockProject(long key, String projectId) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            DimensionsResult res;
            String cmd = "ULCK WORKSET ";
            if (projectId != null && (res = DimensionsAPI.run((DimensionsConnection)connection, (String)(cmd = cmd + "\"" + projectId + "\""))) != null) {
                Logger.Debug((String)("Unlocking project - " + res.getMessage()));
                return res;
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult buildBaseline(long key, String area, String projectId, boolean batch, boolean buildClean, String buildConfig, String options, boolean capture, String requests, String targets, AbstractBuild build) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            String cmd = "BLDB ";
            if (projectId != null && build != null) {
                DimensionsResult res;
                cmd = cmd + "\"" + projectId + "_" + build.getProject().getName() + "_" + build.getNumber() + "\"";
                if (area != null && area.length() > 0) {
                    cmd = cmd + " /AREA=\"" + area + "\"";
                }
                cmd = batch ? cmd + " /NOWAIT" : cmd + " /WAIT";
                cmd = capture ? cmd + " /CAPTURE" : cmd + " /NOCAPTURE";
                if (buildClean) {
                    cmd = cmd + " /BUILD_CLEAN";
                }
                if (buildConfig != null && buildConfig.length() > 0) {
                    cmd = cmd + " /BUILD_CONFIG=\"" + buildConfig + "\"";
                }
                if (options != null && options.length() > 0) {
                    cmd = options.indexOf(",") == 0 ? cmd + "/BUILD_OPTIONS=(\"" + options + "\") " : cmd + "/BUILD_OPTIONS=(" + options + ") ";
                }
                if (requests != null && requests.length() > 0) {
                    cmd = requests.indexOf(",") == 0 ? cmd + "/CHANGE_DOC_IDS=(\"" + requests + "\") " : cmd + "/CHANGE_DOC_IDS=(" + requests + ") ";
                }
                if (targets != null && targets.length() > 0) {
                    cmd = targets.indexOf(",") == 0 ? cmd + "/TARGETS=(\"" + targets + "\") " : cmd + "/TARGETS=(" + targets + ") ";
                }
                if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)cmd)) != null) {
                    Logger.Debug((String)("Building baseline - " + res.getMessage()));
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult buildProject(long key, String area, String projectId, boolean batch, boolean buildClean, String buildConfig, String options, boolean capture, String requests, String targets, String stage, String type, boolean audit, boolean populate, boolean touch, AbstractBuild build) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            String cmd = "BLD ";
            if (projectId != null && build != null) {
                DimensionsResult res;
                cmd = cmd + "\"" + projectId + "\"";
                if (area != null && area.length() > 0) {
                    cmd = cmd + " /AREA=\"" + area + "\"";
                }
                if (type != null && type.length() > 0) {
                    cmd = cmd + " /TYPE=\"" + type + "\"";
                }
                if (stage != null && stage.length() > 0) {
                    cmd = cmd + " /STAGE=\"" + stage + "\"";
                }
                cmd = touch ? cmd + " /TOUCH" : cmd + " /NOTOUCH";
                cmd = populate ? cmd + " /POPULATE" : cmd + " /NOPOPULATE";
                cmd = audit ? cmd + " /AUDIT" : cmd + " /NOAUDIT";
                cmd = batch ? cmd + " /NOWAIT" : cmd + " /WAIT";
                cmd = capture ? cmd + " /CAPTURE" : cmd + " /NOCAPTURE";
                if (buildClean) {
                    cmd = cmd + " /BUILD_CLEAN";
                }
                if (buildConfig != null && buildConfig.length() > 0) {
                    cmd = cmd + " /BUILD_CONFIG=\"" + buildConfig + "\"";
                }
                if (options != null && options.length() > 0) {
                    cmd = options.indexOf(",") == 0 ? cmd + "/BUILD_OPTIONS=(\"" + options + "\") " : cmd + "/BUILD_OPTIONS=(" + options + ") ";
                }
                if (requests != null && requests.length() > 0) {
                    cmd = requests.indexOf(",") == 0 ? cmd + "/CHANGE_DOC_IDS=(\"" + requests + "\") " : cmd + "/CHANGE_DOC_IDS=(" + requests + ") ";
                }
                if (targets != null && targets.length() > 0) {
                    cmd = targets.indexOf(",") == 0 ? cmd + "/TARGETS=(\"" + targets + "\") " : cmd + "/TARGETS=(" + targets + ") ";
                }
                if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)cmd)) != null) {
                    Logger.Debug((String)("Building project - " + res.getMessage()));
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult UploadFiles(long key, FilePath rootDir, String projectId, File cmdFile, String projectName, int buildNo, String requests, boolean forceCheckIn, boolean forceTip, String owningPart) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            boolean isStream = false;
            if (this.version != 10) {
                isStream = this.isStream(connection, projectId);
            }
            String ciCmd = "DELIVER /BRIEF /ADD /UPDATE /DELETE ";
            if (this.version == 10 || !isStream) {
                ciCmd = "UPLOAD ";
            }
            if (projectId != null) {
                DimensionsResult res;
                ciCmd = ciCmd + " /USER_FILELIST=\"" + cmdFile.getAbsolutePath() + "\"";
                ciCmd = ciCmd + " /WORKSET=\"" + projectId + "\"";
                ciCmd = ciCmd + " /COMMENT=\"Build artifacts saved by Hudson for job '" + projectName + "' - build " + buildNo + "\"";
                ciCmd = ciCmd + " /USER_DIRECTORY=\"" + rootDir.getRemote() + "\"";
                if (requests != null && requests.length() > 0) {
                    ciCmd = requests.indexOf(",") == 0 ? ciCmd + "/CHANGE_DOC_IDS=(\"" + requests + "\") " : ciCmd + "/CHANGE_DOC_IDS=(" + requests + ") ";
                }
                if (owningPart != null && owningPart.length() > 0) {
                    ciCmd = ciCmd + "/PART=\"" + owningPart + "\"";
                }
                if (!isStream) {
                    if (forceCheckIn) {
                        ciCmd = ciCmd + "/FORCE_CHECKIN ";
                    }
                    if (forceTip) {
                        ciCmd = ciCmd + "/FORCE_TIP ";
                    }
                }
                if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)ciCmd)) != null) {
                    Logger.Debug((String)("Saving artifacts - " + res.getMessage()));
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult createBaseline(long key, String projectId, AbstractBuild build, String blnScope, String blnTemplate, String blnOwningPart, String blnType) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            String cmd = "CBL ";
            if (projectId != null && build != null) {
                DimensionsResult res;
                boolean wsBln = true;
                cmd = cmd + "\"" + projectId + "_" + build.getProject().getName() + "_" + build.getNumber() + "\"";
                cmd = cmd + " /WORKSET=\"" + projectId + "\"";
                if (blnScope == null || blnScope.length() == 0) {
                    cmd = cmd + " /SCOPE=WORKSET ";
                } else {
                    wsBln = false;
                    cmd = cmd + " /SCOPE=" + blnScope;
                    if (blnScope.equals("WORKSET")) {
                        wsBln = true;
                    }
                }
                if (!wsBln) {
                    if (blnTemplate != null && blnTemplate.length() > 0) {
                        cmd = cmd + " /TEMPLATE_ID=\"" + blnTemplate + "\"";
                    }
                    if (blnOwningPart != null && blnOwningPart.length() > 0) {
                        cmd = cmd + " /PART=\"" + blnOwningPart + "\"";
                    }
                }
                if (blnType != null && blnType.length() > 0) {
                    cmd = cmd + " /TYPE=\"" + blnType + "\"";
                }
                if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)(cmd = cmd + " /DESCRIPTION=\"Baseline created by Hudson for job '" + build.getProject().getName() + "' - build " + build.getNumber() + "\""))) != null) {
                    Logger.Debug((String)("Tagging project - " + res.getMessage()));
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult deployBaseline(long key, String projectId, AbstractBuild build, String state) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            String cmd = "DPB ";
            if (projectId != null && build != null) {
                DimensionsResult res;
                cmd = cmd + "\"" + projectId + "_" + build.getProject().getName() + "_" + build.getNumber() + "\"";
                cmd = cmd + " /WORKSET=\"" + projectId + "\"";
                if (state != null && state.length() > 0) {
                    cmd = cmd + " /STAGE=\"" + state + "\"";
                }
                if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)(cmd = cmd + " /COMMENT=\"Project Baseline deployed by Hudson for job '" + build.getProject().getName() + "' - build " + build.getNumber() + "\""))) != null) {
                    Logger.Debug((String)("Deploying baseline - " + res.getMessage()));
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    public DimensionsResult actionBaseline(long key, String projectId, AbstractBuild build, String state) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        try {
            String cmd = "ABL ";
            if (projectId != null && build != null) {
                DimensionsResult res;
                cmd = cmd + "\"" + projectId + "_" + build.getProject().getName() + "_" + build.getNumber() + "\"";
                cmd = cmd + " /WORKSET=\"" + projectId + "\"";
                if (state != null && state.length() > 0) {
                    cmd = cmd + " /STATUS=\"" + state + "\"";
                }
                if ((res = DimensionsAPI.run((DimensionsConnection)connection, (String)(cmd = cmd + " /COMMENT=\"Project Baseline action by Hudson for job '" + build.getProject().getName() + "' - build " + build.getNumber() + "\""))) != null) {
                    Logger.Debug((String)("Actioning baseline - " + res.getMessage()));
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DimensionsRuntimeException(e.getMessage());
        }
    }

    private List createChangeList(List items, TimeZone tz, String url) throws DimensionsRuntimeException {
        items = DimensionsAPI.getSortedItemList((List)items);
        ArrayList<DimensionsChangeSet> changeSet = new ArrayList<DimensionsChangeSet>(items.size());
        String key = null;
        DimensionsChangeSet cs = null;
        for (int i = 0; i < items.size(); ++i) {
            String urlString;
            Logger.Debug((String)("Processing change set " + i + "/" + items.size()));
            ItemRevision item = (ItemRevision)items.get(i);
            int x = 0;
            if (item.getAttribute(-1806) == null) continue;
            Integer fileVersion = (Integer)item.getAttribute(-1809);
            if (fileVersion != null) {
                x = fileVersion;
            }
            Logger.Debug((String)("Creating a change set (" + x + ") " + i));
            String operation = x < 2 ? "add" : "edit";
            String spec = (String)item.getAttribute(-1102);
            String revision = (String)item.getAttribute(-1803);
            String fileName = (String)item.getAttribute(-1806) + ";" + revision;
            String author = (String)item.getAttribute(-1302);
            String comment = (String)item.getAttribute(-1807);
            String date = (String)item.getAttribute(DimensionsAPI.getDateTypeAttribute((String)operation));
            if (date == null) {
                date = (String)item.getAttribute(DimensionsAPI.getDateTypeAttribute((String)"edit"));
            }
            if ((urlString = DimensionsAPI.constructURL((String)spec, (String)url, (String)this.getSCMDsn(), (String)this.getSCMBaseDb())) == null) {
                urlString = "";
            }
            if (comment == null) {
                comment = "(None)";
            }
            Logger.Debug((String)("Change set details -" + comment + " " + revision + " " + fileName + " " + author + " " + spec + " " + date + " " + operation + " " + urlString));
            Calendar opDate = Calendar.getInstance();
            opDate.setTime(DateUtils.parse((String)date, (TimeZone)tz));
            if (key == null) {
                cs = new DimensionsChangeSet(fileName, author, operation, revision, comment, urlString, opDate);
                key = comment + author;
                changeSet.add(cs);
            } else {
                String key1 = comment + author;
                if (key.equals(key1)) {
                    cs.add(fileName, operation, urlString);
                } else {
                    cs = new DimensionsChangeSet(fileName, author, operation, revision, comment, urlString, opDate);
                    key = comment + author;
                    changeSet.add(cs);
                }
            }
            List itemRequests = item.getChildRequests(null);
            for (int j = 0; j < itemRequests.size(); ++j) {
                DimensionsRelatedObject obj = (DimensionsRelatedObject)itemRequests.get(j);
                DimensionsObject relType = obj.getRelationship();
                if (SystemRelationship.IN_RESPONSE.equals((Object)relType)) {
                    Request req = (Request)obj.getObject();
                    req.queryAttribute(new int[]{1, -1601, -1102});
                    String objectId = (String)req.getAttribute(-1102);
                    String requestUrl = DimensionsAPI.constructRequestURL((String)objectId, (String)url, (String)this.getSCMDsn(), (String)this.getSCMBaseDb());
                    String titlex = (String)req.getAttribute(1);
                    cs.addRequest(objectId, requestUrl, titlex);
                    Logger.Debug((String)("Child Request Details IRT -" + objectId + " " + requestUrl + " " + titlex));
                    continue;
                }
                Logger.Debug((String)"Child Request Details Ignored");
            }
        }
        return changeSet;
    }

    private static List getSortedItemList(List items) throws DimensionsRuntimeException {
        Collections.sort(items, new /* Unavailable Anonymous Inner Class!! */);
        return items;
    }

    private static void setCurrentProject(DimensionsConnection connection, String projectName) {
        connection.getObjectFactory().setCurrentProject(projectName, false, "", "", null, true);
    }

    private static Project getCurrentProject(DimensionsConnection connection) {
        return connection.getObjectFactory().getCurrentUser().getCurrentProject();
    }

    static int[] getItemFileAttributes(boolean isDirectory) {
        if (isDirectory) {
            int[] attrs = new int[]{-1102, -1606, -1101, -1808, -1607, -1803, -1806, -1801, -1302, -1809, -1807, -1301, -1201};
            return attrs;
        }
        int[] attrs = new int[]{-1606, -1101, -1808, -1607, -1803, -1801, -1302, -1809, -1301, -1201};
        return attrs;
    }

    private static String preProcessSrcPath(String srcPath) {
        String path = srcPath.equals("/") ? "" : srcPath;
        if (!path.endsWith("/") & !path.equals("")) {
            path = path + "/";
        }
        if (path.equals("\\/") || path.equals("/")) {
            path = "";
        }
        return path;
    }

    private static String constructURL(String spec, String url, String dsn, String db) {
        String urlString = "";
        if (spec != null && spec.length() > 0 && url != null && url.length() > 0) {
            String host = url;
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            if (host.startsWith("http:")) {
                host = host.substring(7, host.length());
            }
            String page = "/dimensions/";
            String urlQuery = "jsp=api&command=openi&object_id=";
            urlQuery = urlQuery + spec;
            urlQuery = urlQuery + "&DB_CONN=";
            urlQuery = urlQuery + dsn;
            urlQuery = urlQuery + "&DB_NAME=";
            urlQuery = urlQuery + db;
            try {
                Logger.Debug((String)("Host URL - " + host + " " + page + " " + urlQuery));
                String urlStr = DimensionsAPI.encodeUrl((String)host, (String)page, (String)urlQuery);
                Logger.Debug((String)("Change URL - " + urlStr));
                urlString = urlStr;
            }
            catch (Exception e) {
                return null;
            }
        }
        return urlString;
    }

    private static String constructRequestURL(String spec, String url, String dsn, String db) {
        String urlString = "";
        if (spec != null && spec.length() > 0 && url != null && url.length() > 0) {
            String host = url;
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            if (host.startsWith("http:")) {
                host = host.substring(7, host.length());
            }
            String page = "/dimensions/";
            String urlQuery = "jsp=api&command=opencd&object_id=";
            urlQuery = urlQuery + spec;
            urlQuery = urlQuery + "&DB_CONN=";
            urlQuery = urlQuery + dsn;
            urlQuery = urlQuery + "&DB_NAME=";
            urlQuery = urlQuery + db;
            try {
                Logger.Debug((String)("Request Host URL - " + host + " " + page + " " + urlQuery));
                String urlStr = DimensionsAPI.encodeUrl((String)host, (String)page, (String)urlQuery);
                Logger.Debug((String)("Request Change URL - " + urlStr));
                urlString = urlStr;
            }
            catch (Exception e) {
                return null;
            }
        }
        return urlString;
    }

    private static String encodeUrl(String host, String page, String query) throws MalformedURLException, URISyntaxException {
        String urlStr = "";
        if (page != null && page.length() > 0 && host != null && host.length() > 0 && query != null && query.length() > 0) {
            URI uri = new URI("http", host, page, query, null);
            urlStr = uri.toASCIIString();
        }
        return urlStr;
    }

    static List queryItems(DimensionsConnection connection, Project srcProject, String srcPath, Filter filter, int[] attrs, boolean isRecursive, boolean isLatest) {
        if (srcPath == null) {
            throw new IllegalArgumentException("The nested element needs a valid 'srcpath' attribute");
        }
        if (srcProject == null) {
            throw new IllegalArgumentException("The nested element needs a valid project to work on");
        }
        String path = DimensionsAPI.preProcessSrcPath((String)srcPath);
        if (!isRecursive || !path.equals("")) {
            filter.criteria().add(new Filter.Criterion(-1802, (Object)(isRecursive ? path + '%' : path), 0));
        }
        if (isLatest) {
            filter.criteria().add(new Filter.Criterion(-1804, (Object)Boolean.TRUE, 0));
        }
        try {
            Logger.Debug((String)("Looking for changed files in '" + path + "' in project: " + srcProject.getName()));
            List rels = srcProject.getChildItems(filter);
            Logger.Debug((String)("Found " + rels.size()));
            if (rels.size() == 0) {
                return null;
            }
            ArrayList<DimensionsObject> items = new ArrayList<DimensionsObject>(rels.size());
            for (int i = 0; i < rels.size(); ++i) {
                DimensionsRelatedObject rel = (DimensionsRelatedObject)rels.get(i);
                items.add(rel.getObject());
            }
            BulkOperator bo = connection.getObjectFactory().getBulkOperator(items);
            bo.queryAttribute(attrs);
            return items;
        }
        catch (Exception e) {
            Logger.Debug((String)("Exception detected from the Java API: " + e.getMessage()));
            return null;
        }
    }

    static List queryItems(DimensionsConnection connection, Baseline srcBaseline, String srcPath, Filter filter, int[] attrs, boolean isRecursive, boolean isLatest) {
        if (srcPath == null) {
            throw new IllegalArgumentException("The nested element needs a valid 'srcpath' attribute");
        }
        if (srcBaseline == null) {
            throw new IllegalArgumentException("The nested element needs a valid baseline to work on");
        }
        String path = DimensionsAPI.preProcessSrcPath((String)srcPath);
        if (!isRecursive || !path.equals("")) {
            filter.criteria().add(new Filter.Criterion(-1802, (Object)(isRecursive ? path + '%' : path), 0));
        }
        if (isLatest) {
            filter.criteria().add(new Filter.Criterion(-1804, (Object)Boolean.TRUE, 0));
        }
        try {
            Logger.Debug((String)("Looking for changed files in '" + path + "' in project: " + srcBaseline.getName()));
            List rels = srcBaseline.getChildItems(filter);
            Logger.Debug((String)("Found " + rels.size()));
            if (rels.size() == 0) {
                return null;
            }
            ArrayList<DimensionsObject> items = new ArrayList<DimensionsObject>(rels.size());
            for (int i = 0; i < rels.size(); ++i) {
                DimensionsRelatedObject rel = (DimensionsRelatedObject)rels.get(i);
                items.add(rel.getObject());
            }
            BulkOperator bo = connection.getObjectFactory().getBulkOperator(items);
            bo.queryAttribute(attrs);
            return items;
        }
        catch (Exception e) {
            Logger.Debug((String)("Exception detected from the Java API: " + e.getMessage()));
            return null;
        }
    }

    static boolean queryItems(DimensionsConnection connection, Request request, String srcPath, List items, Filter filter, Project srcProject, boolean isRecursive, boolean isLatest) {
        if (srcPath == null) {
            throw new IllegalArgumentException("The nested element needs a valid 'srcpath' attribute");
        }
        if (request == null) {
            throw new IllegalArgumentException("The nested element needs a valid request to work on");
        }
        Logger.Debug((String)("Looking for items against request " + request.getName()));
        String path = DimensionsAPI.preProcessSrcPath((String)(srcPath.equals("") ? "/" : srcPath));
        if (!isRecursive || !path.equals("")) {
            filter.criteria().add(new Filter.Criterion(-1802, (Object)(isRecursive ? path + '%' : path), 0));
        }
        if (isLatest) {
            filter.criteria().add(new Filter.Criterion(-1804, (Object)Boolean.TRUE, 0));
        }
        try {
            Logger.Debug((String)("Looking for changed files in '" + path + "' in request: " + request.getName()));
            request.queryChildItems(filter, srcProject);
            List rels = request.getChildItems(filter);
            Logger.Debug((String)("Found " + rels.size()));
            if (rels.size() == 0) {
                return true;
            }
            for (int i = 0; i < rels.size(); ++i) {
                Logger.Debug((String)("Processing " + i + "/" + rels.size()));
                DimensionsRelatedObject child = (DimensionsRelatedObject)rels.get(i);
                if (child == null || !(child.getObject() instanceof ItemRevision)) continue;
                Logger.Debug((String)"Found an item");
                DimensionsObject relType = child.getRelationship();
                if (!SystemRelationship.IN_RESPONSE.equals((Object)relType)) continue;
                items.add(child.getObject());
            }
            return true;
        }
        catch (Exception e) {
            Logger.Debug((String)("Exception detected from the Java API: " + e.getMessage()));
            return false;
        }
    }

    private boolean getDmChildRequests(Request request, List requestList) throws DimensionsRuntimeException {
        try {
            request.flushRelatedObjects(Request.class, true);
            request.queryChildRequests(null);
            List rels = request.getChildRequests(null);
            Logger.Debug((String)("Found " + rels.size()));
            if (rels.size() == 0) {
                return true;
            }
            for (int i = 0; i < rels.size(); ++i) {
                Logger.Debug((String)("Processing " + i + "/" + rels.size()));
                DimensionsRelatedObject child = (DimensionsRelatedObject)rels.get(i);
                if (child != null && child.getObject() instanceof Request) {
                    Logger.Debug((String)"Found a request");
                    DimensionsObject relType = child.getRelationship();
                    if (!SystemRelationship.DEPENDENT.equals((Object)relType)) continue;
                    Logger.Debug((String)"Found a dependent request");
                    requestList.add(child.getObject());
                    if (this.getDmChildRequests((Request)child.getObject(), requestList)) continue;
                    return false;
                }
                Logger.Debug((String)("Related object was null or not a request " + (child != null)));
            }
            return true;
        }
        catch (Exception e) {
            Logger.Debug((String)("Exception detected from the Java API: " + e.getMessage()));
            throw new DimensionsRuntimeException("getDmChildRequests - encountered a Java API exception");
        }
    }

    static DimensionsResult run(DimensionsConnection connection, String cmd) throws IllegalArgumentException, DimensionsRuntimeException {
        if (cmd == null || cmd.equals("")) {
            throw new IllegalArgumentException("The <run> nested element need a valid 'cmd' attribute");
        }
        Logger.Debug((String)("Running the command '" + cmd + "'..."));
        try {
            DimensionsObjectFactory dof = connection.getObjectFactory();
            DimensionsResult res = dof.runCommand(cmd);
            return res;
        }
        catch (Exception e) {
            Logger.Debug((String)"Command failed to run");
            throw new DimensionsRuntimeException("Dimension command failed -\n\t(" + cmd + ")\n\t(" + e.getMessage() + ")");
        }
    }

    static int getDateTypeAttribute(String dateType) {
        int ret = -1201;
        if (dateType != null) {
            if (dateType.equalsIgnoreCase("edit")) {
                ret = -1301;
            } else if (dateType.equalsIgnoreCase("actioned")) {
                ret = -1401;
            } else if (dateType.equalsIgnoreCase("revised")) {
                ret = -1303;
            } else if (dateType.equalsIgnoreCase("add")) {
                ret = -1201;
            }
        }
        return ret;
    }

    static String formatDatabaseDate(Date date, TimeZone timeZone) {
        return timeZone == null ? DateUtils.format((Date)date) : DateUtils.format((Date)date, (TimeZone)timeZone);
    }

    static Date parseDatabaseDate(String date, TimeZone timeZone) {
        return timeZone == null ? DateUtils.parse((String)date) : DateUtils.parse((String)date, (TimeZone)timeZone);
    }

    public boolean isStream(long key, String projectId) throws DimensionsRuntimeException {
        DimensionsConnection connection = this.getCon(key);
        if (connection == null) {
            throw new DimensionsRuntimeException("Not connected to an SCM repository");
        }
        return this.isStream(connection, projectId);
    }

    private boolean isStream(DimensionsConnection connection, String projectId) {
        DimensionsObjectFactory fc;
        Project proj;
        if (connection != null && (proj = (fc = connection.getObjectFactory()).getProject(projectId.toUpperCase())) != null) {
            proj.queryAttribute(-914);
            Boolean isStream = (Boolean)proj.getAttribute(-914);
            if (isStream != null) {
                return isStream;
            }
        }
        return false;
    }

    public List getItemsInRequests(DimensionsConnection connection, String projName, String requests, String dateAfter, String dateBefore) throws DimensionsRuntimeException {
        ArrayList items = null;
        int[] attrs = DimensionsAPI.getItemFileAttributes((boolean)true);
        if (requests != null && connection != null) {
            String[] reqStr = null;
            if (requests.indexOf(",") > 0) {
                reqStr = requests.split(",");
                Logger.Debug((String)("User specified " + reqStr.length + " requests"));
            } else {
                reqStr = new String[]{requests};
            }
            ArrayList<Request> requestList = new ArrayList<Request>(1);
            items = new ArrayList(1);
            Filter filter = new Filter();
            filter.criteria().add(new Filter.Criterion(-1805, (Object)"Y", 64));
            filter.orders().add(new Filter.Order(-1807, 1));
            filter.orders().add(new Filter.Order(-1802, 1));
            filter.orders().add(new Filter.Order(-1801, 1));
            if (dateAfter != null) {
                filter.criteria().add(new Filter.Criterion(-1301, (Object)dateAfter, 80));
                filter.criteria().add(new Filter.Criterion(-1201, (Object)dateAfter, 80));
            }
            if (dateBefore != null) {
                filter.criteria().add(new Filter.Criterion(-1301, (Object)dateBefore, 96));
                filter.criteria().add(new Filter.Criterion(-1201, (Object)dateBefore, 96));
            }
            for (int ii = 0; ii < reqStr.length; ++ii) {
                String xStr = reqStr[ii];
                xStr.trim();
                Logger.Debug((String)("Request to process is \"" + xStr + "\""));
                Request requestObj = connection.getObjectFactory().findRequest(xStr.toUpperCase());
                if (requestObj == null) continue;
                Logger.Debug((String)("Request to process is \"" + requestObj.getName() + "\""));
                requestList.add(requestObj);
                if (!this.getDmChildRequests(requestObj, requestList)) {
                    throw new DimensionsRuntimeException("Could not process request \"" + requestObj.getName() + "\" children in repository");
                }
                Logger.Debug((String)("Request has " + requestList.size() + " elements to process"));
                Project projectObj = connection.getObjectFactory().getProject(projName);
                for (int i = 0; i < requestList.size(); ++i) {
                    Request req = (Request)requestList.get(i);
                    Logger.Debug((String)("Request " + i + " is \"" + req.getName() + "\""));
                    if (DimensionsAPI.queryItems((DimensionsConnection)connection, (Request)req, (String)"/", items, (Filter)filter, (Project)projectObj, (boolean)true, (boolean)this.allRevisions)) continue;
                    throw new DimensionsRuntimeException("Could not process items for request \"" + req.getName() + "\"");
                }
                if (items == null) continue;
                Logger.Debug((String)("Request has " + items.size() + " items to process"));
                BulkOperator bo = connection.getObjectFactory().getBulkOperator(items);
                bo.queryAttribute(attrs);
            }
        }
        return items;
    }
}

