/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.FileUtils;
import hudson.plugins.dimensionsscm.Logger;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAPITask
implements FilePath.FileCallable<Boolean> {
    protected FilePath workspace = null;
    protected TaskListener listener = null;
    protected String userName = "";
    protected String passwd = "";
    protected String database = "";
    protected String server = "";
    protected String permissions = "";
    protected long key = -1L;
    protected DimensionsAPI dmSCM = null;
    protected FileUtils fu;
    protected static final long serialVersionUID = 1L;

    public GenericAPITask() {
    }

    public GenericAPITask(DimensionsSCM parent, FilePath workspace, TaskListener listener) {
        Logger.Debug("Creating task - " + this.getClass().getName());
        this.workspace = workspace;
        this.listener = listener;
        this.userName = parent.getJobUserName();
        this.passwd = parent.getJobPasswd();
        this.database = parent.getJobDatabase();
        this.server = parent.getJobServer();
    }

    public Boolean invoke(File area, VirtualChannel channel) throws IOException {
        boolean bRet = true;
        try {
            this.listener.getLogger().println("[DIMENSIONS] Running build in '" + area.getAbsolutePath() + "'...");
            if (this.dmSCM == null) {
                this.dmSCM = new DimensionsAPI();
            }
            this.dmSCM.setLogger(this.listener.getLogger());
            this.key = this.dmSCM.login(this.userName, this.passwd, this.database, this.server);
            if (this.key > 0L) {
                Logger.Debug("Login worked.");
                bRet = this.execute(area, channel);
            }
        }
        catch (Exception e) {
            bRet = false;
            throw new IOException(e.getMessage());
        }
        finally {
            this.dmSCM.logout(this.key);
        }
        this.dmSCM = null;
        return bRet;
    }

    public Boolean execute(File area, VirtualChannel channel) throws IOException {
        return true;
    }
}

