/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.plugins.dimensionsscm.PathUtils;
import hudson.plugins.dimensionsscm.SCMLauncher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class DiffUtils
implements Serializable {
    protected static final long serialVersionUID = 1L;
    private PathUtils pu;
    private String exec = "diff";
    private String results = null;
    private File file1 = null;
    private File file2 = null;

    public String getResults() {
        return this.results;
    }

    public File getBaseFile() {
        return this.file1;
    }

    public File getUserFile() {
        return this.file2;
    }

    private File getExecutable(String exeName) {
        return PathUtils.getExecutable(exeName);
    }

    public DiffUtils(String file1, String file2) {
        this.file1 = new File(file1);
        this.file2 = new File(file2);
    }

    public boolean diff() throws IOException, InterruptedException {
        boolean result = false;
        File exe = this.getExecutable(this.exec);
        if (exe == null) {
            throw new IOException("The '" + this.exec + "' executable could not be located in the path");
        }
        String[] cmd = new String[]{exe.getAbsolutePath(), this.file1.getAbsolutePath(), this.file2.getAbsolutePath()};
        SCMLauncher proc = new SCMLauncher(cmd, null, null);
        result = proc.execute();
        this.results = proc.getResults();
        return result;
    }
}

