/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.Builder;
import hudson.util.VariableResolver;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsBuilder
extends Builder {
    private static DimensionsSCM scm = null;
    private String projectArea = null;
    private String projectConfig = null;
    private String projectOptions = null;
    private String projectTargets = null;
    private String projectType = null;
    private String projectStage = null;
    private boolean batch = false;
    private boolean buildClean = false;
    private boolean capture = false;
    private boolean audit = false;
    private boolean populate = false;
    private boolean touch = false;
    @Extension
    public static final DescriptorImpl DMBLD_DESCRIPTOR = new DescriptorImpl();

    public boolean isProjectAudit() {
        return this.audit;
    }

    public boolean isProjectPopulate() {
        return this.populate;
    }

    public boolean isProjectTouch() {
        return this.touch;
    }

    public boolean isProjectBatch() {
        return this.batch;
    }

    public boolean isProjectClean() {
        return this.buildClean;
    }

    public boolean isProjectCapture() {
        return this.capture;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getProjectStage() {
        return this.projectStage;
    }

    public String getProjectArea() {
        return this.projectArea;
    }

    public String getProjectConfig() {
        return this.projectConfig;
    }

    public String getProjectOptions() {
        return this.projectOptions;
    }

    public String getProjectTargets() {
        return this.projectTargets;
    }

    public DimensionsBuilder(String area, String buildConfig, String buildOptions, String buildTargets, String buildType, String buildStage, boolean batch, boolean buildClean, boolean capture, boolean audit, boolean populate, boolean touch) {
        this.projectArea = area;
        this.projectConfig = buildConfig;
        this.projectOptions = buildOptions;
        this.projectTargets = buildTargets;
        this.projectType = buildType;
        this.projectStage = buildStage;
        this.batch = batch;
        this.buildClean = buildClean;
        this.capture = capture;
        this.audit = audit;
        this.populate = populate;
        this.touch = touch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        block13: {
            Logger.Debug("Invoking perform callout " + ((Object)((Object)this)).getClass().getName());
            long key = -1L;
            try {
                if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                    listener.fatalError("[DIMENSIONS] This plugin only works with the Dimensions SCM engine.");
                    build.setResult(Result.FAILURE);
                    throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
                }
                if (!build.isBuilding()) break block13;
                if (scm == null) {
                    scm = (DimensionsSCM)build.getProject().getScm();
                }
                Logger.Debug("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer());
                Logger.Debug("Running a project build step...");
                key = scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer());
                if (key > 0L) {
                    String projectXType;
                    VariableResolver myResolver = build.getBuildVariableResolver();
                    String requests = (String)myResolver.resolve("DM_TARGET_REQUEST");
                    if (requests != null) {
                        requests = requests.replaceAll(" ", "");
                        requests = requests.toUpperCase();
                    }
                    if ((projectXType = this.projectType).equals("NONE")) {
                        projectXType = null;
                    }
                    listener.getLogger().println("[DIMENSIONS] Submitting a build job to Dimensions...");
                    listener.getLogger().flush();
                    DimensionsResult res = scm.getAPI().buildProject(key, this.projectArea, scm.getProject(), this.batch, this.buildClean, this.projectConfig, this.projectOptions, this.capture, requests, this.projectTargets, this.projectStage, projectXType, this.audit, this.populate, this.touch, build);
                    if (res == null) {
                        listener.getLogger().println("[DIMENSIONS] The project failed to be built in Dimensions");
                        listener.getLogger().flush();
                        build.setResult(Result.FAILURE);
                    } else {
                        listener.getLogger().println("[DIMENSIONS] Build step was successfully run in Dimensions");
                        listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                        listener.getLogger().flush();
                    }
                    break block13;
                }
                listener.fatalError("[DIMENSIONS] Login to Dimensions failed.");
                build.setResult(Result.FAILURE);
                boolean myResolver = false;
                return myResolver;
            }
            catch (Exception e) {
                String errMsg = e.getMessage() != null || e.getMessage().length() > 0 ? e.getMessage() : "Dimensions returned no error";
                listener.fatalError("Unable to tag build in Dimensions - " + errMsg);
                build.setResult(Result.FAILURE);
                boolean bl = false;
                return bl;
            }
            finally {
                if (scm != null) {
                    scm.getAPI().logout(key);
                }
            }
        }
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return DMBLD_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public DescriptorImpl() {
            super(DimensionsBuilder.class);
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Boolean batch = "on".equalsIgnoreCase(req.getParameter("dimensionsbuilder.projectBatch"));
            Boolean buildClean = "on".equalsIgnoreCase(req.getParameter("dimensionsbuilder.projectClean"));
            Boolean capture = "on".equalsIgnoreCase(req.getParameter("dimensionsbuilder.projectCapture"));
            Boolean audit = "on".equalsIgnoreCase(req.getParameter("dimensionsbuilder.projectAudit"));
            Boolean populate = "on".equalsIgnoreCase(req.getParameter("dimensionsbuilder.projectPopulate"));
            Boolean touch = "on".equalsIgnoreCase(req.getParameter("dimensionsbuilder.projectTouch"));
            String area = req.getParameter("dimensionsbuilder.projectArea");
            String buildConfig = req.getParameter("dimensionsbuilder.projectConfig");
            String buildOptions = req.getParameter("dimensionsbuilder.projectOptions");
            String buildTargets = req.getParameter("dimensionsbuilder.projectTargets");
            String buildType = req.getParameter("dimensionsbuilder.projectType");
            String buildStage = req.getParameter("dimensionsbuilder.projectStage");
            if (area != null) {
                area = Util.fixNull((String)req.getParameter("dimensionsbuilder.projectArea").trim());
            }
            if (buildConfig != null) {
                buildConfig = Util.fixNull((String)req.getParameter("dimensionsbuilder.projectConfig").trim());
            }
            if (buildOptions != null) {
                buildOptions = Util.fixNull((String)req.getParameter("dimensionsbuilder.projectOptions").trim());
            }
            if (buildTargets != null) {
                buildTargets = Util.fixNull((String)req.getParameter("dimensionsbuilder.projectTargets").trim());
            }
            if (buildType != null) {
                buildType = Util.fixNull((String)req.getParameter("dimensionsbuilder.projectType").trim());
            }
            if (buildStage != null) {
                buildStage = Util.fixNull((String)req.getParameter("dimensionsbuilder.projectStage").trim());
            }
            DimensionsBuilder notif = new DimensionsBuilder(area, buildConfig, buildOptions, buildTargets, buildType, buildStage, batch, buildClean, capture, audit, populate, touch);
            return notif;
        }

        public String getDisplayName() {
            return "Execute Dimensions Build";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.save();
            return super.configure(req, o);
        }
    }
}

