/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.GenericAPITask;
import hudson.plugins.dimensionsscm.Logger;
import hudson.remoting.VirtualChannel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckOutAPITask
extends GenericAPITask
implements FilePath.FileCallable<Boolean> {
    boolean bFreshBuild = false;
    boolean isDelete = false;
    boolean isRevert = false;
    boolean isForce = false;
    boolean isExpand = false;
    boolean isNoMetadata = false;
    VariableResolver<String> myResolver;
    String workarea = "";
    String projectId = "";
    String[] folders;
    int version = 0;

    public CheckOutAPITask(AbstractBuild<?, ?> build, DimensionsSCM parent, FilePath workspace, TaskListener listener, int version) {
        Logger.Debug("Creating task - " + this.getClass().getName());
        this.workspace = workspace;
        this.listener = listener;
        this.version = version;
        this.userName = parent.getJobUserName();
        this.passwd = parent.getJobPasswd();
        this.database = parent.getJobDatabase();
        this.server = parent.getJobServer();
        this.workarea = parent.getWorkarea();
        this.isDelete = parent.isCanJobDelete();
        this.projectId = parent.getProject();
        this.isRevert = parent.isCanJobRevert();
        this.isForce = parent.isCanJobForce();
        this.isExpand = parent.isCanJobExpand();
        this.isNoMetadata = parent.isCanJobNoMetadata();
        this.folders = parent.getFolders();
        this.permissions = parent.getPermissions();
        this.bFreshBuild = build.getPreviousBuild() == null;
        this.myResolver = build.getBuildVariableResolver();
    }

    @Override
    public Boolean execute(File area, VirtualChannel channel) throws IOException {
        boolean bRet = true;
        try {
            StringBuffer cmdOutput = new StringBuffer();
            FilePath wa = null;
            if (this.workarea != null) {
                File waN = new File(this.workarea);
                wa = new FilePath(waN);
            } else {
                wa = new FilePath(area);
            }
            if (this.bFreshBuild && this.listener.getLogger() != null) {
                this.listener.getLogger().println("[DIMENSIONS] Checking out a fresh workspace because this project has not been built before...");
                this.listener.getLogger().flush();
            }
            if (wa.exists() && (this.isDelete || this.bFreshBuild)) {
                Logger.Debug("Deleting '" + wa.toURI() + "'...");
                this.listener.getLogger().println("[DIMENSIONS] Removing '" + wa.toURI() + "'...");
                this.listener.getLogger().flush();
                wa.deleteContents();
            }
            String baseline = (String)this.myResolver.resolve("DM_BASELINE");
            String requests = (String)this.myResolver.resolve("DM_REQUEST");
            if (baseline != null) {
                baseline = baseline.trim();
                baseline = baseline.toUpperCase();
            }
            if (requests != null) {
                requests = requests.replaceAll(" ", "");
                requests = requests.toUpperCase();
            }
            Logger.Debug("Extra parameters - " + baseline + " " + requests);
            String cmdLog = null;
            if (baseline != null && baseline.length() == 0) {
                baseline = null;
            }
            if (requests != null && requests.length() == 0) {
                requests = null;
            }
            if (this.listener.getLogger() != null) {
                if (requests != null) {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out request(s) \"" + requests + "\" - ignoring project folders...");
                } else if (baseline != null) {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out baseline \"" + baseline + "\"...");
                } else {
                    this.listener.getLogger().println("[DIMENSIONS] Checking out project \"" + this.projectId + "\"...");
                }
                this.listener.getLogger().flush();
            }
            if (this.version == 10 && requests != null) {
                String[] requestsProcess = requests.split(",");
                if (requestsProcess.length == 0) {
                    requestsProcess[0] = requests;
                }
                this.listener.getLogger().println("[DIMENSIONS] Defaulting to read-only permissions as this is the only available mode...");
                for (int xx = 0; xx < requestsProcess.length && bRet; ++xx) {
                    String folderN = "/";
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    String reqId = requestsProcess[xx];
                    Logger.Debug("Checking out '" + folderN + "'...");
                    bRet = this.dmSCM.checkout(this.key, this.projectId, dname, wa, cmdOutput, baseline, reqId, this.isRevert, this.isExpand, this.isNoMetadata, "DEFAULT");
                    Logger.Debug("SCM checkout returned " + bRet);
                    if (!bRet && this.isForce) {
                        bRet = true;
                    }
                    if (cmdLog == null) {
                        cmdLog = "\n";
                    }
                    cmdLog = cmdLog + cmdOutput;
                    cmdOutput.setLength(0);
                    cmdLog = cmdLog + "\n";
                }
            } else {
                for (int ii = 0; ii < this.folders.length && bRet; ++ii) {
                    String folderN = this.folders[ii];
                    File fileName = new File(folderN);
                    FilePath dname = new FilePath(fileName);
                    Logger.Debug("Checking out '" + folderN + "'...");
                    bRet = this.dmSCM.checkout(this.key, this.projectId, dname, wa, cmdOutput, baseline, requests, this.isRevert, this.isExpand, this.isNoMetadata, this.permissions);
                    Logger.Debug("SCM checkout returned " + bRet);
                    if (!bRet && this.isForce) {
                        bRet = true;
                    }
                    if (cmdLog == null) {
                        cmdLog = "\n";
                    }
                    cmdLog = cmdLog + cmdOutput;
                    cmdOutput.setLength(0);
                    cmdLog = cmdLog + "\n";
                    if (requests == null) {
                        continue;
                    }
                    break;
                }
            }
            if (cmdLog.length() > 0 && this.listener.getLogger() != null) {
                Logger.Debug("Found command output to log to the build logger");
                this.listener.getLogger().println("[DIMENSIONS] (Note: Dimensions command output was - ");
                cmdLog = cmdLog.replaceAll("\n\n", "\n");
                this.listener.getLogger().println(cmdLog.replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                this.listener.getLogger().flush();
            }
            if (!bRet) {
                this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                this.listener.getLogger().println("[DIMENSIONS] The Dimensions checkout command returned a failure status.");
                this.listener.getLogger().println("[DIMENSIONS] Please review the command output and correct any issues");
                this.listener.getLogger().println("[DIMENSIONS] that may have been detected.");
                this.listener.getLogger().println("[DIMENSIONS] ==========================================================");
                this.listener.getLogger().flush();
            }
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "An unknown error occurred. Please try the operation again.";
            }
            this.listener.fatalError("Unable to run checkout callout - " + errMsg);
            bRet = false;
        }
        return bRet;
    }
}

