/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;

public class SCMLauncher
implements Serializable {
    private FileUtils fu;
    private String[] args = null;
    private dmLauncher proc = null;
    private FilePath workArea = null;
    private String results = null;

    public SCMLauncher(String[] args, TaskListener listener, FilePath area) {
        this.args = args;
        this.proc = new dmLauncher(listener);
        this.workArea = area;
    }

    public String getResults() {
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean execute() throws IOException, InterruptedException {
        File tmpFile = null;
        boolean bRet = false;
        TaskListener listener = this.proc.getListener();
        File logFile = new File("a");
        Calendar nowDateCal = Calendar.getInstance();
        tmpFile = File.createTempFile("dmCm" + nowDateCal.getTimeInMillis(), null, null);
        FileOutputStream fos = new FileOutputStream(tmpFile);
        StreamBuildListener os = new StreamBuildListener((OutputStream)fos);
        boolean[] masks = new boolean[this.args.length];
        int i = 0;
        for (String astr : this.args) {
            if (astr.equalsIgnoreCase("-param")) {
                masks[i] = true;
                masks[i + 1] = true;
            }
            ++i;
        }
        try {
            Launcher.ProcStarter ps = this.proc.launch();
            ps.cmds(this.args);
            ps.stdout((OutputStream)os.getLogger());
            ps.stdin(null);
            ps.pwd(this.workArea);
            ps.masks(masks);
            int cmdResult = ps.join();
            if (cmdResult != 0) {
                listener.fatalError("Execution of Dimensions command failed with exit code " + cmdResult);
                bRet = false;
            } else {
                bRet = true;
            }
        }
        finally {
            os.getLogger().flush();
            fos.close();
            os = null;
            fos = null;
        }
        if (tmpFile != null) {
            this.results = new String(FileUtils.loadFile(tmpFile));
            tmpFile.delete();
            tmpFile = null;
        }
        return bRet;
    }

    static class dmLauncher
    extends Launcher.LocalLauncher {
        private TaskListener listener = null;

        public TaskListener getListener() {
            return this.listener;
        }

        dmLauncher(TaskListener listener) {
            super(listener);
            this.listener = listener;
        }
    }
}

