/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jboss;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.jboss.JBossBuilder;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;

public class CommandsUtils {
    private CommandsUtils() {
    }

    public static boolean start(JBossBuilder.ServerBean server, String extraProperties, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(launcher.isUnix() ? "run.sh" : "run.bat");
        args.add(new String[]{"-c", server.getServerName()});
        if (!launcher.isUnix()) {
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        EnvVars env = build.getEnvironment((TaskListener)listener);
        VariableResolver vr = build.getBuildVariableResolver();
        String properties = env.expand(extraProperties);
        args.addKeyValuePairsFromPropertyString("-D", properties, vr);
        try {
            launcher.launch().stderr((OutputStream)listener.getLogger()).stdout((OutputStream)new NullOutputStream()).cmds(args).pwd(server.getHomeDir() + "/bin").start();
            return true;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
            }
            e.printStackTrace(listener.fatalError("Error during execution."));
            return false;
        }
    }

    public static boolean stop(JBossBuilder.ServerBean server, Launcher launcher, BuildListener listener) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(launcher.isUnix() ? "shutdown.sh" : "shutdown.bat");
        String jndiUrl = "jnp://127.0.0.1:" + server.getJndiPort();
        args.add(new String[]{"-s", jndiUrl, "-S"});
        if (!launcher.isUnix()) {
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        try {
            launcher.launch().stderr((OutputStream)listener.getLogger()).stdout((OutputStream)new NullOutputStream()).cmds(args).pwd(server.getHomeDir() + "/bin").join();
            return true;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
            }
            e.printStackTrace(listener.fatalError("Error during execution."));
            return false;
        }
    }
}

