/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jboss;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.jboss.CommandsUtils;
import hudson.plugins.jboss.JBossBuilder;
import hudson.plugins.jboss.JMXUtils;
import hudson.plugins.jboss.Operation;
import hudson.tasks.Builder;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class JBossBuilder
extends Builder {
    private final ServerBean server;
    private final Operation operation;
    private final String hostName = "127.0.0.1";

    @DataBoundConstructor
    public JBossBuilder(Operation operation, String serverName) {
        this.operation = operation;
        ServerBean localServerBean = null;
        for (ServerBean bean : this.getDescriptor().getServers()) {
            if (!bean.getServerName().equals(serverName)) continue;
            localServerBean = bean;
            break;
        }
        this.server = localServerBean;
    }

    public ServerBean getServer() {
        return this.server;
    }

    public Operation getOperation() {
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.server == null || this.operation == null) {
            listener.fatalError("Wrong configuration of plugin. Step error.");
            return false;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            switch (1.$SwitchMap$hudson$plugins$jboss$OperationEnum[this.operation.getType().ordinal()]) {
                case 1: {
                    boolean ret;
                    if (JMXUtils.checkServerStatus((String)"127.0.0.1", (int)this.server.getJndiPort(), (BuildListener)listener, (int)3, (boolean)true)) {
                        listener.getLogger().println("JBoss AS already started.");
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = ret = CommandsUtils.start((ServerBean)this.server, (String)this.operation.getProperties(), (AbstractBuild)build, (Launcher)launcher, (BuildListener)listener) && JMXUtils.checkServerStatus((String)"127.0.0.1", (int)this.server.getJndiPort(), (BuildListener)listener, (int)15, (boolean)false);
                    if (ret) {
                        listener.getLogger().println("JBoss AS started!");
                    } else {
                        listener.getLogger().println("JBoss AS is not stared before timeout has expired!");
                    }
                    boolean bl2 = ret;
                    return bl2;
                }
                case 2: {
                    if (JMXUtils.checkServerStatus((String)"127.0.0.1", (int)this.server.getJndiPort(), (BuildListener)listener, (int)3, (boolean)true)) {
                        listener.getLogger().println("JBoss AS already started.");
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = CommandsUtils.start((ServerBean)this.server, (String)this.operation.getProperties(), (AbstractBuild)build, (Launcher)launcher, (BuildListener)listener);
                    return bl;
                }
                case 3: {
                    if (!JMXUtils.checkServerStatus((String)"127.0.0.1", (int)this.server.getJndiPort(), (BuildListener)listener, (int)3, (boolean)true)) {
                        listener.getLogger().println("JBoss AS is not working.");
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = CommandsUtils.stop((ServerBean)this.server, (Launcher)launcher, (BuildListener)listener);
                    return bl;
                }
                case 4: {
                    JMXUtils.checkServerStatus((String)"127.0.0.1", (int)this.server.getJndiPort(), (BuildListener)listener, (int)3, (boolean)false);
                    boolean result = false;
                    if (Util.fixEmpty((String)this.operation.getProperties()) != null) {
                        String[] modules = Util.tokenize((String)this.operation.getProperties());
                        result = JMXUtils.checkDeploy((String)"127.0.0.1", (int)this.server.getJndiPort(), (BuildListener)listener, (int)3, (String[])modules);
                    } else {
                        listener.getLogger().println("Mo modules provided.");
                        result = true;
                    }
                    if (!result && this.operation.isStopOnFailure()) {
                        listener.getLogger().println("StopOnFailure flag is set, going to down server...");
                        CommandsUtils.stop((ServerBean)this.server, (Launcher)launcher, (BuildListener)listener);
                    }
                    boolean bl = result;
                    return bl;
                }
            }
            listener.fatalError("Uexpected type of operation.");
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

