/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jboss;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.jboss.CommandsUtils;
import hudson.plugins.jboss.JMXUtils;
import hudson.plugins.jboss.Operation;
import hudson.plugins.jboss.OperationEnum;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JBossBuilder
extends Builder {
    private final ServerBean server;
    private final Operation operation;
    private final String hostName = "127.0.0.1";

    @DataBoundConstructor
    public JBossBuilder(Operation operation, String serverName) {
        this.operation = operation;
        ServerBean localServerBean = null;
        for (ServerBean bean : this.getDescriptor().getServers()) {
            if (!bean.getServerName().equals(serverName)) continue;
            localServerBean = bean;
            break;
        }
        this.server = localServerBean;
    }

    public ServerBean getServer() {
        return this.server;
    }

    public Operation getOperation() {
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.server == null || this.operation == null) {
            listener.fatalError("Wrong configuration of the plugin. Step error.");
            return false;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            switch (this.operation.getType()) {
                case START_AND_WAIT: {
                    boolean ret;
                    if (JMXUtils.checkServerStatus("127.0.0.1", this.server.getJndiPort(), listener, 3, true)) {
                        listener.getLogger().println("JBoss AS already started.");
                        boolean bl = true;
                        return bl;
                    }
                    listener.getLogger().println("Going to start server with timeout " + this.server.getTimeout() * 60 + " seconds...");
                    boolean bl = ret = CommandsUtils.start(this.server, this.operation.getProperties(), build, launcher, listener) && JMXUtils.checkServerStatus("127.0.0.1", this.server.getJndiPort(), listener, this.server.getTimeout() * 60, false);
                    if (ret) {
                        listener.getLogger().println("JBoss AS started!");
                    } else {
                        listener.getLogger().println(String.format("JBoss AS is not stared before timeout (%d min) has expired!", this.server.getTimeout()));
                    }
                    boolean bl2 = ret;
                    return bl2;
                }
                case START: {
                    if (JMXUtils.checkServerStatus("127.0.0.1", this.server.getJndiPort(), listener, 3, true)) {
                        listener.getLogger().println("JBoss AS already started.");
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = CommandsUtils.start(this.server, this.operation.getProperties(), build, launcher, listener);
                    return bl;
                }
                case SHUTDOWN: {
                    if (!JMXUtils.checkServerStatus("127.0.0.1", this.server.getJndiPort(), listener, 3, true)) {
                        listener.getLogger().println("JBoss AS is not working.");
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = CommandsUtils.stop(this.server, launcher, listener);
                    return bl;
                }
                case CHECK_DEPLOY: {
                    JMXUtils.checkServerStatus("127.0.0.1", this.server.getJndiPort(), listener, 3, false);
                    boolean result = false;
                    if (Util.fixEmpty((String)this.operation.getProperties()) != null) {
                        String[] modules = Util.tokenize((String)this.operation.getProperties());
                        result = JMXUtils.checkDeploy("127.0.0.1", this.server.getJndiPort(), listener, 3, modules);
                    } else {
                        listener.getLogger().println("Mo modules provided.");
                        result = true;
                    }
                    if (!result && this.operation.isStopOnFailure()) {
                        listener.getLogger().println("StopOnFailure flag is set, going to down server...");
                        CommandsUtils.stop(this.server, launcher, listener);
                    }
                    boolean bl = result;
                    return bl;
                }
            }
            listener.fatalError("Uexpected type of operation.");
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class ServerBean {
        private final String homeDir;
        private final String serverName;
        private final int jndiPort;
        private final int timeout;

        public ServerBean(String homeDir, String serverName, int jndiPort, int timeout) {
            this.homeDir = homeDir;
            this.serverName = serverName;
            this.jndiPort = jndiPort;
            this.timeout = timeout;
        }

        public String getHomeDir() {
            return this.homeDir;
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getJndiPort() {
            return this.jndiPort;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String toString() {
            return "ServerBean=" + this.serverName + ":" + this.jndiPort + " timeout=" + this.timeout;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String homeDir;
        private List<ServerBean> servers = new ArrayList<ServerBean>();

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckHomeDir(@QueryParameter String jbossHomeString) throws IOException, ServletException {
            if (jbossHomeString == null || jbossHomeString.length() == 0) {
                return FormValidation.error((String)"Please set path to JBoss home.");
            }
            File jbossHomeFile = new File(jbossHomeString);
            if (!jbossHomeFile.exists()) {
                return FormValidation.error((String)"Path doesn't exist.");
            }
            if (!jbossHomeFile.isDirectory()) {
                return FormValidation.error((String)"Path is not valid directory.");
            }
            for (String subDir : new String[]{"bin", "server"}) {
                File subFile = new File(jbossHomeFile, subDir);
                if (subFile.exists() && subFile.isDirectory()) continue;
                return FormValidation.error((String)"It's not look like correct JBoss home directory.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerName(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)"Server name can not be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJndiPort(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)"JNDI port is mandatory.");
            }
            int jndiPortNr = 0;
            try {
                jndiPortNr = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"JNDI port is not valid number.");
            }
            if (jndiPortNr <= 1024) {
                return FormValidation.error((String)"JNDI port can not be lowest then 1024.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)"Timeout is mandatory.");
            }
            int timeout = 0;
            try {
                timeout = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Timeout is not valid number.");
            }
            if (timeout < 5) {
                return FormValidation.warning((String)"Timeout is very low, are you sure JBoss will start in this time?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "JBoss Management";
        }

        public boolean configure(StaplerRequest req, JSONObject parameters) throws Descriptor.FormException {
            this.homeDir = parameters.getString("homeDir");
            this.servers.clear();
            JSONObject optServersObject = parameters.optJSONObject("servers");
            if (optServersObject != null) {
                this.servers.add(new ServerBean(this.homeDir, optServersObject.getString("serverName"), optServersObject.getInt("jndiPort"), optServersObject.getInt("timeout")));
            } else {
                JSONArray optServersArray = parameters.optJSONArray("servers");
                if (optServersArray != null) {
                    for (int i = 0; i < optServersArray.size(); ++i) {
                        JSONObject serverObject = (JSONObject)optServersArray.get(i);
                        this.servers.add(new ServerBean(this.homeDir, serverObject.getString("serverName"), serverObject.getInt("jndiPort"), serverObject.getInt("timeout")));
                    }
                }
            }
            this.save();
            return super.configure(req, parameters);
        }

        public String getHomeDir() {
            return this.homeDir;
        }

        public List<ServerBean> getServers() {
            return this.servers;
        }

        public OperationEnum[] getOperations() {
            return OperationEnum.all;
        }
    }
}

