/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jboss;

import hudson.model.BuildListener;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMXUtils {
    private JMXUtils() {
    }

    public static InitialContext getInitialContext(String hostName, int jndiPort) {
        Properties env = new Properties();
        try {
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            env.put("java.naming.provider.url", hostName + ":" + jndiPort);
            return new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to instantiate naming context: " + e.getMessage(), e);
        }
    }

    public static MBeanServerConnection getMBeanServer(InitialContext ctx, BuildListener listener, int timeout) {
        MBeanServerConnection server = null;
        NamingException ne = null;
        int retryWait = 1000;
        for (int i = 0; i < timeout; ++i) {
            try {
                Thread.sleep(retryWait);
                server = (MBeanServerConnection)ctx.lookup("jmx/invoker/RMIAdaptor");
                break;
            }
            catch (NamingException e) {
                ne = e;
                continue;
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Thread interrupted while waiting for MBean connection: " + e.getMessage());
                return server;
            }
        }
        if (server == null) {
            throw new RuntimeException("Unable to get JBoss JMX MBean connection " + "in " + timeout + " seconds.", ne);
        }
        return server;
    }

    public static boolean isServerStarted(MBeanServerConnection server) throws Exception {
        ObjectName serverMBeanName = new ObjectName("jboss.system:type=Server");
        return (Boolean)server.getAttribute(serverMBeanName, "Started");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkServerStatus(String hostName, int jndiPort, BuildListener listener, int timeout, boolean ignoreErrors) {
        boolean started = false;
        try {
            InitialContext ctx = JMXUtils.getInitialContext(hostName, jndiPort);
            MBeanServerConnection server = JMXUtils.getMBeanServer(ctx, listener, timeout);
            long startTime = System.currentTimeMillis();
            while (!started && System.currentTimeMillis() - startTime < (long)(timeout * 1000)) {
                try {
                    Thread.sleep(1000L);
                    started = JMXUtils.isServerStarted(server);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to wait: " + e.getMessage(), e);
                    return started;
                }
            }
        }
        catch (RuntimeException e) {
            if (ignoreErrors) return started;
            throw e;
        }
    }

    public static boolean checkDeploy(String hostName, int jndiPort, BuildListener listener, int timeout, String[] modules) {
        listener.getLogger().println("Verification of deplyed modules started");
        InitialContext ctx = JMXUtils.getInitialContext(hostName, jndiPort);
        MBeanServerConnection server = JMXUtils.getMBeanServer(ctx, listener, timeout);
        boolean deployed = true;
        for (String moduleName : modules) {
            boolean ok;
            if (moduleName.endsWith(".ear")) {
                ok = JMXUtils.checkEARDeploymentState(listener, server, moduleName);
                listener.getLogger().println(String.format("Verifying deployment of the EAR '%s' ... %s", moduleName, ok ? "SUCCESS" : "FAILED"));
                deployed &= ok;
                continue;
            }
            if (moduleName.endsWith("-ejb.jar")) {
                ok = JMXUtils.checkEJBDeploymentState(listener, server, moduleName);
                listener.getLogger().println(String.format("Verifying deployment of the EJB '%s' ... %s", moduleName, ok ? "SUCCESS" : "FAILED"));
                deployed &= ok;
                continue;
            }
            if (moduleName.endsWith(".war")) {
                ok = JMXUtils.checkWARDeploymentState(listener, server, moduleName);
                listener.getLogger().println(String.format("Verifying deployment of the WAR '%s' ... %s", moduleName, ok ? "SUCCESS" : "FAILED"));
                deployed &= ok;
                continue;
            }
            listener.error(String.format("Unknown type of the module '%s'. Cannot verify deployment.", moduleName));
            deployed = false;
        }
        listener.getLogger().println("Verification finished.");
        return deployed;
    }

    public static boolean checkWARDeploymentState(BuildListener listener, MBeanServerConnection server, String warName) {
        try {
            String objectPattern = String.format("jboss.web.deployment:*,war=%s", warName);
            Set<ObjectName> set = server.queryNames(new ObjectName(objectPattern), null);
            if (set == null || set.size() == 0) {
                return false;
            }
            ObjectName serverMBeanName = set.iterator().next();
            return 3 == (Integer)server.getAttribute(serverMBeanName, "State");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkEARDeploymentState(BuildListener listener, MBeanServerConnection server, String earName) {
        try {
            ObjectName serverMBeanName = new ObjectName(String.format("jboss.j2ee:service=EARDeployment,url='%s'", earName));
            return 3 == (Integer)server.getAttribute(serverMBeanName, "State");
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.fatalError(e.getMessage());
            return false;
        }
    }

    public static boolean checkEJBDeploymentState(BuildListener listener, MBeanServerConnection server, String ejbName) {
        try {
            ObjectName serverMBeanName = new ObjectName(String.format("jboss.j2ee:service=EjbModule,module=%s", ejbName));
            return 3 == (Integer)server.getAttribute(serverMBeanName, "State");
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.fatalError(e.getMessage());
            return false;
        }
    }
}

