/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.klaros;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.klaros.KlarosTestResultPublisher;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class KlarosTestResultPublisher
extends Recorder {
    private String config;
    private String env;
    private String sut;
    private String type = "junit";
    private String pathTestResults;
    private String url;

    @DataBoundConstructor
    public KlarosTestResultPublisher(String config, String env, String sut, String type, String pathTestResults, String url) {
        this.config = config;
        this.env = env;
        this.sut = sut;
        this.pathTestResults = pathTestResults;
        this.url = url;
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSut() {
        return this.sut;
    }

    public void setSut(String sut) {
        this.sut = sut;
    }

    public String getPathTestResults() {
        return this.pathTestResults;
    }

    public void setPathTestResults(String pathTestResults) {
        this.pathTestResults = pathTestResults;
    }

    public List<String> getUrls() {
        return KlarosTestResultPublisher.descriptor().getUrls();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean result;
        if (this.pathTestResults == null) {
            listener.getLogger().println("There are no test result to import!");
            result = false;
        } else {
            listener.getLogger().println("The test result(s) contained in target " + this.pathTestResults + " will be exported to the " + "Klaros-Testmanagement Server at " + this.getUrl(this.url) + ".");
            listener.getLogger().println("With parameters Project[" + this.config + "], Environment[" + this.env + "], SUT[" + this.sut + "] and Type[" + this.type + "].");
            FilePath ws = build.getWorkspace();
            if (ws == null) {
                listener.error("No workspace defined!");
                build.setResult(Result.FAILURE);
                result = false;
            } else {
                try {
                    FileCallableImplementation exporter = new FileCallableImplementation(this, listener, null);
                    ws.act((FilePath.FileCallable)exporter);
                }
                catch (IOException e) {
                    listener.getLogger().println("Failure to export test result(s).");
                    e.printStackTrace(listener.getLogger());
                }
                catch (InterruptedException e) {
                    listener.getLogger().println("Failure to export test result(s).");
                    e.printStackTrace(listener.getLogger());
                }
                listener.getLogger().println("Test result(s) successfully exported.");
                result = true;
            }
        }
        return result;
    }

    public String getUrl(String sourceURL) {
        String result = null;
        if (sourceURL == null) {
            List urls = KlarosTestResultPublisher.descriptor().getUrls();
            if (urls.size() >= 1) {
                result = (String)urls.get(0);
            }
            return result;
        }
        for (String j : KlarosTestResultPublisher.descriptor().getUrls()) {
            if (!j.equals(sourceURL)) continue;
            result = j;
            break;
        }
        return result;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return KlarosTestResultPublisher.descriptor();
    }

    static /* synthetic */ String access$100(KlarosTestResultPublisher x0) {
        return x0.pathTestResults;
    }

    static /* synthetic */ String access$200(KlarosTestResultPublisher x0) {
        return x0.url;
    }

    static /* synthetic */ String access$300(KlarosTestResultPublisher x0) {
        return x0.config;
    }

    static /* synthetic */ String access$400(KlarosTestResultPublisher x0) {
        return x0.env;
    }

    static /* synthetic */ String access$500(KlarosTestResultPublisher x0) {
        return x0.sut;
    }

    static /* synthetic */ String access$600(KlarosTestResultPublisher x0) {
        return x0.type;
    }
}

