// CHECKSTYLE:OFF

package hudson.plugins.klaros;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * At least one Klaros-Testmanagement server installation must be defined in the global settings.
     * 
     */
    public static String ErrorMissingInstallation() {
        return holder.format("ErrorMissingInstallation");
    }

    /**
     * At least one Klaros-Testmanagement server installation must be defined in the global settings.
     * 
     */
    public static Localizable _ErrorMissingInstallation() {
        return new Localizable(holder, "ErrorMissingInstallation");
    }

    /**
     * Publish test results to Klaros-Testmanagement
     * 
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Publish test results to Klaros-Testmanagement
     * 
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

    /**
     * Connection established
     * 
     */
    public static String ConnectionEstablished() {
        return holder.format("ConnectionEstablished");
    }

    /**
     * Connection established
     * 
     */
    public static Localizable _ConnectionEstablished() {
        return new Localizable(holder, "ConnectionEstablished");
    }

}
