/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.labmanager;

import hudson.Plugin;
import hudson.model.Hudson;
import hudson.plugins.labmanager.LabManager;
import hudson.plugins.labmanager.LabManagerVirtualMachine;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());

    public void start() throws Exception {
        LOGGER.log(Level.FINE, "Starting LabManager plugin");
        super.start();
    }

    public void stop() throws Exception {
        LOGGER.log(Level.FINE, "Stopping LabManager plugin.");
        super.stop();
    }

    public void doComputerNameValues(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        List virtualMachines = null;
        for (Cloud cloud : Hudson.getInstance().clouds) {
            if (!(cloud instanceof LabManager)) continue;
            LabManager labmanager = (LabManager)cloud;
            if (value == null || !value.equals(labmanager.getLmDescription())) continue;
            virtualMachines = labmanager.getLabManagerVirtualMachines();
            break;
        }
        if (virtualMachines != null) {
            for (LabManagerVirtualMachine vm : virtualMachines) {
                m.add((Object)new ListBoxModel.Option(vm.getName(), vm.getName()));
            }
            ((ListBoxModel.Option)m.get((int)0)).selected = true;
        }
        m.writeTo(req, rsp);
    }
}

