/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineSlave
extends Slave {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineSlave.class.getName());
    private String hypervisorDescription;
    private String virtualMachineName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VirtualMachineSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, VirtualMachineLauncher launcher, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String hypervisorDescription, String virtualMachineName) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, Util.tryParseNumber((String)numExecutors, (Number)1).intValue(), mode, labelString, (ComputerLauncher)(launcher == null ? new VirtualMachineLauncher(delegateLauncher, hypervisorDescription, virtualMachineName) : launcher), retentionStrategy, nodeProperties);
        this.hypervisorDescription = hypervisorDescription;
        this.virtualMachineName = virtualMachineName;
    }

    public String getHypervisorDescription() {
        return this.hypervisorDescription;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((VirtualMachineLauncher)this.getLauncher()).getDelegate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        private String hypervisorDescription;
        private String virtualMachineName;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual computer running on a virtualization platform (via libvirt)";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<VirtualMachine> getDefinedVirtualMachines(String hypervisorDescription) {
            ArrayList<VirtualMachine> virtualMachinesList = new ArrayList<VirtualMachine>();
            if (hypervisorDescription != null && !hypervisorDescription.equals("")) {
                Hypervisor hypervisor = null;
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(hypervisorDescription)) continue;
                    hypervisor = (Hypervisor)cloud;
                    break;
                }
                virtualMachinesList.addAll(hypervisor.getVirtualMachines());
            }
            return virtualMachinesList;
        }

        public List<Hypervisor> getHypervisors() {
            ArrayList<Hypervisor> result = new ArrayList<Hypervisor>();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof Hypervisor)) continue;
                result.add((Hypervisor)cloud);
            }
            return result;
        }

        public List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor launcher : Functions.getComputerLauncherDescriptors()) {
                if (VirtualMachineLauncher.DESCRIPTOR.getClass().isAssignableFrom(launcher.getClass())) continue;
                result.add((Descriptor<ComputerLauncher>)launcher);
            }
            return result;
        }

        public String getHypervisorDescription() {
            return this.hypervisorDescription;
        }

        public String getVirtualMachineName() {
            return this.virtualMachineName;
        }
    }
}

