/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.plugins.libvirt.Hypervisor;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachine
implements Serializable,
Comparable<VirtualMachine> {
    private final String name;
    private final Hypervisor hypervisor;

    @DataBoundConstructor
    public VirtualMachine(Hypervisor hypervisor, String name) {
        this.hypervisor = hypervisor;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine that = (VirtualMachine)o;
        if (this.hypervisor != null ? !((Object)((Object)this.hypervisor)).equals((Object)that.hypervisor) : that.hypervisor != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.hypervisor != null ? ((Object)((Object)this.hypervisor)).hashCode() : 0);
        return result;
    }

    public String getDisplayName() {
        return this.name + "@" + this.hypervisor.getHypervisorHost();
    }

    @Override
    public int compareTo(VirtualMachine o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualComputer");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", hypervisor=").append((Object)this.hypervisor);
        sb.append('}');
        return sb.toString();
    }
}

