/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.libvirt.Domain;
import org.libvirt.DomainInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineLauncher
extends ComputerLauncher {
    private ComputerLauncher delegate;
    private transient VirtualMachine virtualMachine;
    private String hypervisorDescription;
    private String virtualMachineName;
    private static final int RETRY_TIMES = 100;
    @Extension
    public static final Descriptor<ComputerLauncher> DESCRIPTOR = new Descriptor<ComputerLauncher>(){
        private String hypervisorDescription;
        private String virtualMachineName;
        private ComputerLauncher delegate;

        public String getDisplayName() {
            return "Virtual Machine Launcher";
        }

        public String getHypervisorDescription() {
            return this.hypervisorDescription;
        }

        public String getVirtualMachineName() {
            return this.virtualMachineName;
        }

        public ComputerLauncher getDelegate() {
            return this.delegate;
        }
    };

    @DataBoundConstructor
    public VirtualMachineLauncher(ComputerLauncher delegate, String hypervisorDescription, String virtualMachineName) {
        this.delegate = delegate;
        this.virtualMachineName = virtualMachineName;
        this.hypervisorDescription = hypervisorDescription;
        this.buildVirtualMachine();
    }

    private void buildVirtualMachine() {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            Hypervisor hypervisor = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(this.hypervisorDescription)) continue;
                hypervisor = (Hypervisor)cloud;
                break;
            }
            for (VirtualMachine vm : hypervisor.getVirtualMachines()) {
                if (!vm.getName().equals(this.virtualMachineName)) continue;
                this.virtualMachine = vm;
                break;
            }
        }
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public boolean isLaunchSupported() {
        return this.delegate.isLaunchSupported();
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        taskListener.getLogger().println("Getting connection to the virtual datacenter");
        try {
            taskListener.getLogger().println("Target virtual computer: " + this.virtualMachine);
            Map<String, Domain> computers = this.virtualMachine.getHypervisor().getDomains();
            taskListener.getLogger().println("Finding the computer");
            for (String domainName : computers.keySet()) {
                if (!this.virtualMachine.getName().equals(domainName)) continue;
                taskListener.getLogger().println("Found the computer");
                Domain domain = computers.get(domainName);
                if (domain.getInfo().state != DomainInfo.DomainState.VIR_DOMAIN_BLOCKED && domain.getInfo().state != DomainInfo.DomainState.VIR_DOMAIN_RUNNING) {
                    taskListener.getLogger().println("Starting virtual computer");
                    domain.create();
                } else {
                    taskListener.getLogger().println("Virtual computer is already running");
                }
                taskListener.getLogger().println("Starting stage 2 launcher");
                int i = 0;
                boolean finish = false;
                while (i < 100 && !finish) {
                    try {
                        finish = true;
                    }
                    catch (Exception e) {
                        ++i;
                        ((Object)((Object)this)).wait(5000L);
                    }
                }
                this.delegate.launch(slaveComputer, taskListener);
                taskListener.getLogger().println("Stage 2 launcher completed");
                return;
            }
            taskListener.getLogger().println("Could not find the computer");
            throw new IOException("Could not find the computer");
        }
        catch (IOException e) {
            e.printStackTrace(taskListener.getLogger());
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace(taskListener.getLogger());
            return;
        }
    }

    public void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        taskListener.getLogger().println("Starting stage 2 afterDisconnect");
        this.delegate.afterDisconnect(slaveComputer, taskListener);
        taskListener.getLogger().println("Getting connection to the virtual datacenter");
        try {
            Map<String, Domain> computers = this.virtualMachine.getHypervisor().getDomains();
            taskListener.getLogger().println("Finding the computer");
            for (String domainName : computers.keySet()) {
                if (!this.virtualMachine.getName().equals(domainName)) continue;
                Domain domain = computers.get(domainName);
                taskListener.getLogger().println("Found the computer");
                if (domain.getInfo().state.equals((Object)DomainInfo.DomainState.VIR_DOMAIN_RUNNING) || domain.getInfo().state.equals((Object)DomainInfo.DomainState.VIR_DOMAIN_BLOCKED)) {
                    taskListener.getLogger().println("Suspending virtual computer");
                    domain.shutdown();
                } else {
                    taskListener.getLogger().println("Virtual computer is already suspended");
                }
                return;
            }
            taskListener.getLogger().println("Could not find the computer");
        }
        catch (Throwable t) {
            taskListener.fatalError(t.getMessage(), new Object[]{t});
        }
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return Hudson.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }
}

