/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.model.Label;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hypervisor
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(Hypervisor.class.getName());
    private final String hypervisorType;
    private final String hypervisorHost;
    private final String hypervisorSystemUrl;
    private final int hypervisorSshPort;
    private final String username;
    private transient Map<String, Domain> domains = null;
    private transient List<VirtualMachine> virtualMachineList = null;
    private transient Connect hypervisorConnection = null;

    @DataBoundConstructor
    public Hypervisor(String hypervisorType, String hypervisorHost, int hypervisorSshPort, String hypervisorSystemUrl, String username) {
        super("Hypervisor(libvirt)");
        this.hypervisorType = hypervisorType;
        this.hypervisorHost = hypervisorHost;
        this.hypervisorSystemUrl = hypervisorSystemUrl != null && !hypervisorSystemUrl.equals("") ? hypervisorSystemUrl : "system";
        this.hypervisorSshPort = hypervisorSshPort <= 0 ? 22 : hypervisorSshPort;
        this.username = username;
        this.makeConnection();
        this.virtualMachineList = this.retrieveVirtualMachines();
    }

    private void makeConnection() {
        if (this.hypervisorConnection == null) {
            String hypervisorUri = this.constructHypervisorURI();
            LOGGER.log(Level.INFO, "Trying to establish a connection to hypervisor URI: {0} as {1}/******", new Object[]{hypervisorUri, this.username});
            try {
                this.hypervisorConnection = new Connect(hypervisorUri, false);
                LOGGER.log(Level.INFO, "Established connection to hypervisor URI: {0} as {1}/******", new Object[]{hypervisorUri, this.username});
            }
            catch (LibvirtException e) {
                LogRecord rec = new LogRecord(Level.WARNING, "Failed to establish connection to hypervisor URI: {0} as {1}/******");
                rec.setThrown(e);
                rec.setParameters(new Object[]{hypervisorUri, this.username});
                LOGGER.log(rec);
            }
        }
    }

    private List<VirtualMachine> retrieveVirtualMachines() {
        ArrayList<VirtualMachine> vmList = new ArrayList<VirtualMachine>();
        try {
            this.domains = this.getDomains();
            for (String domainName : this.domains.keySet()) {
                vmList.add(new VirtualMachine(this, domainName));
            }
        }
        catch (Exception e) {
            LogRecord rec = new LogRecord(Level.SEVERE, "Cannot connect to datacenter {0} as {1}/******");
            rec.setThrown(e);
            rec.setParameters(new Object[]{this.hypervisorHost, this.username});
            LOGGER.log(rec);
        }
        return vmList;
    }

    public String getHypervisorHost() {
        return this.hypervisorHost;
    }

    public int getHypervisorSshPort() {
        return this.hypervisorSshPort;
    }

    public String getHypervisorType() {
        return this.hypervisorType;
    }

    public String getHypervisorSystemUrl() {
        return this.hypervisorSystemUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHypervisorDescription() {
        return this.getHypervisorType() + " - " + this.getHypervisorHost();
    }

    public synchronized Map<String, Domain> getDomains() throws LibvirtException {
        LogRecord rec;
        Domain domain;
        HashMap<String, Domain> domains = new HashMap<String, Domain>();
        for (String c : this.hypervisorConnection.listDefinedDomains()) {
            if (c == null || c.equals("")) continue;
            domain = null;
            try {
                domain = this.hypervisorConnection.domainLookupByName(c);
                domains.put(domain.getName(), domain);
            }
            catch (Exception e) {
                rec = new LogRecord(Level.INFO, "Error retreiving information for domain with name: {0}");
                rec.setParameters(new Object[]{c});
                rec.setThrown(e);
                LOGGER.log(rec);
            }
        }
        for (int c : this.hypervisorConnection.listDomains()) {
            domain = null;
            try {
                domain = this.hypervisorConnection.domainLookupByID(c);
                domains.put(domain.getName(), domain);
            }
            catch (Exception e) {
                rec = new LogRecord(Level.INFO, "Error retreiving information for domain with id: {0}");
                rec.setParameters(new Object[]{c});
                rec.setThrown(e);
                LOGGER.log(rec);
            }
        }
        return domains;
    }

    public synchronized List<VirtualMachine> getVirtualMachines() {
        if (this.virtualMachineList == null) {
            this.makeConnection();
            this.virtualMachineList = this.retrieveVirtualMachines();
        }
        return this.virtualMachineList;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int i) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hypervisor");
        sb.append("{hypervisorUri='").append(this.hypervisorHost).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String constructHypervisorURI() {
        return this.hypervisorType.toLowerCase() + "+ssh://" + this.username + "@" + this.hypervisorHost + ":" + this.hypervisorSshPort + "/" + this.hypervisorSystemUrl + "?no_tty=1";
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

